/*
 * Decompiled with CFR 0.152.
 */
package com.advancedcombat.util;

import com.advancedcombat.crafting.RecipeEnchantmentUpgrade;
import com.advancedcombat.util.JointList;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ACUtils {
    private static Map<RecipeEnchantmentUpgrade, List<ItemStack>> enchCache = new HashMap<RecipeEnchantmentUpgrade, List<ItemStack>>();

    public static int getBlockSourceMetadata(IBlockSource src) {
        try {
            return src.func_189992_e().func_177230_c().func_176201_c(src.func_189992_e());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static EnumFacing getDispenserFacing(int meta) {
        return EnumFacing.func_82600_a((int)(meta & 7));
    }

    public static List<ItemStack> getAllEnchantables(RecipeEnchantmentUpgrade u) {
        if (!enchCache.containsKey((Object)u)) {
            JointList list = new JointList();
            Set itemNames = Item.field_150901_e.func_148742_b();
            for (ResourceLocation itemName : itemNames) {
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)itemName);
                ItemStack stack = new ItemStack(item);
                if (!u.getEnchantment().func_92089_a(stack)) continue;
                list.add(stack);
            }
            enchCache.put(u, list);
        }
        return enchCache.get((Object)u);
    }

    public static boolean areItemStacksEqualForCrafting(ItemStack ... stacks) {
        ItemStack comp = stacks[0];
        if (comp.func_190926_b()) {
            return false;
        }
        ItemStack comp1 = comp.func_77946_l();
        comp1.func_190920_e(1);
        for (int n = 1; n < stacks.length; ++n) {
            if (stacks[n].func_190926_b()) {
                return false;
            }
            ItemStack comp2 = stacks[n].func_77946_l();
            comp2.func_190920_e(1);
            if (ItemStack.func_77989_b((ItemStack)comp1, (ItemStack)comp2)) continue;
            return false;
        }
        return true;
    }

    public static boolean doesItemStackListContain(List<ItemStack> list, ItemStack comp, boolean remove) {
        ItemStack comp1 = comp.func_77946_l();
        comp1.func_190920_e(1);
        for (ItemStack stack : list) {
            ItemStack stack1 = stack.func_77946_l();
            stack1.func_190920_e(1);
            if (!ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)comp1)) continue;
            if (remove) {
                list.remove(stack);
            }
            return true;
        }
        return false;
    }

    public static boolean doesItemStackListContain(List<ItemStack> list, Item comp, boolean remove) {
        return ACUtils.doesItemStackListContain(list, new ItemStack(comp), remove);
    }

    public static boolean doesItemStackListContain(List<ItemStack> list, Block comp, boolean remove) {
        return ACUtils.doesItemStackListContain(list, new ItemStack(comp), remove);
    }

    public static <E> Method findMethod(Class<? super E> clazz, E instance, String[] methodNames, Class<?> ... methodTypes) {
        Exception failed = null;
        for (String methodName : methodNames) {
            try {
                Method m = clazz.getDeclaredMethod(methodName, methodTypes);
                m.setAccessible(true);
                return m;
            }
            catch (Exception e) {
                failed = e;
            }
        }
        throw new ReflectionHelper.UnableToFindMethodException(methodNames, failed);
    }
}

