/*
 * Decompiled with CFR 0.152.
 */
package com.advancedcombat.util;

import com.advancedcombat.config.ACConfig;
import com.advancedcombat.util.ACUtils;
import com.advancedcombat.util.EntityDistanceSorter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.PositionImpl;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class TrackingDispenserBehavior {
    public static int range = ACConfig.trackingDispenserRange;

    public abstract ItemStack dispenseStack(IBlockSource var1, ItemStack var2);

    public Vec3d getNearestTargetDirection(World world, BlockPos pos) {
        Vec3d pos2 = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        List ents = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos.func_177979_c(range).func_177965_g(range).func_177970_e(range), pos.func_177981_b(range).func_177985_f(range).func_177964_d(range)));
        ents.sort(new EntityDistanceSorter(pos));
        for (EntityLivingBase e : ents) {
            if (!this.canEntityBeSeen((Entity)e, pos)) continue;
            return new Vec3d(e.field_70165_t - pos2.field_72450_a, e.field_70163_u - pos2.field_72448_b, e.field_70161_v - pos2.field_72449_c).func_72432_b();
        }
        return null;
    }

    private boolean canEntityBeSeen(Entity e, BlockPos pos) {
        if (!(e instanceof EntityPlayer) || !((EntityPlayer)e).field_71075_bZ.field_75102_a) {
            Vec3d pos2 = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            return e.field_70170_p.func_72933_a(new Vec3d(pos2.field_72450_a + 1.0, pos2.field_72448_b, pos2.field_72449_c + 0.0), new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) == null || e.field_70170_p.func_72933_a(new Vec3d(pos2.field_72450_a + 0.0, pos2.field_72448_b, pos2.field_72449_c + 1.0), new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) == null || e.field_70170_p.func_72933_a(new Vec3d(pos2.field_72450_a - 1.0, pos2.field_72448_b, pos2.field_72449_c + 0.0), new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) == null || e.field_70170_p.func_72933_a(new Vec3d(pos2.field_72450_a + 0.0, pos2.field_72448_b, pos2.field_72449_c - 1.0), new Vec3d(e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) == null;
        }
        return false;
    }

    public static class BehaviorTrackingFireballDispense
    extends TrackingDispenserBehavior {
        @Override
        public ItemStack dispenseStack(IBlockSource source, ItemStack stack) {
            World world = source.func_82618_k();
            BlockPos pos = source.func_180699_d();
            Vec3d pos2 = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            Vec3d dir = this.getNearestTargetDirection(world, pos);
            if (dir == null) {
                return null;
            }
            PositionImpl ipos = new PositionImpl(pos2.field_72450_a + dir.field_72450_a * 0.75, pos2.field_72448_b + dir.field_72448_b * 0.75, pos2.field_72449_c + dir.field_72449_c * 0.75);
            double d0 = ipos.func_82615_a();
            double d1 = ipos.func_82617_b();
            double d2 = ipos.func_82616_c();
            Random random = world.field_73012_v;
            double d3 = random.nextGaussian() * 0.05 + dir.field_72450_a;
            double d4 = random.nextGaussian() * 0.05 + dir.field_72448_b;
            double d5 = random.nextGaussian() * 0.05 + dir.field_72449_c;
            world.func_72838_d((Entity)new EntitySmallFireball(world, d0, d1, d2, d3, d4, d5));
            stack.func_77979_a(1);
            return stack;
        }
    }

    public static class BehaviorTrackingProjectileDispense
    extends TrackingDispenserBehavior {
        BehaviorProjectileDispense standard;

        public BehaviorTrackingProjectileDispense(BehaviorProjectileDispense standard) {
            this.standard = standard;
        }

        @Override
        public ItemStack dispenseStack(IBlockSource source, ItemStack stack) {
            World world = source.func_82618_k();
            BlockPos pos = source.func_180699_d();
            Vec3d pos2 = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            Vec3d dir = this.getNearestTargetDirection(world, pos);
            if (dir == null) {
                return null;
            }
            PositionImpl ipos = new PositionImpl(pos2.field_72450_a + dir.field_72450_a * 0.75, pos2.field_72448_b + dir.field_72448_b * 0.75, pos2.field_72449_c + dir.field_72449_c * 0.75);
            IProjectile iproj = this.getProjectileEntity(this.standard, world, (IPosition)ipos, stack);
            iproj.func_70186_c(dir.field_72450_a, dir.field_72448_b + (double)0.1f, dir.field_72449_c, this.getProjectileVelocity(this.standard), this.getProjectileInaccuracy(this.standard));
            world.func_72838_d((Entity)iproj);
            stack.func_77979_a(1);
            return stack;
        }

        private IProjectile getProjectileEntity(BehaviorProjectileDispense standard, World world, IPosition pos, ItemStack stack) {
            Method m = ACUtils.findMethod(BehaviorProjectileDispense.class, standard, new String[]{"getProjectileEntity", "func_82499_a"}, World.class, IPosition.class, ItemStack.class);
            try {
                return (IProjectile)m.invoke((Object)standard, world, pos, stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private float getProjectileVelocity(BehaviorProjectileDispense standard) {
            Method m = ACUtils.findMethod(BehaviorProjectileDispense.class, standard, new String[]{"getProjectileVelocity", "func_82500_b"}, new Class[0]);
            try {
                return ((Float)m.invoke((Object)standard, new Object[0])).floatValue();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0.0f;
            }
        }

        private float getProjectileInaccuracy(BehaviorProjectileDispense standard) {
            Method m = ACUtils.findMethod(BehaviorProjectileDispense.class, standard, new String[]{"getProjectileInaccuracy", "func_82498_a"}, new Class[0]);
            try {
                return ((Float)m.invoke((Object)standard, new Object[0])).floatValue();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0.0f;
            }
        }
    }
}

