/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.heroes.ironman.armors;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import thecrafterl.mods.heroes.ironman.IronMan;
import thecrafterl.mods.heroes.ironman.models.ModelIMArmor;

public class ItemIronManArmor
extends ItemArmor {
    private String name;
    public int mark;
    private String lore;
    public float scale;
    public boolean isWarMachine;
    public static final ItemArmor.ArmorMaterial mark2 = EnumHelper.addArmorMaterial((String)"mark2", (int)25, (int[])new int[]{3, 7, 5, 2}, (int)0);
    public static final ItemArmor.ArmorMaterial mark4 = EnumHelper.addArmorMaterial((String)"mark4", (int)30, (int[])new int[]{3, 8, 6, 3}, (int)0);
    public static final ItemArmor.ArmorMaterial mark5 = EnumHelper.addArmorMaterial((String)"mark5", (int)28, (int[])new int[]{3, 7, 6, 3}, (int)0);
    public static final ItemArmor.ArmorMaterial mark7 = EnumHelper.addArmorMaterial((String)"mark7", (int)33, (int[])new int[]{4, 9, 7, 4}, (int)0);

    public ItemIronManArmor(String name, ArmorTypes type, int armorPart) {
        super(type.getMaterial(), IronMan.proxy.addArmor("MK" + type.getMark()), armorPart);
        this.func_77655_b(name);
        if (!type.isWarMachine) {
            this.func_111206_d("IronMan:armors/MK" + type.getMark() + "/MK" + type.getMark() + "." + name);
            GameRegistry.registerItem((Item)this, (String)("MK" + type.getMark() + "." + name));
        } else {
            this.func_111206_d("IronMan:armors/WM_MK" + type.getMark() + "/MK" + type.getMark() + "." + name);
            GameRegistry.registerItem((Item)this, (String)("WM_MK" + type.getMark() + "." + name));
        }
        this.func_77637_a(IronMan.tabIronManArmor);
        this.name = name;
        this.mark = type.getMark();
        this.lore = type.getLore();
        this.scale = type.getScale();
        this.isWarMachine = type.isWarMachine;
        this.func_77656_e(type.getMaterial().func_78046_a(armorPart));
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (this.mark == 99) {
            list.add("Mark 2 : Iron Patriot");
        } else if (this.lore.equals("")) {
            list.add("Mark " + this.mark);
        } else {
            list.add("Mark " + this.mark + " : " + this.lore);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (!this.isWarMachine) {
            if (slot == 2) {
                return "IronMan:textures/models/armor/MK" + this.mark + "/armor_2.png";
            }
            return "IronMan:textures/models/armor/MK" + this.mark + "/armor_1.png";
        }
        if (slot == 2) {
            return "IronMan:textures/models/armor/WM_MK" + this.mark + "/armor_2.png";
        }
        return "IronMan:textures/models/armor/WM_MK" + this.mark + "/armor_1.png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        ModelIMArmor armorModel = null;
        if (itemStack != null && (armorModel = new ModelIMArmor(this.scale)) != null) {
            EntityPlayer player;
            armorModel.field_78116_c.field_78806_j = armorSlot == 0;
            armorModel.field_78114_d.field_78806_j = armorSlot == 0;
            armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
            armorModel.field_78112_f.field_78806_j = armorSlot == 1;
            armorModel.field_78113_g.field_78806_j = armorSlot == 1;
            armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78117_n = entityLiving.func_70093_af();
            armorModel.field_78093_q = entityLiving.func_70115_ae();
            armorModel.field_78091_s = entityLiving.func_70631_g_();
            ItemStack heldItem = entityLiving.func_71124_b(0);
            if (heldItem != null) {
                armorModel.field_78120_m = 1;
            }
            if (entityLiving instanceof EntityPlayer && (player = (EntityPlayer)entityLiving).func_71052_bv() > 0) {
                if (heldItem.func_77975_n() == EnumAction.bow) {
                    armorModel.field_78118_o = true;
                } else if (heldItem.func_77975_n() == EnumAction.block) {
                    armorModel.field_78120_m = 3;
                }
            }
            return armorModel;
        }
        return null;
    }

    public static enum ArmorTypes {
        MK1(1, ItemArmor.ArmorMaterial.IRON, 0.5f, 0.05, 0.01, 0.07, 0.05, 0.09, 1, false),
        MK2(2, mark2, 0.1f, 0.9, 0.08, 0.4, 0.08, 0.12, 2, false),
        MK3(3, mark2, 0.1f, 0.9, 0.08, 0.4, 0.08, 0.12, 2, false),
        MK4(4, mark4, 0.1f, 0.13, 0.13, 0.6, 0.1, 0.18, 2, false),
        MK5(5, mark5, 0.1f, 0.11, 0.1, 0.5, 0.09, 0.15, 2, false),
        MK6(6, mark4, 0.1f, 0.16, 0.16, 0.8, 0.12, 0.2, 3, false),
        MK7(7, mark7, 0.1f, 0.16, 0.16, 0.8, 0.12, 0.2, 3, false),
        MK39(39, mark7, 0.1f, 0.16, 0.16, 0.8, 0.12, 0.2, 3, false, "Starboost"),
        WM_MK1(1, mark4, 0.1f, 0.13, 0.13, 0.6, 0.1, 0.18, 2, true, "War Machine"),
        WM_MK2(2, mark7, 0.1f, 0.16, 0.16, 0.8, 0.12, 0.2, 3, true, "War Machine"),
        IP(99, mark7, 0.1f, 0.16, 0.16, 0.8, 0.12, 0.2, 3, true, "Iron Patriot");

        private int mark;
        private String lore = "";
        private double accelVertical;
        private double speedSideways;
        private double speedVertical;
        private double speedVerticalHoverSlow;
        private double speedVerticalHover;
        private int chargeSpeed;
        private float scale;
        private boolean isWarMachine;
        private ItemArmor.ArmorMaterial material;

        private ArmorTypes(int mark, ItemArmor.ArmorMaterial material, float f, double accelVertical, double speedSideways, double speedVertical, double speedVerticalHoverSlow, double speedVerticalHover, int chargeSpeed, boolean warmachine) {
            this.mark = mark;
            this.material = material;
            this.accelVertical = accelVertical;
            this.speedSideways = speedSideways;
            this.speedVertical = speedVertical;
            this.speedVerticalHoverSlow = speedVerticalHoverSlow;
            this.speedVerticalHover = speedVerticalHover;
            this.chargeSpeed = chargeSpeed;
            this.scale = f;
            this.isWarMachine = warmachine;
        }

        private ArmorTypes(int mark, ItemArmor.ArmorMaterial material, float f, double accelVertical, double speedSideways, double speedVertical, double speedVerticalHoverSlow, double speedVerticalHover, int chargeSpeed, boolean warmachine, String lore) {
            this.mark = mark;
            this.lore = lore;
            this.material = material;
            this.accelVertical = accelVertical;
            this.speedSideways = speedSideways;
            this.speedVertical = speedVertical;
            this.speedVerticalHoverSlow = speedVerticalHoverSlow;
            this.speedVerticalHover = speedVerticalHover;
            this.chargeSpeed = chargeSpeed;
            this.scale = f;
            this.isWarMachine = warmachine;
        }

        public int getMark() {
            return this.mark;
        }

        public float getScale() {
            return this.scale;
        }

        public double getAccelVertival() {
            return this.accelVertical;
        }

        public double getSpeedSideways() {
            return this.speedSideways;
        }

        public double getSpeedVertical() {
            return this.speedVertical;
        }

        public double getSpeedVerticalHoverSlow() {
            return this.speedVerticalHoverSlow;
        }

        public double getSpeedVerticalHover() {
            return this.speedVerticalHover;
        }

        public int getChargeSpeed() {
            return this.chargeSpeed;
        }

        public String getLore() {
            return this.lore;
        }

        public ItemArmor.ArmorMaterial getMaterial() {
            return this.material;
        }

        public boolean isWarMachine() {
            return this.isWarMachine;
        }
    }
}

