/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.heroes.ironman.armors;

import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thecrafterl.mods.heroes.ironman.IronMan;
import thecrafterl.mods.heroes.ironman.IronManConfig;
import thecrafterl.mods.heroes.ironman.armors.IMArmors;
import thecrafterl.mods.heroes.ironman.armors.ItemIronManArmor;
import thecrafterl.mods.heroes.ironman.armors.ItemIronManArmorChestplate;
import thecrafterl.mods.heroes.ironman.network.SyncTracker;

public class ItemIronManArmorBoots
extends ItemIronManArmor {
    private double accelVertical;
    private double speedSideways;
    private double speedVertical;
    private double speedVerticalHoverSlow;
    private double speedVerticalHover;
    private static final Random rand = new Random();

    public ItemIronManArmorBoots(String name, ItemIronManArmor.ArmorTypes type, int armorPart) {
        super(name, type, armorPart);
        this.accelVertical = type.getAccelVertival();
        this.speedSideways = type.getSpeedSideways();
        this.speedVertical = type.getSpeedVertical();
        this.speedVerticalHoverSlow = type.getSpeedVerticalHoverSlow();
        this.speedVerticalHover = type.getSpeedVerticalHover();
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74757_a("Hover", false);
        stack.field_77990_d.func_74757_a("Enable", true);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (this.isOn(stack)) {
            this.useJetpack((EntityLivingBase)player, stack, false);
        }
        if (!IronManConfig.disableNoFallDamage && stack.func_77973_b() != IMArmors.MK1boots) {
            player.field_70143_R = 0.0f;
        }
    }

    public boolean isHoverModeOn(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74757_a("Hover", false);
            stack.field_77990_d.func_74757_a("Enable", true);
        }
        return stack.field_77990_d.func_74767_n("Hover");
    }

    public boolean isOn(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74757_a("Hover", false);
            stack.field_77990_d.func_74757_a("Enable", true);
        }
        return stack.field_77990_d.func_74767_n("Enable");
    }

    private void useJetpack(EntityLivingBase user, ItemStack armor, boolean force) {
        boolean hoverMode = this.isHoverModeOn(armor);
        double hoverSpeed = true == SyncTracker.isDescendKeyDown(user) ? this.speedVerticalHoverSlow : this.speedVerticalHover;
        boolean flyKeyDown = force || SyncTracker.isFlyKeyDown(user);
        boolean descendKeyDown = SyncTracker.isDescendKeyDown(user);
        float speedSideways = (float)(user.func_70093_af() ? this.speedSideways * 0.5 : this.speedSideways);
        double currentAccel = user.field_70181_x < 0.3 ? this.accelVertical * 2.5 : this.accelVertical;
        EntityPlayer player = (EntityPlayer)user;
        if (flyKeyDown && player.func_82169_q(2) != null && player.func_82169_q(2).func_77973_b() instanceof ItemIronManArmorChestplate && IronMan.isSameArmorSet(player.func_82169_q(2), armor)) {
            ItemIronManArmorChestplate chest = (ItemIronManArmorChestplate)player.func_82169_q(2).func_77973_b();
            if (ItemIronManArmorChestplate.getEnergy(player.func_82169_q(2)) > 3) {
                user.field_70181_x = !hoverMode ? Math.min(user.field_70181_x + currentAccel, this.speedVertical) : Math.min(user.field_70181_x + currentAccel, -this.speedVerticalHoverSlow);
                ItemIronManArmorChestplate.removeEnergy(player.func_82169_q(2), 3);
                if (user.func_70051_ag() && !hoverMode) {
                    if (SyncTracker.isForwardKeyDown(user)) {
                        user.func_70060_a(0.0f, speedSideways * 2.0f, speedSideways * 2.0f);
                    }
                    if (SyncTracker.isBackwardKeyDown(user)) {
                        user.func_70060_a(0.0f, -(speedSideways * 2.0f), speedSideways * 0.8f);
                    }
                    if (SyncTracker.isLeftKeyDown(user)) {
                        user.func_70060_a(speedSideways * 2.0f, 0.0f, speedSideways * 2.0f);
                    }
                    if (SyncTracker.isRightKeyDown(user)) {
                        user.func_70060_a(-(speedSideways * 2.0f), 0.0f, speedSideways * 2.0f);
                    }
                } else {
                    if (SyncTracker.isForwardKeyDown(user)) {
                        user.func_70060_a(0.0f, speedSideways, speedSideways);
                    }
                    if (SyncTracker.isBackwardKeyDown(user)) {
                        user.func_70060_a(0.0f, -speedSideways, speedSideways * 0.8f);
                    }
                    if (SyncTracker.isLeftKeyDown(user)) {
                        user.func_70060_a(speedSideways, 0.0f, speedSideways);
                    }
                    if (SyncTracker.isRightKeyDown(user)) {
                        user.func_70060_a(-speedSideways, 0.0f, speedSideways);
                    }
                }
                if (!user.field_70170_p.field_72995_K) {
                    user.field_70143_R = 0.0f;
                }
                Vec3 userPos = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
                Vec3 vLeft = Vec3.func_72443_a((double)-0.28, (double)-1.95, (double)-0.08);
                vLeft.func_72442_b(-player.field_70761_aq * (float)Math.PI / 180.0f);
                Vec3 vRight = Vec3.func_72443_a((double)0.28, (double)-1.95, (double)-0.08);
                vRight.func_72442_b(-player.field_70761_aq * (float)Math.PI / 180.0f);
                Vec3 vCenter = Vec3.func_72443_a((double)(((double)rand.nextFloat() - 0.5) * 0.25), (double)-1.95, (double)-0.08);
                vCenter.func_72442_b(-player.field_70761_aq * (float)Math.PI / 180.0f);
                vLeft = vLeft.func_72441_c(-player.field_70159_w * 0.2, -player.field_70181_x * 0.2, -player.field_70179_y * 0.2);
                vRight = vRight.func_72441_c(-player.field_70159_w * 0.2, -player.field_70181_x * 0.2, -player.field_70179_y * 0.2);
                vCenter = vCenter.func_72441_c(-player.field_70159_w * 0.2, -player.field_70181_x * 0.2, -player.field_70179_y * 0.2);
                Vec3 v = userPos.func_72441_c(vLeft.field_72450_a, vLeft.field_72448_b, vLeft.field_72449_c);
                player.field_70170_p.func_72869_a("smoke", v.field_72450_a, v.field_72448_b + 0.25, v.field_72449_c, rand.nextDouble() * 0.05 - 0.025, -0.2, rand.nextDouble() * 0.05 - 0.025);
                v = userPos.func_72441_c(vRight.field_72450_a, vRight.field_72448_b, vRight.field_72449_c);
                player.field_70170_p.func_72869_a("smoke", v.field_72450_a, v.field_72448_b + 0.25, v.field_72449_c, rand.nextDouble() * 0.05 - 0.025, -0.2, rand.nextDouble() * 0.05 - 0.025);
                v = userPos.func_72441_c(vCenter.field_72450_a, vCenter.field_72448_b, vCenter.field_72449_c);
                player.field_70170_p.func_72869_a("flame", v.field_72450_a, v.field_72448_b + 0.25, v.field_72449_c, rand.nextDouble() * 0.05 - 0.025, -0.2, rand.nextDouble() * 0.05 - 0.025);
            }
        }
    }

    public void toggle(ItemStack boots, EntityPlayer entityPlayer, boolean sneakChangesToggleBehavior, boolean showInChat) {
    }

    public void switchHoverMode(ItemStack boots) {
        boots.field_77990_d.func_74757_a("Hover", !this.isHoverModeOn(boots));
    }

    public void switchEnableMode(ItemStack boots) {
        boots.field_77990_d.func_74757_a("Enable", !this.isOn(boots));
    }
}

