/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.heroes.ironman.blocks.compressor;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import thecrafterl.mods.heroes.ironman.IronMan;
import thecrafterl.mods.heroes.ironman.blocks.compressor.ItemBlockMeta;
import thecrafterl.mods.heroes.ironman.blocks.compressor.TileEntityMachine;
import thecrafterl.mods.heroes.ironman.util.IWrenchable;
import thecrafterl.mods.heroes.ironman.util.IronManGuiID;
import thecrafterl.mods.heroes.ironman.util.IronManUtil;

public class BlockMachine
extends BlockContainer
implements IWrenchable {
    public Class tileEntityClass;
    public IronManGuiID guiID;
    public IIcon iconSide;
    public IIcon iconTop;
    public IIcon iconFrontOff;
    public IIcon iconFrontOn;

    public BlockMachine(String name, Class<? extends TileEntityMachine> tileEntityClass, IronManGuiID guiID) {
        super(Material.field_151573_f);
        this.func_149711_c(12.0f);
        this.func_149752_b(16.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.tileEntityClass = tileEntityClass;
        this.guiID = guiID;
        String blockName = "block" + name;
        this.func_149663_c(blockName);
        this.func_149647_a(IronMan.tabIronMan);
        GameRegistry.registerBlock((Block)this, ItemBlockMeta.class, (String)blockName);
        GameRegistry.registerTileEntity(tileEntityClass, (String)("ironman.tileentity." + name));
    }

    public int getCraftingSpeed(int meta) {
        return TileEntityMachine.mapMaxEnergyReceive[meta] / 2;
    }

    public TileEntity func_149915_a(World world, int meta) {
        try {
            return (TileEntityMachine)this.tileEntityClass.newInstance();
        }
        catch (Exception ex) {
            System.out.println("Could not create TE!");
            ex.printStackTrace();
            return null;
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int var6 = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntityMachine tileEntity = (TileEntityMachine)world.func_147438_o(x, y, z);
        int facing = 3;
        switch (var6) {
            case 0: {
                facing = 2;
                break;
            }
            case 1: {
                facing = 5;
                break;
            }
            case 3: {
                facing = 4;
            }
        }
        tileEntity.facing = (byte)facing;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("energyStored")) {
            tileEntity.energyStored = stack.func_77978_p().func_74762_e("energyStored");
        }
        world.func_72921_c(x, y, z, stack.func_77960_j(), 2);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int meta, float f1, float f2, float f3) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            ItemStack heldItemStack = player.func_70694_bm();
            if (heldItemStack != null && IronManUtil.isItemWrench(heldItemStack.func_77973_b())) {
                IronManUtil.wrenchBlock(world, player, x, y, z, this);
            }
        } else if (!(player instanceof FakePlayer)) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)IronMan.instance, (int)this.guiID.ordinal(), (World)world, (int)x, (int)y, (int)z);
        }
        return true;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a("IronMan:machine_side");
        this.iconTop = iconRegister.func_94245_a("IronMan:machine_top");
        this.iconFrontOff = this.iconSide;
        this.iconFrontOn = this.iconSide;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == 3) {
            return this.iconFrontOff;
        }
        return side <= 1 ? this.iconTop : this.iconSide;
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityMachine machine = (TileEntityMachine)blockAccess.func_147438_o(x, y, z);
        if (side == machine.facing) {
            return machine.active ? this.iconFrontOn : this.iconFrontOff;
        }
        return side <= 1 ? this.iconTop : this.iconSide;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        IronManUtil.dropBlockContents(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < TileEntityMachine.mapTiers.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @Override
    public ItemStack onWrenched(ItemStack stack, TileEntity tileEntity) {
        if (tileEntity instanceof TileEntityMachine) {
            TileEntityMachine machine = (TileEntityMachine)tileEntity;
            NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            compound.func_74768_a("energyStored", machine.energyStored);
            stack.func_77982_d(compound);
        }
        return stack;
    }
}

