/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.heroes.ironman.blocks.compressor;

import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import thecrafterl.mods.heroes.ironman.blocks.compressor.ContainerBasic;
import thecrafterl.mods.heroes.ironman.blocks.compressor.TileEntityMachine;
import thecrafterl.mods.heroes.ironman.util.IronManUtil;

public abstract class GuiMachine
extends GuiContainer {
    public ResourceLocation guiTexture;
    public ResourceLocation guiTextureNEI;
    public TileEntityMachine tileEntity;
    public int energyX = 20;
    public int energyY = 30;
    public int energyWidth = 14;
    public int energyHeight = 42;
    public int arrowX = 75;
    public int arrowY = 22;
    public int arrowWidth = 23;
    public int arrowHeight = 16;
    public int mouseX;
    public int mouseY;

    public GuiMachine(TileEntityMachine tileEntity, String guiTexture, ContainerBasic container) {
        super((Container)container);
        this.tileEntity = tileEntity;
        this.guiTexture = new ResourceLocation("IronMan:" + guiTexture + ".png");
        this.guiTextureNEI = new ResourceLocation("IronMan:" + guiTexture + "_nei.png");
        this.field_146999_f = 176;
        this.field_147000_g = 186;
    }

    protected void func_146976_a(float f1, int i1, int i2) {
        IronManUtil.setTexture(this.guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73732_a(this.field_146289_q, StatCollector.func_74838_a((String)this.getName()), this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 4, 0xFFFFFF);
        this.drawProgress();
        this.drawEnergy();
    }

    protected void func_146979_b(int i1, int i2) {
        this.drawEnergyOverlay();
        RenderHelper.func_74520_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float f1) {
        this.mouseX = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        this.mouseY = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        super.func_73863_a(mouseX, mouseY, f1);
    }

    public void drawProgress() {
        this.drawProgress(this.tileEntity.getProgress(), this.field_147003_i, this.field_147009_r);
    }

    public void drawProgress(int progress, int xOffset, int yOffset) {
        IronManUtil.setTexture(new ResourceLocation("IronMan:textures/gui/arrowRight.png"));
        IronManUtil.drawTexturedModalRect(xOffset + this.arrowX, yOffset + this.arrowY, 0.0f, 0.0f, this.arrowWidth, this.arrowHeight, 48, 16);
        if (progress > 0) {
            int width = Math.round((float)this.arrowWidth / 100.0f * (float)progress);
            IronManUtil.drawTexturedModalRect(xOffset + this.arrowX, yOffset + this.arrowY, 24.0f, 0.0f, width, this.arrowHeight, 48, 16);
        }
    }

    private void drawEnergy() {
        this.drawEnergy(this.tileEntity.energyStored, this.tileEntity.getMaxEnergyStored(null), this.field_147003_i, this.field_147009_r);
    }

    public void drawEnergy(int energyStored, int maxEnergyStored, int xOffset, int yOffset) {
        IronManUtil.setTexture(new ResourceLocation("IronMan:textures/gui/energy.png"));
        IronManUtil.drawTexturedModalRect(xOffset + this.energyX, yOffset + this.energyY, 1.0f, 0.0f, this.energyWidth, this.energyHeight, 32, 64);
        if (energyStored > 0) {
            int cut = this.energyHeight - 2 - (int)Math.floor(40.0f / (float)maxEnergyStored * (float)energyStored);
            IronManUtil.drawTexturedModalRect(xOffset + this.energyX + 1, yOffset + this.energyY + cut + 1, 18.0f, cut + 1, this.energyWidth - 2, this.energyHeight - cut - 2, 32, 64);
        }
    }

    private void drawEnergyOverlay() {
        this.drawEnergyOverlay(this.mouseX, this.mouseY, this.tileEntity.energyStored, this.tileEntity.getMaxEnergyStored(null));
    }

    public void drawEnergyOverlay(int mouseX, int mouseY, int energyStored, int maxEnergyStored) {
        if (mouseX > this.energyX && mouseX < this.energyX + this.energyWidth && mouseY > this.energyY && mouseY < this.energyY + this.energyHeight) {
            ArrayList<String> list = new ArrayList<String>();
            if (maxEnergyStored > 0) {
                list.add(energyStored + "/" + maxEnergyStored + " RF");
            } else {
                list.add(energyStored + " RF");
            }
            int x = mouseX;
            int y = mouseY;
            this.drawHoveringText(list, x, y, this.field_146289_q);
        }
    }

    public Slot[] getInputSlots() {
        return ((ContainerBasic)this.field_147002_h).getInputSlots();
    }

    public Slot[] getOutputSlots() {
        return ((ContainerBasic)this.field_147002_h).getOutputSlots();
    }

    public abstract String getName();
}

