/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.heroes.ironman.blocks.compressor;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.StringUtils;
import thecrafterl.mods.heroes.ironman.util.IronManUtil;

public class IronManRecipe {
    public Object[] inputs;
    public Object[] outputs;
    public int energy;

    public static IronManRecipe readFromNBT(String key, NBTTagCompound compound) {
        NBTTagCompound recipeCompound = compound.func_74775_l(key);
        String id = recipeCompound.func_74779_i("tsId");
        if (id == "recipe") {
            return new IronManRecipe(null, null, 0);
        }
        return null;
    }

    public IronManRecipe(Object[] input, Object[] outputs, int energy) {
        this.inputs = input;
        this.outputs = outputs;
        this.energy = energy;
    }

    public boolean isValid() {
        int i;
        for (i = 0; i < this.inputs.length; ++i) {
            if (this.isObjectValid(this.inputs[i])) continue;
            return false;
        }
        for (i = 0; i < this.outputs.length; ++i) {
            if (this.isObjectValid(this.outputs[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isObjectValid(Object obj) {
        if (obj instanceof ItemStack || obj instanceof Item || obj instanceof Block) {
            return true;
        }
        if (obj instanceof String) {
            String[] splits = ((String)obj).split(",");
            if (splits.length == 1) {
                return true;
            }
            if (splits.length == 2 && StringUtils.isNumeric((CharSequence)splits[1])) {
                return true;
            }
        }
        return false;
    }

    public boolean matches(ItemStack[] inputs) {
        if (inputs.length < this.inputs.length) {
            return false;
        }
        for (int i = 0; i < this.inputs.length; ++i) {
            int index = IronManUtil.getIndexOfItem(this.inputs[i], inputs);
            if (index == -1) {
                return false;
            }
            if (this.inputs[i] instanceof Item) {
                this.inputs[i] = new ItemStack((Item)this.inputs[i]);
            } else if (this.inputs[i] instanceof Block) {
                this.inputs[i] = new ItemStack((Block)this.inputs[i]);
            }
            if (this.inputs[i] instanceof ItemStack) {
                if (((ItemStack)this.inputs[i]).field_77994_a <= inputs[index].field_77994_a) continue;
                return false;
            }
            if (!(this.inputs[i] instanceof String)) continue;
            int stackSize = 1;
            String[] s = ((String)this.inputs[i]).split(",");
            if (s.length > 1) {
                stackSize = Integer.parseInt(s[1]);
            }
            if (stackSize <= inputs[index].field_77994_a) continue;
            return false;
        }
        return true;
    }

    public String getId() {
        return "recipe";
    }

    public void writeToNBT(String key, NBTTagCompound compound) {
        NBTTagCompound recipeCompound = new NBTTagCompound();
        recipeCompound.func_74778_a("tsId", this.getId());
        this.writeCustomToNBT(recipeCompound);
        compound.func_74782_a(key, (NBTBase)recipeCompound);
    }

    public void writeCustomToNBT(NBTTagCompound compound) {
    }
}

