/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.heroes.ironman.blocks.compressor;

import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thecrafterl.mods.heroes.ironman.blocks.IMBlocks;
import thecrafterl.mods.heroes.ironman.blocks.compressor.IronManRecipe;
import thecrafterl.mods.heroes.ironman.util.IContentDropper;
import thecrafterl.mods.heroes.ironman.util.ISyncEnergy;
import thecrafterl.mods.heroes.ironman.util.IronManUtil;

public abstract class TileEntityMachine
extends TileEntity
implements IEnergyReceiver,
ISidedInventory,
IContentDropper,
ISyncEnergy {
    public static final String[] mapTiers = new String[]{"\u00a77Basic", "\u00a7eAdvanced"};
    public static final int[] mapMaxEnergyStored = new int[]{16000, 80000};
    public static final int[] mapMaxEnergyReceive = new int[]{80, 5000};
    public int energyStored = 0;
    public int craftingEnergy = 0;
    public int craftingEnergyNeeded = 0;
    public ItemStack[] craftingOutputs = null;
    public ItemStack[] craftingInputs = null;
    public IronManRecipe craftingRecipe = null;
    public byte facing = (byte)2;
    public boolean active = false;
    public ItemStack[] slots = new ItemStack[this.func_70302_i_()];

    @Override
    public ArrayList<ItemStack> getDrops() {
        int i;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) continue;
            drops.add(stack);
        }
        if (this.craftingInputs != null) {
            for (i = 0; i < this.craftingInputs.length; ++i) {
                drops.add(this.craftingInputs[i]);
            }
        }
        return drops;
    }

    public int getProgress() {
        if (this.craftingEnergyNeeded == 0) {
            return 0;
        }
        return Math.round(100.0f / (float)this.craftingEnergyNeeded * (float)this.craftingEnergy);
    }

    public void writeCustomToNBT(NBTTagCompound compound) {
        compound.func_74774_a("facing", this.facing);
        compound.func_74768_a("energyStored", this.energyStored);
        compound.func_74768_a("craftingEnergy", this.craftingEnergy);
        compound.func_74768_a("craftingEnergyNeeded", this.craftingEnergyNeeded);
        compound.func_74757_a("active", this.active);
        if (this.craftingOutputs != null) {
            IronManUtil.writeStacksToNBT(this.craftingOutputs, compound, "craftingInputs");
        }
        if (this.craftingInputs != null) {
            IronManUtil.writeStacksToNBT(this.craftingInputs, compound, "craftingInputs");
        }
        if (this.craftingRecipe != null) {
            this.craftingRecipe.writeToNBT("recipe", compound);
        }
        IronManUtil.writeStacksToNBT(this.slots, compound, "slots");
    }

    public void readCustomFromNBT(NBTTagCompound compound) {
        this.facing = compound.func_74771_c("facing");
        this.energyStored = compound.func_74762_e("energyStored");
        this.craftingEnergy = compound.func_74762_e("craftingEnergy");
        this.craftingEnergyNeeded = compound.func_74762_e("craftingEnergyNeeded");
        this.active = compound.func_74767_n("active");
        if (compound.func_74764_b("craftingInputs")) {
            this.craftingOutputs = IronManUtil.readStacksFromNBT(this.getCraftingOutputSize(), compound, "craftingInputs");
        }
        if (compound.func_74764_b("craftingInputs")) {
            this.craftingInputs = IronManUtil.readStacksFromNBT(this.getCraftingInputSize(), compound, "craftingInputs");
        }
        if (compound.func_74764_b("recipe")) {
            this.craftingRecipe = IronManRecipe.readFromNBT("recipe", compound);
        }
        this.slots = IronManUtil.readStacksFromNBT(this.func_70302_i_(), compound, "slots");
    }

    public void updateCrafting(boolean checkRecipe) {
        if (checkRecipe || this.field_145850_b.func_82737_E() % 10L == 0L) {
            int i;
            if (this.craftingOutputs != null) {
                return;
            }
            ItemStack[] inputs = new ItemStack[this.getCraftingInputSize()];
            int[] inputSlots = this.getCraftingInputSlots();
            for (int i2 = 0; i2 < inputSlots.length; ++i2) {
                inputs[i2] = this.slots[inputSlots[i2]];
            }
            IronManRecipe recipe = IronManUtil.getMatchingRecipe(this.getRecipes(), inputs);
            if (recipe == null) {
                return;
            }
            ItemStack[] outputs = new ItemStack[recipe.outputs.length];
            for (i = 0; i < outputs.length; ++i) {
                outputs[i] = IronManUtil.getStack(recipe.outputs[i]);
            }
            if (this.energyStored >= recipe.energy && this.canCraft(recipe, outputs)) {
                this.craftingEnergyNeeded = recipe.energy;
                this.craftingEnergy = 0;
                this.craftingOutputs = outputs;
                this.craftingRecipe = recipe;
                for (i = 0; i < recipe.inputs.length; ++i) {
                    ItemStack stack = IronManUtil.getStack(recipe.inputs[i]);
                    int index = IronManUtil.getIndexOfItem(recipe.inputs[i], inputs);
                    if (index == -1) {
                        return;
                    }
                    inputs[index].field_77994_a -= stack.field_77994_a;
                    if (inputs[index].field_77994_a > 0) continue;
                    inputs[index] = null;
                    this.slots[index] = null;
                }
                ItemStack[] craftingInputs = new ItemStack[recipe.inputs.length];
                for (int i3 = 0; i3 < craftingInputs.length; ++i3) {
                    craftingInputs[i3] = IronManUtil.getStack(recipe.inputs[i3]).func_77946_l();
                }
                this.craftingInputs = craftingInputs;
                this.active = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else if (this.craftingOutputs != null) {
            int energyUse = Math.min(Math.min(this.craftingEnergyNeeded - this.craftingEnergy, this.getCraftingSpeed()), this.energyStored);
            this.craftingEnergy += energyUse;
            this.energyStored -= energyUse;
            if (this.craftingEnergy >= this.craftingEnergyNeeded) {
                this.craftingEnergy = 0;
                this.itemsCrafted(this.craftingRecipe, this.craftingOutputs);
                this.craftingOutputs = null;
                this.craftingInputs = null;
                this.craftingEnergy = 0;
                this.craftingEnergyNeeded = 0;
                this.active = false;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.updateCrafting(true);
        }
    }

    public void itemsCrafted(IronManRecipe recipe, ItemStack[] stacks) {
        if (stacks != null && stacks.length > 0) {
            block0: for (int i = 0; i < stacks.length; ++i) {
                for (int j = 0; j < this.getCraftingOutputSize(); ++j) {
                    int slot = this.getCraftingOutputSlots()[j];
                    if (this.slots[slot] == null) {
                        this.slots[slot] = stacks[i];
                        continue block0;
                    }
                    if (!IronManUtil.areStacksEqual(this.slots[slot], stacks[i]) || this.slots[slot].field_77994_a + stacks[i].field_77994_a > stacks[i].func_77976_d()) continue;
                    this.slots[slot].field_77994_a += stacks[i].field_77994_a;
                    continue block0;
                }
            }
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean canCraft(IronManRecipe recipe, ItemStack[] stacks) {
        if (stacks != null && stacks.length > 0) {
            ArrayList<Integer> occupiedSlots = new ArrayList<Integer>();
            for (int i = 0; i < stacks.length; ++i) {
                boolean success = false;
                for (int j = 0; j < this.getCraftingOutputSize(); ++j) {
                    int slot = this.getCraftingOutputSlots()[j];
                    boolean occupied = false;
                    for (int k = 0; k < occupiedSlots.size(); ++k) {
                        if ((Integer)occupiedSlots.get(k) != slot) continue;
                        occupied = true;
                    }
                    if (occupied || this.slots[slot] != null && (!IronManUtil.areStacksEqual(this.slots[slot], stacks[i]) || this.slots[slot].field_77994_a + stacks[i].field_77994_a > stacks[i].func_77976_d())) continue;
                    success = true;
                    occupiedSlots.add(slot);
                    break;
                }
                if (success) continue;
                return false;
            }
        }
        return true;
    }

    public int getCraftingSpeed() {
        return mapMaxEnergyReceive[this.func_145832_p()] / 2;
    }

    public abstract List<IronManRecipe> getRecipes();

    public abstract int getCraftingInputSize();

    public abstract int getCraftingOutputSize();

    public abstract int[] getCraftingInputSlots();

    public abstract int[] getCraftingOutputSlots();

    @Override
    public void setEnergy(int i) {
        this.energyStored = i;
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        maxReceive = Math.min(maxReceive, mapMaxEnergyReceive[this.func_145832_p()]);
        int receive = MathHelper.func_76125_a((int)(this.getMaxEnergyStored(null) - this.energyStored), (int)0, (int)maxReceive);
        if (!simulate && receive > 0) {
            this.energyStored += receive;
        }
        IronManUtil.syncEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.energyStored, this.getMaxEnergyStored(null));
        return receive;
    }

    public boolean canUpdate() {
        return true;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energyStored;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return mapMaxEnergyStored[this.func_145832_p()];
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCustomFromNBT(compound);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeCustomToNBT(compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCustomFromNBT(pkt.func_148857_g());
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomToNBT(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public ItemStack func_70298_a(int slot, int current) {
        if (this.slots[slot] != null) {
            if (this.slots[slot].field_77994_a <= current) {
                ItemStack itemstack = this.slots[slot];
                this.slots[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.slots[slot].func_77979_a(current);
            if (this.slots[slot].field_77994_a == 0) {
                this.slots[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateCrafting(false);
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.slots[slot] = stack;
        if (!this.field_145850_b.field_72995_K) {
            this.updateCrafting(true);
        }
    }

    public ItemStack func_70301_a(int slot) {
        return this.slots[slot];
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int[] func_94128_d(int side) {
        int[] sides = new int[this.func_70302_i_()];
        for (int i = 0; i < sides.length; ++i) {
            sides[i] = i;
        }
        return sides;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        for (int i = 0; i < this.getCraftingInputSize(); ++i) {
            if (this.getCraftingInputSlots()[i] != slot) continue;
            return true;
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        for (int i = 0; i < this.getCraftingOutputSize(); ++i) {
            if (this.getCraftingOutputSlots()[i] != slot) continue;
            return true;
        }
        return false;
    }

    public abstract int func_70302_i_();

    public abstract String func_145825_b();

    public boolean hasPipes() {
        if (this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) == IMBlocks.pipe) {
            return true;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) == IMBlocks.pipe) {
            return true;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) == IMBlocks.pipe) {
            return true;
        }
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 1) == IMBlocks.pipe && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) == IMBlocks.pipe;
    }
}

