/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.heroes.ironman.items;

import cofh.api.energy.IEnergyContainerItem;
import cofh.lib.util.helpers.EnergyHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import thecrafterl.mods.heroes.ironman.IronMan;
import thecrafterl.mods.heroes.ironman.items.IMItems;

public class ItemInactiveRepulsor
extends Item
implements IEnergyContainerItem {
    public static int maxEnergy = 16000;
    private int maxTransfer = 1000;
    private int maxTimer = 6000;
    private String name;
    @SideOnly(value=Side.CLIENT)
    private IIcon state_0;
    @SideOnly(value=Side.CLIENT)
    private IIcon state_1;
    @SideOnly(value=Side.CLIENT)
    private IIcon state_2;
    @SideOnly(value=Side.CLIENT)
    private IIcon state_3;

    public ItemInactiveRepulsor(String name) {
        this.func_77655_b(name);
        this.func_77637_a(IronMan.tabIronMan);
        this.name = name;
        GameRegistry.registerItem((Item)this, (String)name);
    }

    public void func_94581_a(IIconRegister reg) {
        this.field_77791_bV = reg.func_94245_a("IronMan:" + this.name + "_0");
        this.state_0 = reg.func_94245_a("IronMan:" + this.name + "_0");
        this.state_1 = reg.func_94245_a("IronMan:" + this.name + "_1");
        this.state_2 = reg.func_94245_a("IronMan:" + this.name + "_2");
        this.state_3 = reg.func_94245_a("IronMan:" + this.name + "_3");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        int timer = stack.field_77990_d.func_74762_e("Timer");
        if (timer >= 0 && timer < 1500) {
            return this.state_0;
        }
        if (timer >= 1500 && timer < 3000) {
            return this.state_1;
        }
        if (timer >= 3000 && timer < 4500) {
            return this.state_2;
        }
        if (timer >= 4500 && timer < 6001) {
            return this.state_3;
        }
        return null;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i, boolean b) {
        if (this.getEnergyStored(stack) == maxEnergy) {
            if (stack.field_77990_d.func_74762_e("Timer") < this.maxTimer) {
                stack.field_77990_d.func_74768_a("Timer", stack.field_77990_d.func_74762_e("Timer") + 1);
            } else {
                ((EntityPlayer)entity).field_71071_by.func_70299_a(i, new ItemStack((Item)IMItems.repulsor));
            }
        }
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)maxEnergy));
    }

    public int getDisplayDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return maxEnergy - stack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack stack) {
        return maxEnergy;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(maxEnergy - stored, this.maxTransfer));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.field_77990_d.func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
            container.field_77990_d.func_74768_a("Timer", 0);
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return maxEnergy;
    }
}

