/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.heroes.ironman.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import thecrafterl.mods.heroes.ironman.blocks.compressor.GuiMachine;
import thecrafterl.mods.heroes.ironman.blocks.compressor.IronManRecipe;
import thecrafterl.mods.heroes.ironman.blocks.particleaccelerator.GuiParticleAccelerator;
import thecrafterl.mods.heroes.ironman.nei.IronManRecipes;
import thecrafterl.mods.heroes.ironman.util.IronManUtil;

public class RecipeHandlerParticleAccelerator
extends TemplateRecipeHandler {
    public GuiMachine gui;
    public List<IronManRecipe> recipes;
    public String name;
    public int xOffset = -5;
    public int yOffset = 8;
    public int xCrop = 0;
    public int yCrop = 11;

    public void loadTransferRects() {
        this.gui = new GuiParticleAccelerator(null, null);
        this.recipes = IronManRecipes.recipesParticleAccelerator;
        this.name = "carbothermicFurnace";
        super.loadTransferRects();
        API.setGuiOffset(this.getGuiClass(), (int)this.getOffsetX(), (int)this.getOffsetY());
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(this.getRecipesRect(), this.getOverlayIdentifier(), new Object[0]));
    }

    public Rectangle getRecipesRect() {
        return new Rectangle(87, 44, 22, 7);
    }

    public int getOffsetX() {
        return 0;
    }

    public int getOffsetY() {
        return 0;
    }

    public String getGuiTexture() {
        return null;
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return ((Object)((Object)this.gui)).getClass();
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)this.gui.getName());
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.arecipes.clear();
            for (int i = 0; i < this.recipes.size(); ++i) {
                CachedRecipeMachine recipe = new CachedRecipeMachine(this.gui, this.recipes.get(i));
                if (!recipe.isValid) continue;
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<IronManRecipe> recipes = IronManUtil.getRecipesFor(this.recipes, result);
        this.arecipes.clear();
        for (int i = 0; i < recipes.size(); ++i) {
            CachedRecipeMachine recipe = new CachedRecipeMachine(this.gui, recipes.get(i));
            if (!recipe.isValid) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<IronManRecipe> recipes = IronManUtil.getUsageFor(this.recipes, ingredient);
        this.arecipes.clear();
        for (int i = 0; i < recipes.size(); ++i) {
            CachedRecipeMachine recipe = new CachedRecipeMachine(this.gui, recipes.get(i));
            if (!recipe.isValid) continue;
            this.arecipes.add(recipe);
        }
    }

    public void drawBackground(int recipe) {
        IronManUtil.setTexture(this.gui.guiTextureNEI);
        IronManUtil.drawTexturedModalRect(this.xOffset + 5, this.yOffset, this.xCrop + 5, this.yCrop, 166, 48);
    }

    public void drawForeground(int recipeID) {
        CachedRecipeMachine recipe = (CachedRecipeMachine)((Object)this.arecipes.get(recipeID));
        this.gui.drawProgress(this.cycleticks * 2, this.xOffset - this.xCrop, this.yOffset - this.yCrop);
        if (this.cycleticks > 50) {
            this.cycleticks = 0;
        }
        int energyInterpolated = (int)(2.2857143878936768 * Math.log10(recipe.energy + 1));
        this.gui.drawEnergy(energyInterpolated, 16, this.xOffset - this.xCrop, this.yOffset - this.yCrop + 2);
        GuiDraw.drawString((String)(recipe.energy + " RF"), (int)(this.gui.energyX + this.xOffset - this.xCrop + this.gui.energyWidth + 10), (int)(this.gui.energyY + this.yOffset - this.yCrop + this.gui.energyHeight - 10), (int)0xFFFFFF);
    }

    public String getOverlayIdentifier() {
        return "IronMan:" + this.name;
    }

    public int recipiesPerPage() {
        return 2;
    }

    public class CachedRecipeMachine
    extends TemplateRecipeHandler.CachedRecipe {
        private Slot[] inputSlots;
        private Slot[] outputSlots;
        public IronManRecipe recipe;
        public List<ItemStack> inputs;
        public List<ItemStack> outputs;
        public int energy;
        public boolean isValid;

        public CachedRecipeMachine(GuiMachine gui, IronManRecipe recipe) {
            ItemStack stack;
            int j;
            super((TemplateRecipeHandler)RecipeHandlerParticleAccelerator.this);
            this.recipe = recipe;
            this.inputSlots = gui.getInputSlots();
            this.outputSlots = gui.getOutputSlots();
            this.isValid = true;
            this.outputs = new ArrayList<ItemStack>();
            for (j = 0; j < recipe.outputs.length; ++j) {
                stack = IronManUtil.getStack(recipe.outputs[j]);
                if (stack == null) {
                    this.isValid = false;
                    return;
                }
                this.outputs.add(stack);
            }
            this.inputs = new ArrayList<ItemStack>();
            for (j = 0; j < recipe.inputs.length; ++j) {
                stack = IronManUtil.getStack(recipe.inputs[j]);
                if (stack == null) {
                    this.isValid = false;
                    return;
                }
                this.inputs.add(stack);
            }
            this.energy = recipe.energy;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
            for (int i = 0; i < this.inputs.size(); ++i) {
                ret.add(new PositionedStack((Object)this.inputs.get(i), this.inputSlots[i].field_75223_e + RecipeHandlerParticleAccelerator.this.xOffset - RecipeHandlerParticleAccelerator.this.xCrop, this.inputSlots[i].field_75221_f + RecipeHandlerParticleAccelerator.this.yOffset - RecipeHandlerParticleAccelerator.this.yCrop));
            }
            return ret;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> ret = new ArrayList<PositionedStack>();
            for (int i = 0; i < this.outputs.size(); ++i) {
                ret.add(new PositionedStack((Object)this.outputs.get(i), this.outputSlots[i].field_75223_e + RecipeHandlerParticleAccelerator.this.xOffset - RecipeHandlerParticleAccelerator.this.xCrop, this.outputSlots[i].field_75221_f + RecipeHandlerParticleAccelerator.this.yOffset - RecipeHandlerParticleAccelerator.this.yCrop));
            }
            return ret;
        }
    }
}

