/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.heroes.ironman.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class SyncTracker {
    private static Map<EntityPlayer, Boolean> flyKeyState = new HashMap<EntityPlayer, Boolean>();
    private static Map<EntityPlayer, Boolean> descendKeyState = new HashMap<EntityPlayer, Boolean>();
    private static Map<EntityPlayer, Boolean> forwardKeyState = new HashMap<EntityPlayer, Boolean>();
    private static Map<EntityPlayer, Boolean> backwardKeyState = new HashMap<EntityPlayer, Boolean>();
    private static Map<EntityPlayer, Boolean> leftKeyState = new HashMap<EntityPlayer, Boolean>();
    private static Map<EntityPlayer, Boolean> rightKeyState = new HashMap<EntityPlayer, Boolean>();

    public static boolean isFlyKeyDown(EntityLivingBase user) {
        if (user instanceof EntityPlayer) {
            return flyKeyState.containsKey(user) && flyKeyState.get(user) != false;
        }
        return true;
    }

    public static boolean isDescendKeyDown(EntityLivingBase user) {
        if (user instanceof EntityPlayer) {
            return descendKeyState.containsKey(user) && descendKeyState.get(user) != false;
        }
        return false;
    }

    public static boolean isForwardKeyDown(EntityLivingBase user) {
        if (user instanceof EntityPlayer) {
            return forwardKeyState.containsKey(user) && forwardKeyState.get(user) != false;
        }
        return true;
    }

    public static boolean isBackwardKeyDown(EntityLivingBase user) {
        if (user instanceof EntityPlayer) {
            return backwardKeyState.containsKey(user) && backwardKeyState.get(user) != false;
        }
        return false;
    }

    public static boolean isLeftKeyDown(EntityLivingBase user) {
        if (user instanceof EntityPlayer) {
            return leftKeyState.containsKey(user) && leftKeyState.get(user) != false;
        }
        return false;
    }

    public static boolean isRightKeyDown(EntityLivingBase user) {
        if (user instanceof EntityPlayer) {
            return rightKeyState.containsKey(user) && rightKeyState.get(user) != false;
        }
        return false;
    }

    public static void processKeyUpdate(EntityPlayer player, boolean keyFly, boolean keyDescend, boolean keyForward, boolean keyBackward, boolean keyLeft, boolean keyRight) {
        flyKeyState.put(player, keyFly);
        descendKeyState.put(player, keyDescend);
        forwardKeyState.put(player, keyForward);
        backwardKeyState.put(player, keyBackward);
        leftKeyState.put(player, keyLeft);
        rightKeyState.put(player, keyRight);
    }

    public static void clearAll() {
        flyKeyState.clear();
        forwardKeyState.clear();
        backwardKeyState.clear();
        leftKeyState.clear();
        rightKeyState.clear();
    }

    public static void removeFromAll(EntityPlayer player) {
        flyKeyState.remove(player);
        forwardKeyState.remove(player);
        backwardKeyState.remove(player);
        leftKeyState.remove(player);
        rightKeyState.remove(player);
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent evt) {
        SyncTracker.removeFromAll(evt.player);
    }

    @SubscribeEvent
    public void onDimChanged(PlayerEvent.PlayerChangedDimensionEvent evt) {
        SyncTracker.removeFromAll(evt.player);
    }
}

