/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.heroes.ironman.util;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import thecrafterl.mods.heroes.ironman.IronMan;
import thecrafterl.mods.heroes.ironman.util.IIronManPacket;
import thecrafterl.mods.heroes.ironman.util.PacketEnergy;

@ChannelHandler.Sharable
public class IronManEnergyHandler
extends MessageToMessageCodec<FMLProxyPacket, IIronManPacket> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private LinkedList<Class<? extends IIronManPacket>> packets = new LinkedList();

    public IronManEnergyHandler() {
        this.channels = NetworkRegistry.INSTANCE.newChannel("IronMan_Energy", new ChannelHandler[]{this});
        this.packets.add(PacketEnergy.class);
        Collections.sort(this.packets, new Comparator<Class<? extends IIronManPacket>>(){

            @Override
            public int compare(Class<? extends IIronManPacket> o1, Class<? extends IIronManPacket> o2) {
                int comp = String.CASE_INSENSITIVE_ORDER.compare(o1.getCanonicalName(), o2.getCanonicalName());
                if (comp == 0) {
                    comp = o1.getCanonicalName().compareTo(o2.getCanonicalName());
                }
                return comp;
            }
        });
    }

    protected void encode(ChannelHandlerContext ctx, IIronManPacket msg, List<Object> out) throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        Class<?> packetClass = msg.getClass();
        byte packetID = (byte)this.packets.indexOf(packetClass);
        buffer.writeByte((int)packetID);
        msg.write(ctx, buffer);
        out.add(new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get()));
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        ByteBuf buffer = msg.payload();
        byte packetID = buffer.readByte();
        IIronManPacket packet = this.packets.get(packetID).newInstance();
        packet.read(ctx, buffer.slice());
        EntityPlayer player = IronMan.proxy.getPlayerFromPacket(ctx);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            packet.executeClientSide(player);
        } else {
            packet.executeServerSide(player);
        }
    }

    public void sendPacketToServer(IIronManPacket packet) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)packet);
    }

    public void sendPacketToAll(IIronManPacket packet) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendPacketToDimension(int dimension, IIronManPacket packet) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendPacketAroundPoint(NetworkRegistry.TargetPoint point, IIronManPacket packet) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }
}

