/*
 * Decompiled with CFR 0.152.
 */
package thecrafterl.mods.heroes.ironman.util;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import thecrafterl.mods.heroes.ironman.blocks.compressor.IronManRecipe;
import thecrafterl.mods.heroes.ironman.util.IContentDropper;
import thecrafterl.mods.heroes.ironman.util.IWrenchable;
import thecrafterl.mods.heroes.ironman.util.IronManEnergyHandler;
import thecrafterl.mods.heroes.ironman.util.PacketEnergy;

public class IronManUtil {
    public static IronManEnergyHandler packetHandler;
    private static ArrayList<Item> wrenchItems;

    public static void init() {
        wrenchItems = new ArrayList();
        IronManUtil.addWrench("ThermalExpansion", "wrench");
        IronManUtil.addWrench("EnderIO", "itemYetaWrench");
        IronManUtil.addWrench("BuildCraft|Core", "wrenchItem");
        IronManUtil.addWrench("funkylocomotion", "wrench");
    }

    public static void addWrench(String mod, String id) {
        Item wrench = GameRegistry.findItem((String)mod, (String)id);
        if (wrench != null) {
            wrenchItems.add(wrench);
        }
    }

    public static void setTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
    }

    public static void drawTexturedModalRectWithIcon(IIcon icon, int x, int y) {
        IronManUtil.drawTexturedModalRectWithIcon(icon, x, y, icon.func_94211_a(), icon.func_94216_b(), false);
    }

    public static List<IronManRecipe> getUsageFor(List<IronManRecipe> recipes, Object obj) {
        ArrayList<IronManRecipe> ret = new ArrayList<IronManRecipe>();
        block0: for (int i = 0; i < recipes.size(); ++i) {
            IronManRecipe recipe = recipes.get(i);
            for (int j = 0; j < recipe.inputs.length; ++j) {
                ItemStack stack2;
                ItemStack stack1 = IronManUtil.getStack(obj);
                if (!IronManUtil.areOresIdentical(stack1, stack2 = IronManUtil.getStack(recipe.inputs[j]))) continue;
                ret.add(recipes.get(i));
                continue block0;
            }
        }
        return ret;
    }

    public static void drawTexturedModalRectWithIcon(IIcon icon, int x, int y, int width, int height, boolean crop) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float minU = icon.func_94209_e();
        float minV = icon.func_94206_g();
        float maxU = icon.func_94212_f();
        float maxV = icon.func_94210_h();
        if (crop) {
            maxU = minU + (maxU - minU) / (float)icon.func_94211_a() * (float)width;
            maxV = minV + (maxV - minV) / (float)icon.func_94216_b() * (float)height;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), 0.0, (double)minU, (double)maxV);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)maxU, (double)maxV);
        tessellator.func_78374_a((double)(x + width), (double)y, 0.0, (double)maxU, (double)minV);
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)minU, (double)minV);
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int x, int y, float u, float v, int width, int height) {
        IronManUtil.drawTexturedModalRect(x, y, u, v, width, height, 256, 256);
    }

    public static void drawTexturedModalRect(int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 1.0f / (float)textureWidth;
        float f1 = 1.0f / (float)textureHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), 0.0, (double)(u * f), (double)((v + (float)height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)((u + (float)width) * f), (double)((v + (float)height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)y, 0.0, (double)((u + (float)width) * f), (double)(v * f1));
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)(u * f), (double)(v * f1));
        tessellator.func_78381_a();
    }

    public static void syncEnergy(World world, int x, int y, int z, int energy, int maxEnergy) {
        if (world.func_82737_E() % 10L == 0L || energy == 0 || energy == maxEnergy) {
            packetHandler.sendPacketToDimension(world.field_73011_w.field_76574_g, new PacketEnergy(x, y, z, energy));
        }
    }

    public static boolean areOresIdentical(ItemStack stack1, ItemStack stack2) {
        if (IronManUtil.areStacksEqual(stack1, stack2)) {
            return true;
        }
        int[] ores1 = OreDictionary.getOreIDs((ItemStack)stack1);
        int[] ores2 = OreDictionary.getOreIDs((ItemStack)stack2);
        if (ores1.length == 0 || ores2.length == 0) {
            return false;
        }
        if (ores1.length != ores2.length) {
            return false;
        }
        for (int i = 0; i < ores1.length; ++i) {
            if (ores1[i] == ores2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areOresIdentical(ItemStack stack1, String ore) {
        int[] ores1 = OreDictionary.getOreIDs((ItemStack)stack1);
        int ore2 = OreDictionary.getOreID((String)ore);
        if (ores1.length == 0) {
            return false;
        }
        for (int i = 0; i < ores1.length; ++i) {
            if (ores1[i] != ore2) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getPrefferedOre(String name) {
        ArrayList oreDictEntries = OreDictionary.getOres((String)name);
        ItemStack ret = null;
        if (oreDictEntries.size() > 0) {
            ret = ((ItemStack)oreDictEntries.get(0)).func_77946_l();
            for (int i = 1; i < oreDictEntries.size(); ++i) {
                String modid = GameRegistry.findUniqueIdentifierFor((Item)((ItemStack)oreDictEntries.get((int)i)).func_77973_b()).modId;
                if (!modid.equals("Minecraft") && !modid.equals("ThermalFoundation")) continue;
                ret = ((ItemStack)oreDictEntries.get(i)).func_77946_l();
                break;
            }
        }
        return ret;
    }

    public static ItemStack getStack(Object output) {
        if (output instanceof Item) {
            output = new ItemStack((Item)output);
        } else if (output instanceof Block) {
            output = new ItemStack((Block)output);
        }
        if (output instanceof ItemStack) {
            return ((ItemStack)output).func_77946_l();
        }
        if (output instanceof String) {
            String[] splits = ((String)output).split(",");
            ItemStack stack = IronManUtil.getPrefferedOre(splits[0]);
            if (stack != null && splits.length > 1) {
                stack.field_77994_a = Integer.parseInt(splits[1]);
                return stack;
            }
            return stack;
        }
        return null;
    }

    public static List<IronManRecipe> getRecipesFor(List<IronManRecipe> recipes, Object obj) {
        ArrayList<IronManRecipe> ret = new ArrayList<IronManRecipe>();
        block0: for (int i = 0; i < recipes.size(); ++i) {
            IronManRecipe recipe = recipes.get(i);
            for (int j = 0; j < recipe.outputs.length; ++j) {
                ItemStack stack2;
                ItemStack stack1 = IronManUtil.getStack(obj);
                if (!IronManUtil.areOresIdentical(stack1, stack2 = IronManUtil.getStack(recipe.outputs[j]))) continue;
                ret.add(recipes.get(i));
                continue block0;
            }
        }
        return ret;
    }

    public static IronManRecipe getMatchingRecipe(List<IronManRecipe> recipes, ItemStack[] input) {
        for (int i = 0; i < recipes.size(); ++i) {
            IronManRecipe recipe = recipes.get(i);
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    public static ItemStack[] readStacksFromNBT(int length, NBTTagCompound compound, String tag) {
        ItemStack[] stacks = new ItemStack[length];
        NBTTagList slotsList = compound.func_150295_c(tag, 10);
        for (int i = 0; i < slotsList.func_74745_c(); ++i) {
            NBTTagCompound slotTagCompound = slotsList.func_150305_b(i);
            byte slot = slotTagCompound.func_74771_c("slot");
            stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)slotTagCompound);
        }
        return stacks;
    }

    public static void writeStacksToNBT(ItemStack[] stacks, NBTTagCompound compound, String tag) {
        NBTTagList stacksList = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound slotTagCompound = new NBTTagCompound();
            slotTagCompound.func_74774_a("slot", (byte)i);
            stacks[i].func_77955_b(slotTagCompound);
            stacksList.func_74742_a((NBTBase)slotTagCompound);
        }
        compound.func_74782_a("slots", (NBTBase)stacksList);
    }

    public static void dropBlockContents(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IContentDropper)) {
            return;
        }
        ArrayList<ItemStack> drops = ((IContentDropper)tileEntity).getDrops();
        for (int i = 0; i < drops.size(); ++i) {
            ItemStack itemStack = drops.get(i);
            if (itemStack == null) continue;
            float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            while (itemStack.field_77994_a > 0) {
                int j1 = world.field_73012_v.nextInt(21) + 10;
                if (j1 > itemStack.field_77994_a) {
                    j1 = itemStack.field_77994_a;
                }
                itemStack.field_77994_a -= j1;
                EntityItem entityItem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemStack.func_77973_b(), j1, itemStack.func_77960_j()));
                if (itemStack.func_77942_o()) {
                    entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
                }
                float f3 = 0.05f;
                entityItem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                entityItem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                entityItem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                world.func_72838_d((Entity)entityItem);
            }
        }
    }

    public static int getIndexOfItem(Object item, ItemStack[] stacks) {
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            if (item instanceof Item) {
                item = new ItemStack((Item)item);
            } else if (item instanceof Block) {
                item = new ItemStack((Block)item);
            }
            if (item instanceof ItemStack) {
                if (!IronManUtil.areStacksEqual(stacks[i], (ItemStack)item)) continue;
                return i;
            }
            if (!(item instanceof String)) continue;
            ArrayList oreDictEntries = OreDictionary.getOres((String)((String)item).split(",")[0]);
            for (int j = 0; j < oreDictEntries.size(); ++j) {
                if (!IronManUtil.areStacksEqual(stacks[i], (ItemStack)oreDictEntries.get(j))) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return IronManUtil.areStacksEqual(stack1, stack2, false);
    }

    public static boolean areStacksEqual(ItemStack stack1, ItemStack stack2, boolean ignoreNBT) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && (ignoreNBT || !stack1.func_77942_o() && !stack2.func_77942_o());
    }

    public static boolean isItemWrench(Item item) {
        for (int i = 0; i < wrenchItems.size(); ++i) {
            if (wrenchItems.get(i) != item) continue;
            return true;
        }
        return false;
    }

    public static void wrenchBlock(World world, EntityPlayer player, int x, int y, int z) {
        IronManUtil.wrenchBlock(world, player, x, y, z, null);
    }

    public static void wrenchBlock(World world, EntityPlayer player, int x, int y, int z, IWrenchable wrenchable) {
        Block block = world.func_147439_a(x, y, z);
        if (world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            ItemStack stack = new ItemStack(block, 1, block.func_149692_a(world.func_72805_g(x, y, z)));
            if (wrenchable != null) {
                stack = wrenchable.onWrenched(stack, world.func_147438_o(x, y, z));
            }
            if (player.field_71071_by.func_70441_a(stack)) {
                player.field_71069_bz.func_75142_b();
            } else {
                EntityItem itemEntity = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
                itemEntity.field_145804_b = 0;
                world.func_72838_d((Entity)itemEntity);
            }
            block.func_149749_a(world, x, y, z, block, world.func_72805_g(x, y, z));
        }
        world.func_147468_f(x, y, z);
    }
}

