/*
 * Decompiled with CFR 0.152.
 */
package am2;

import am2.AMCore;
import am2.LogHelper;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class AMChunkLoader
implements ForgeChunkManager.LoadingCallback {
    public static final AMChunkLoader INSTANCE = new AMChunkLoader();
    private HashMap<TicketIdentifier, ForgeChunkManager.Ticket> tickets = new HashMap();

    private AMChunkLoader() {
    }

    private ForgeChunkManager.Ticket requestTicket(int x, int y, int z, World world) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)AMCore.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket != null) {
            this.cacheTicket(new TicketIdentifier(x, y, z, world.field_73011_w.field_76574_g), ticket);
            return ticket;
        }
        return null;
    }

    private void cacheTicket(TicketIdentifier identifier, ForgeChunkManager.Ticket ticket) {
        if (this.tickets.containsKey(identifier)) {
            LogHelper.warn("Attempted to register duplicate tickets for the same world - this shouldn't really happen.", new Object[0]);
            return;
        }
        this.tickets.put(identifier, ticket);
    }

    private ForgeChunkManager.Ticket getTicket(TicketIdentifier identifier) {
        return this.tickets.get(identifier);
    }

    public void requestStaticChunkLoad(Class clazz, int x, int y, int z, World world) {
        ForgeChunkManager.Ticket ticket = this.requestTicket(x, y, z, world);
        if (ticket == null) {
            LogHelper.warn("Unable to get a ticket for chunk loading!  The chunk identified by %d, %d is *not* loaded!", x, z);
            return;
        }
        NBTTagCompound compound = ticket.getModData();
        compound.func_74783_a("StaticLoadCoords", new int[]{x, y, z});
        compound.func_74778_a("ChunkLoadClass", clazz.getName());
        ChunkCoordIntPair pair = new ChunkCoordIntPair(x >> 4, z >> 4);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)pair);
    }

    public void releaseStaticChunkLoad(Class clazz, int x, int y, int z, World world) {
        ForgeChunkManager.Ticket ticket = this.getTicket(new TicketIdentifier(x, y, z, world.field_73011_w.field_76574_g));
        if (ticket == null) {
            LogHelper.warn("No ticket for specified location.  No chunk to unload!", new Object[0]);
            return;
        }
        ChunkCoordIntPair pair = new ChunkCoordIntPair(x >> 4, z >> 4);
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)pair);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            NBTTagCompound compound = ticket.getModData();
            int[] coords = compound.func_74759_k("StaticLoadCoords");
            String clazzName = compound.func_74779_i("ChunkLoadClass");
            Class<?> clazz = null;
            try {
                clazz = Class.forName(clazzName);
            }
            catch (ClassNotFoundException e) {
                LogHelper.info("Cached class not found (%s) when attempting to load a chunk loading ticket.  This ticket will be discarded, and the chunk may not be loaded.  Block Coords: %d, %d", clazzName, coords[0], coords[2]);
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                continue;
            }
            TileEntity te = world.func_147438_o(coords[0], coords[1], coords[2]);
            if (te != null && te.getClass().isAssignableFrom(clazz)) {
                ChunkCoordIntPair pair = new ChunkCoordIntPair(coords[0] >> 4, coords[2] >> 4);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)pair);
                continue;
            }
            LogHelper.info("Either no tile entity was found or it did not match the cached class.  This chunk loading ticket will be discarded, and the chunk may not be loaded.  Block Coords: %d, %d", coords[0], coords[2]);
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
    }

    private class TicketIdentifier
    implements Comparable<TicketIdentifier> {
        public final int dimension;
        public final int x;
        public final int y;
        public final int z;

        public TicketIdentifier(int x, int y, int z, int dimension) {
            this.dimension = dimension;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public int compareTo(TicketIdentifier o) {
            if (o.x == this.x && o.y == this.y && o.z == this.z && o.dimension == this.dimension) {
                return 0;
            }
            return -1;
        }
    }
}

