/*
 * Decompiled with CFR 0.152.
 */
package am2.api.spell.enums;

import net.minecraft.item.Item;

public enum Affinity {
    NONE(0, 0xFFFFFF, -1, new int[0], new int[0], new int[0]),
    ARCANE(1, 12137933, 9, new int[]{9, 4, 2, 7}, new int[]{5, 10}, new int[]{6, 3}),
    WATER(2, 744687, 3, new int[]{7, 4, 1, 10}, new int[]{5, 7}, new int[]{9, 8}),
    FIRE(3, 15672843, 2, new int[]{5, 7, 8, 9}, new int[]{4, 6}, new int[]{10, 1}),
    EARTH(4, 6370059, 5, new int[]{2, 1, 9, 6}, new int[]{8, 3}, new int[]{7, 10}),
    AIR(5, 0x777777, 4, new int[]{8, 3, 7, 10}, new int[]{2, 1}, new int[]{9, 6}),
    LIGHTNING(6, 14601753, 7, new int[]{2, 10, 8, 4}, new int[]{9, 3}, new int[]{5, 1}),
    ICE(7, 13887740, 6, new int[]{9, 3, 5, 1}, new int[]{2, 10}, new int[]{8, 4}),
    NATURE(8, 2262808, 6, new int[]{5, 10, 6, 3}, new int[]{9, 4}, new int[]{2, 7}),
    LIFE(9, 3465506, 10, new int[]{1, 7, 3, 4}, new int[]{8, 6}, new int[]{2, 5}),
    ENDER(10, 4129853, 9, new int[]{8, 6, 2, 5}, new int[]{1, 7}, new int[]{4, 3});

    public int ID;
    private int directOpposingAffinity;
    private int[] majorOppositions;
    private int[] minorOppositions;
    private int[] adjacentAffinities;
    public Item representItem;
    public int representMeta;
    public final int color;

    private Affinity(int ID, int color, int directOppositeAffinity, int[] majorOppositions, int[] minorOppositions, int[] adjacentAffinities) {
        this.ID = ID;
        this.directOpposingAffinity = directOppositeAffinity;
        this.majorOppositions = majorOppositions;
        this.minorOppositions = minorOppositions;
        this.adjacentAffinities = adjacentAffinities;
        this.color = color;
    }

    public Affinity getOpposingAffinity() {
        if (this.directOpposingAffinity > -1) {
            return Affinity.values()[this.directOpposingAffinity];
        }
        return NONE;
    }

    public Affinity[] getMajorOpposingAffinities() {
        Affinity[] opposing = new Affinity[this.majorOppositions.length];
        int count = 0;
        for (int i : this.majorOppositions) {
            opposing[count++] = Affinity.values()[i];
        }
        return opposing;
    }

    public Affinity[] getMinorOpposingAffinities() {
        Affinity[] opposing = new Affinity[this.minorOppositions.length];
        int count = 0;
        for (int i : this.minorOppositions) {
            opposing[count++] = Affinity.values()[i];
        }
        return opposing;
    }

    public Affinity[] getAdjacentAffinities() {
        Affinity[] adjacent = new Affinity[this.adjacentAffinities.length];
        int count = 0;
        for (int i : this.adjacentAffinities) {
            adjacent[count++] = Affinity.values()[i];
        }
        return adjacent;
    }

    public void setRepresentItem(Item representItem, int meta) {
        if (this.representItem == null) {
            this.representItem = representItem;
            this.representMeta = meta;
        }
    }

    public static Affinity getByID(int ID) {
        for (Affinity affinity : Affinity.values()) {
            if (affinity.ID != ID) continue;
            return affinity;
        }
        return NONE;
    }

    public static Affinity[] getOrderedAffinities() {
        return new Affinity[]{AIR, LIGHTNING, ARCANE, FIRE, ENDER, EARTH, ICE, NATURE, WATER, LIFE};
    }

    public int getAffinityMask() {
        switch (this) {
            case AIR: {
                return 1;
            }
            case ARCANE: {
                return 2;
            }
            case EARTH: {
                return 4;
            }
            case ENDER: {
                return 8;
            }
            case FIRE: {
                return 16;
            }
            case ICE: {
                return 32;
            }
            case LIFE: {
                return 64;
            }
            case LIGHTNING: {
                return 128;
            }
            case NATURE: {
                return 256;
            }
            case WATER: {
                return 512;
            }
        }
        return 0;
    }
}

