/*
 * Decompiled with CFR 0.152.
 */
package am2.armor;

import am2.AMCore;
import am2.api.items.armor.ArmorTextureEvent;
import am2.api.items.armor.IArmorImbuement;
import am2.api.items.armor.ImbuementApplicationTypes;
import am2.armor.ArmorHelper;
import am2.playerextensions.ExtendedProperties;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ArmorEventHandler {
    @SubscribeEvent
    public void onEntityLiving(LivingEvent.LivingUpdateEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        this.doInfusions(ImbuementApplicationTypes.ON_TICK, (Event)event, (EntityPlayer)event.entityLiving);
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        this.doInfusions(ImbuementApplicationTypes.ON_HIT, (Event)event, (EntityPlayer)event.entityLiving);
        if (event.entityLiving instanceof EntityPlayer) {
            this.doXPInfusion((EntityPlayer)event.entityLiving, 0.01f, Math.max(0.05f, Math.min(event.ammount, 5.0f)));
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        this.doInfusions(ImbuementApplicationTypes.ON_JUMP, (Event)event, (EntityPlayer)event.entityLiving);
    }

    @SubscribeEvent
    public void onMiningSpeed(PlayerEvent.BreakSpeed event) {
        this.doInfusions(ImbuementApplicationTypes.ON_MINING_SPEED, (Event)event, event.entityPlayer);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.source.func_76364_f() instanceof EntityPlayer) {
            this.doXPInfusion((EntityPlayer)event.source.func_76364_f(), 1.0f, Math.min(20.0f, event.entityLiving.func_110138_aP()));
        }
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        this.doInfusions(ImbuementApplicationTypes.ON_DEATH, (Event)event, (EntityPlayer)event.entityLiving);
    }

    private void doInfusions(ImbuementApplicationTypes type, Event event, EntityPlayer player) {
        ExtendedProperties props = ExtendedProperties.For((EntityLivingBase)player);
        for (int i = 0; i < 4; ++i) {
            IArmorImbuement[] infusions = ArmorHelper.getInfusionsOnArmor(player, i);
            int cd = props.armorProcCooldowns[i];
            for (IArmorImbuement inf : infusions) {
                if (inf == null || !inf.getApplicationTypes().contains((Object)type) || cd != 0 && !inf.canApplyOnCooldown() || !inf.applyEffect(player, player.field_70170_p, player.func_82169_q(i), type, event) || inf.getCooldown() <= 0 || props.armorProcCooldowns[i] >= inf.getCooldown()) continue;
                props.armorProcCooldowns[i] = inf.getCooldown();
                if (!(player instanceof EntityPlayerMP)) continue;
                AMCore.proxy.blackoutArmorPiece((EntityPlayerMP)player, i, inf.getCooldown());
            }
        }
    }

    private void doXPInfusion(EntityPlayer player, float xpMin, float xpMax) {
        float amt = (float)((double)(player.field_70170_p.field_73012_v.nextFloat() * xpMin + (xpMax - xpMin)) * AMCore.config.getArmorXPInfusionFactor());
        ArmorHelper.addXPToArmor(amt, player);
    }

    @SubscribeEvent
    public void onArmorTexture(ArmorTextureEvent event) {
        if (event.renderIndex == ArmorHelper.getArmorRenderIndex("mage")) {
            event.texture = event.slot == 2 ? "arsmagica2:textures/models/mage_2.png" : "arsmagica2:textures/models/mage_1.png";
        } else if (event.renderIndex == ArmorHelper.getArmorRenderIndex("battlemage")) {
            event.texture = event.slot == 2 ? "arsmagica2:textures/models/battlemage_2.png" : "arsmagica2:textures/models/battlemage_1.png";
        } else if (event.renderIndex == ArmorHelper.getArmorRenderIndex("archmage")) {
            event.texture = event.slot == 2 ? "arsmagica2:textures/models/archmage_2.png" : "arsmagica2:textures/models/archmage_1.png";
        } else if (event.renderIndex == ArmorHelper.getArmorRenderIndex("ender")) {
            event.texture = "arsmagica2:textures/models/ender_1.png";
        } else if (event.renderIndex == ArmorHelper.getArmorRenderIndex("magitech")) {
            event.texture = "arsmagica2:textures/models/magitech_1.png";
        }
    }
}

