/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.AMCore;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.PoweredBlock;
import am2.blocks.tileentities.TileEntityEverstone;
import am2.items.ItemsCommonProxy;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEverstone
extends PoweredBlock {
    private boolean wiresProvidePower = true;
    private Set blocksNeedingUpdate = new HashSet();

    protected BlockEverstone() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(3.0f);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityEverstone();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)world, x, y, z);
        if (everstone == null) {
            if (player.field_71075_bZ.field_75098_d) {
                world.func_147455_a(x, y, z, null);
                world.func_147468_f(x, y, z);
                return true;
            }
            return false;
        }
        everstone.onBreak();
        if (player.field_71075_bZ.field_75098_d) {
            world.func_147455_a(x, y, z, null);
            world.func_147468_f(x, y, z);
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getDrops(World arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return new ArrayList<ItemStack>();
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)world, x, y, z);
        if (everstone != null) {
            everstone.onBreak();
        }
        return 10000.0f;
    }

    private TileEntityEverstone getTE(IBlockAccess world, int x, int y, int z) {
        if (world == null) {
            return null;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return null;
        }
        return (TileEntityEverstone)te;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.func_70694_bm() != null) {
            Block block = null;
            int meta = -1;
            TileEntityEverstone everstone = this.getTE((IBlockAccess)world, x, y, z);
            if (everstone == null) {
                return false;
            }
            if (player.func_70694_bm().func_77973_b() == ItemsCommonProxy.crystalWrench) {
                if (!world.field_72995_K) {
                    if (everstone.getFacade() != null) {
                        everstone.setFacade(null, -1);
                        return true;
                    }
                    world.func_147468_f(x, y, z);
                    this.func_149642_a(world, x, y, z, new ItemStack((Block)BlocksCommonProxy.everstone));
                    return true;
                }
            } else if (player.func_70694_bm().func_77973_b() instanceof ItemBlock) {
                ItemBlock itemblock = (ItemBlock)player.func_70694_bm().func_77973_b();
                block = itemblock.field_150939_a;
                if (block.func_149662_c()) {
                    meta = itemblock.func_77647_b(player.func_70694_bm().func_77960_j());
                }
            }
            if (everstone.getFacade() == null && block != null) {
                everstone.setFacade(block, meta);
                world.func_147444_c(x, y, z, (Block)this);
                return true;
            }
        }
        return false;
    }

    public IIcon func_149691_a(int par1, int par2) {
        return this.field_149761_L;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return true;
    }

    public int func_149645_b() {
        return BlocksCommonProxy.commonBlockRenderID;
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)par1World, par2, par3, par4);
        if (everstone == null || everstone.isSolid()) {
            return super.func_149668_a(par1World, par2, par3, par4);
        }
        return null;
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)par1World, par2, par3, par4);
        if (everstone == null || everstone.isSolid()) {
            super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
        }
    }

    public IIcon func_149673_e(IBlockAccess par1iBlockAccess, int x, int y, int z, int face) {
        TileEntityEverstone everstone = this.getTE(par1iBlockAccess, x, y, z);
        if (everstone != null) {
            if (everstone.isSolid()) {
                Block block = everstone.getFacade();
                if (block != null) {
                    return block.func_149691_a(face, everstone.getFacadeMeta());
                }
            } else {
                return this.field_149761_L;
            }
        }
        return this.field_149761_L;
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        TileEntityEverstone everstone = this.getTE(world, x, y, z);
        if (everstone == null) {
            return true;
        }
        return everstone.isSolid();
    }

    public int func_149709_b(IBlockAccess par1iBlockAccess, int par2, int par3, int par4, int par5) {
        if (par1iBlockAccess instanceof World) {
            return ((World)par1iBlockAccess).func_94577_B(par2, par3, par4);
        }
        return 0;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)world, x, y, z);
        if (everstone == null) {
            return this.field_149782_v;
        }
        Block block = everstone.getFacade();
        if (block == null || block == this) {
            return this.field_149782_v;
        }
        return block.func_149712_f(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        TileEntityEverstone everstone = this.getTE((IBlockAccess)world, x, y, z);
        for (int i = 0; i < 5 * AMCore.config.getGFXLevel(); ++i) {
            Object block = Blocks.field_150350_a;
            int blockMeta = 0;
            if (everstone == null || everstone.getFacade() == null) {
                block = this;
            } else {
                block = everstone.getFacade();
                if (block == null) {
                    block = this;
                }
                blockMeta = everstone.getFacadeMeta();
            }
            effectRenderer.func_78873_a((EntityFX)new EntityDiggingFX(world, (double)x + world.field_73012_v.nextDouble(), (double)y + world.field_73012_v.nextDouble(), (double)z + world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, block, blockMeta, 0));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        BlockEverstone block;
        TileEntityEverstone everstone = this.getTE((IBlockAccess)worldObj, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        int blockMeta = 0;
        if (everstone == null || everstone.getFacade() == null) {
            block = this;
        } else {
            block = everstone.getFacade();
            if (block == null) {
                block = this;
            }
            blockMeta = everstone.getFacadeMeta();
        }
        effectRenderer.func_78873_a((EntityFX)new EntityDiggingFX(worldObj, (double)target.field_72311_b + worldObj.field_73012_v.nextDouble(), (double)target.field_72312_c + worldObj.field_73012_v.nextDouble(), (double)target.field_72309_d + worldObj.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, (Block)block, blockMeta, 0));
        return true;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = ResourceManager.RegisterTexture("everstone", par1IconRegister);
    }

    public int func_149701_w() {
        return 1;
    }
}

