/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.AMCore;
import am2.api.power.PowerTypes;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.PoweredBlock;
import am2.blocks.tileentities.TileEntityManaBattery;
import am2.entities.EntityDummyCaster;
import am2.power.PowerNodeRegistry;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockManaBattery
extends PoweredBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon frameIcon;

    public BlockManaBattery() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        super.func_149651_a(par1IconRegister);
        this.frameIcon = ResourceManager.RegisterTexture("mana_battery_frame", par1IconRegister);
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 15) {
            return this.frameIcon;
        }
        return this.field_149761_L;
    }

    @Override
    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        TileEntityManaBattery te;
        if (!super.func_149727_a(par1World, par2, par3, par4, par5EntityPlayer, par6, par7, par8, par9)) {
            return true;
        }
        if (par1World.field_72995_K && (te = this.getTileEntity(par1World, par2, par3, par4)) != null) {
            if (AMCore.config.colourblindMode()) {
                par5EntityPlayer.func_145747_a((IChatComponent)new ChatComponentText(String.format("Charge Level: %.2f %% [%s]", Float.valueOf(PowerNodeRegistry.For(par1World).getPower(te, te.getPowerType()) / te.getCapacity() * 100.0f), this.getColorNameFromPowerType(te.getPowerType()))));
            } else {
                par5EntityPlayer.func_145747_a((IChatComponent)new ChatComponentText(String.format("Charge Level: %s%.2f \u00a7f%%", te.getPowerType().chatColor(), Float.valueOf(PowerNodeRegistry.For(par1World).getPower(te, te.getPowerType()) / te.getCapacity() * 100.0f))));
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityManaBattery();
    }

    private TileEntityManaBattery getTileEntity(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityManaBattery) {
            return (TileEntityManaBattery)te;
        }
        return null;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (meta == 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack stack) {
        if (stack != null) {
            TileEntityManaBattery te = this.getTileEntity(par1World, par2, par3, par4);
            if (stack.field_77990_d != null) {
                if (stack.field_77990_d.func_74764_b("mana_battery_charge") && stack.field_77990_d.func_74764_b("mana_battery_powertype")) {
                    PowerNodeRegistry.For(par1World).setPower(te, PowerTypes.getByID(stack.field_77990_d.func_74762_e("mana_battery_powertype")), stack.field_77990_d.func_74760_g("mana_battery_charge"));
                } else {
                    te.setPowerType(PowerTypes.NONE, false);
                }
            }
        }
        super.func_149689_a(par1World, par2, par3, par4, par5EntityLiving, stack);
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        this.destroy(world, x, y, z);
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        this.destroy(world, x, y, z);
    }

    public void func_149681_a(World par1World, int par2, int par3, int par4, int par5, EntityPlayer par6EntityPlayer) {
        this.destroy(par1World, par2, par3, par4);
        super.func_149681_a(par1World, par2, par3, par4, par5, par6EntityPlayer);
    }

    public void func_149725_f(World par1World, int par2, int par3, int par4, int par5) {
        super.func_149725_f(par1World, par2, par3, par4, par5);
    }

    private void destroy(World world, int i, int j, int k) {
        TileEntityManaBattery te = this.getTileEntity(world, i, j, k);
        if (te != null && !world.field_72995_K) {
            float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            int dmg = (int)(PowerNodeRegistry.For(world).getPower(te, te.getPowerType()) / te.getCapacity() * 100.0f);
            if (dmg == 0) {
                dmg = 1;
            }
            ItemStack stack = new ItemStack((Block)this);
            stack.func_77972_a(stack.func_77958_k() - dmg, (EntityLivingBase)new EntityDummyCaster(world));
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74776_a("mana_battery_charge", PowerNodeRegistry.For(world).getPower(te, te.getPowerType()));
            stack.field_77990_d.func_74768_a("mana_battery_powertype", te.getPowerType().ID());
            if (!stack.field_77990_d.func_74764_b("Lore")) {
                stack.field_77990_d.func_74782_a("Lore", (NBTBase)new NBTTagList());
            }
            NBTTagList tagList = new NBTTagList();
            PowerTypes powerType = te.getPowerType();
            float amt = PowerNodeRegistry.For(world).getPower(te, powerType);
            tagList.func_74742_a((NBTBase)new NBTTagString(String.format("Contains %.2f %s%s etherium", Float.valueOf(amt), powerType.chatColor(), powerType.name())));
            stack.field_77990_d.func_74782_a("Lore", (NBTBase)tagList);
            EntityItem entityitem = new EntityItem(world, (double)((float)i + f), (double)((float)j + f1), (double)((float)k + f2), stack);
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public int func_149736_g(World world, int x, int y, int z, int meta) {
        TileEntityManaBattery batt = this.getTileEntity(world, x, y, z);
        if (batt == null) {
            return 0;
        }
        float pct = PowerNodeRegistry.For(world).getHighestPower(batt) / batt.getCapacity();
        return (int)Math.floor(15.0f * pct);
    }

    public boolean func_149740_M() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack stack = new ItemStack((Block)this);
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74776_a("mana_battery_charge", new TileEntityManaBattery().getCapacity());
        par3List.add(stack);
    }

    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityManaBattery) {
            TileEntityManaBattery battery = (TileEntityManaBattery)te;
            if (battery.getPowerType() == PowerTypes.DARK) {
                return 8719886;
            }
            if (battery.getPowerType() == PowerTypes.LIGHT) {
                return 6410179;
            }
            if (battery.getPowerType() == PowerTypes.NEUTRAL) {
                return 2524114;
            }
            return 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return BlocksCommonProxy.commonBlockRenderID;
    }

    public ArrayList<ItemStack> getDrops(World arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return new ArrayList<ItemStack>();
    }
}

