/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.api.power.IPowerNode;
import am2.api.power.PowerTypes;
import am2.power.PowerNodeRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileEntityAMPower
extends TileEntity
implements IPowerNode {
    protected int capacity;
    private boolean canRequestPower = true;
    private int tickCounter;
    private static final int REQUEST_INTERVAL = 20;

    public TileEntityAMPower(int capacity) {
        this.capacity = capacity;
    }

    protected void setNoPowerRequests() {
        this.canRequestPower = false;
    }

    protected void setPowerRequests() {
        this.canRequestPower = true;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    public void func_145843_s() {
        PowerNodeRegistry.For(this.field_145850_b).removePowerNode(this);
        super.func_145843_s();
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.canRequestPower() && this.tickCounter++ >= this.getRequestInterval()) {
            PowerTypes[] powerTypes;
            this.tickCounter = 0;
            for (PowerTypes type : powerTypes = this.getValidPowerTypes()) {
                float amtObtained = PowerNodeRegistry.For(this.field_145850_b).requestPower(this, type, this.getChargeRate());
                if (!(amtObtained > 0.0f)) continue;
                PowerNodeRegistry.For(this.field_145850_b).insertPower(this, type, amtObtained);
            }
        }
    }

    public int getRequestInterval() {
        return 20;
    }

    @Override
    public float particleOffset(int axis) {
        return 0.5f;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    public void func_145834_a(World par1World) {
        super.func_145834_a(par1World);
        PowerNodeRegistry.For(this.field_145850_b).registerPowerNode(this);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
    }

    @Override
    public float getCapacity() {
        return this.capacity;
    }

    public void setPower(PowerTypes type, float amount) {
        PowerNodeRegistry.For(this.field_145850_b).setPower(this, type, amount);
    }

    @Override
    public PowerTypes[] getValidPowerTypes() {
        return PowerTypes.all();
    }

    @Override
    public boolean canRequestPower() {
        return true;
    }

    @Override
    public boolean isSource() {
        return false;
    }
}

