/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.ObeliskFuelHelper;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.power.PowerTypes;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.tileentities.TileEntityAMPower;
import am2.buffs.BuffEffectManaRegen;
import am2.buffs.BuffList;
import am2.multiblock.IMultiblockStructureController;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.power.PowerNodeRegistry;
import am2.utility.InventoryUtilities;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityObelisk
extends TileEntityAMPower
implements IMultiblockStructureController,
IInventory {
    protected static int pillarBlockID = 98;
    protected static int pillarBlockMeta = 3;
    protected int surroundingCheckTicks;
    private ItemStack[] inventory;
    protected float powerMultiplier = 1.0f;
    protected float powerBase = 5.0f;
    public float offsetY = 0.0f;
    public float lastOffsetY = 0.0f;
    public int burnTimeRemaining = 0;
    public int maxBurnTime = 1;
    private static final byte PK_BURNTIME_CHANGE = 1;
    protected MultiblockStructureDefinition structure;
    protected MultiblockStructureDefinition.StructureGroup wizardChalkCircle;
    protected MultiblockStructureDefinition.StructureGroup pillars;
    protected HashMap<MultiblockStructureDefinition.StructureGroup, Float> caps;
    private static final int GROUP_CHISELED_STONE = 0;

    public TileEntityObelisk() {
        this(5000);
        this.inventory = new ItemStack[this.func_70302_i_()];
    }

    protected void checkNearbyBlockState() {
        ArrayList<MultiblockStructureDefinition.StructureGroup> groups = this.structure.getMatchedGroups(7, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        float capsLevel = 1.0f;
        boolean pillarsFound = false;
        boolean wizChalkFound = false;
        block0: for (MultiblockStructureDefinition.StructureGroup group : groups) {
            if (group == this.pillars) {
                pillarsFound = true;
            } else if (group == this.wizardChalkCircle) {
                wizChalkFound = true;
            }
            for (MultiblockStructureDefinition.StructureGroup cap : this.caps.keySet()) {
                if (group != cap) continue;
                capsLevel = this.caps.get(cap).floatValue();
                continue block0;
            }
        }
        this.powerMultiplier = 1.0f;
        if (wizChalkFound) {
            this.powerMultiplier = 1.25f;
        }
        if (pillarsFound) {
            this.powerMultiplier *= capsLevel;
        }
    }

    public TileEntityObelisk(int capacity) {
        super(capacity);
        this.setNoPowerRequests();
        this.surroundingCheckTicks = 0;
        this.structure = new MultiblockStructureDefinition("obelisk_structure");
        this.pillars = this.structure.createGroup("pillars", 2);
        this.caps = new HashMap();
        MultiblockStructureDefinition.StructureGroup chiseled = this.structure.createGroup("caps_chiseled_stone", 4);
        this.caps.put(chiseled, Float.valueOf(1.35f));
        this.structure.addAllowedBlock(0, 0, 0, BlocksCommonProxy.obelisk);
        this.structure.addAllowedBlock(this.pillars, -2, 0, -2, Blocks.field_150417_aV, 0);
        this.structure.addAllowedBlock(this.pillars, -2, 1, -2, Blocks.field_150417_aV, 0);
        this.structure.addAllowedBlock(chiseled, -2, 2, -2, Blocks.field_150417_aV, 3);
        this.structure.addAllowedBlock(this.pillars, 2, 0, -2, Blocks.field_150417_aV, 0);
        this.structure.addAllowedBlock(this.pillars, 2, 1, -2, Blocks.field_150417_aV, 0);
        this.structure.addAllowedBlock(chiseled, 2, 2, -2, Blocks.field_150417_aV, 3);
        this.structure.addAllowedBlock(this.pillars, -2, 0, 2, Blocks.field_150417_aV, 0);
        this.structure.addAllowedBlock(this.pillars, -2, 1, 2, Blocks.field_150417_aV, 0);
        this.structure.addAllowedBlock(chiseled, -2, 2, 2, Blocks.field_150417_aV, 3);
        this.structure.addAllowedBlock(this.pillars, 2, 0, 2, Blocks.field_150417_aV, 0);
        this.structure.addAllowedBlock(this.pillars, 2, 1, 2, Blocks.field_150417_aV, 0);
        this.structure.addAllowedBlock(chiseled, 2, 2, 2, Blocks.field_150417_aV, 3);
        this.wizardChalkCircle = this.addWizChalkGroupToStructure(this.structure, 1);
    }

    public boolean isActive() {
        return this.burnTimeRemaining > 0 || this.inventory[0] != null;
    }

    public boolean isHighPowerActive() {
        return this.burnTimeRemaining > 200 && this.inventory[0] != null;
    }

    public int getCookProgressScaled(int par1) {
        return this.burnTimeRemaining * par1 / this.maxBurnTime;
    }

    protected MultiblockStructureDefinition.StructureGroup addWizChalkGroupToStructure(MultiblockStructureDefinition def, int mutex) {
        MultiblockStructureDefinition.StructureGroup group = def.createGroup("wizardChalkCircle", mutex);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                def.addAllowedBlock(group, i, 0, j, BlocksCommonProxy.wizardChalk);
            }
        }
        return group;
    }

    protected void callSuperUpdate() {
        super.func_145845_h();
    }

    private void setMaxBurnTime(int burnTime) {
        if (burnTime == 0) {
            burnTime = 1;
        }
        this.maxBurnTime = burnTime;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    private void sendCookUpdateToClients() {
        if (!this.field_145850_b.field_72995_K) {
            AMNetHandler.INSTANCE.sendObeliskUpdate(this, new AMDataWriter().add((byte)1).add(this.burnTimeRemaining).generate());
        }
    }

    public void handlePacket(byte[] data) {
        AMDataReader rdr = new AMDataReader(data);
        if (rdr.ID == 1) {
            this.burnTimeRemaining = rdr.getInt();
        }
    }

    @Override
    public void func_145845_h() {
        ++this.surroundingCheckTicks;
        if (this.isActive()) {
            if (this.surroundingCheckTicks % 100 == 0) {
                this.checkNearbyBlockState();
                this.surroundingCheckTicks = 1;
                if (!this.field_145850_b.field_72995_K && PowerNodeRegistry.For(this.field_145850_b).checkPower(this, (float)this.capacity * 0.1f)) {
                    List nearbyPlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2)));
                    for (EntityPlayer p : nearbyPlayers) {
                        if (p.func_82165_m(BuffList.manaRegen.field_76415_H)) continue;
                        p.func_70690_d((PotionEffect)new BuffEffectManaRegen(600, 2));
                    }
                }
            }
            float powerAmt = PowerNodeRegistry.For(this.field_145850_b).getPower(this, PowerTypes.NEUTRAL);
            float powerAdded = this.inventory[0] != null ? (float)ObeliskFuelHelper.instance.getFuelBurnTime(this.inventory[0]) * (this.powerBase * this.powerMultiplier) : 0.0f;
            float chargeThreshold = Math.max(this.getCapacity() - powerAdded, this.getCapacity() * 0.75f);
            if (this.burnTimeRemaining <= 0 && powerAmt < chargeThreshold) {
                this.burnTimeRemaining = ObeliskFuelHelper.instance.getFuelBurnTime(this.inventory[0]);
                if (this.burnTimeRemaining > 0) {
                    this.setMaxBurnTime(this.burnTimeRemaining);
                    if (this.inventory[0].func_77973_b().hasContainerItem(this.inventory[0])) {
                        this.inventory[0] = new ItemStack(this.inventory[0].func_77973_b().func_77668_q());
                    } else {
                        InventoryUtilities.decrementStackQuantity(this, 0, 1);
                    }
                    this.sendCookUpdateToClients();
                }
            }
            if (this.burnTimeRemaining > 0) {
                --this.burnTimeRemaining;
                PowerNodeRegistry.For(this.field_145850_b).insertPower(this, PowerTypes.NEUTRAL, this.powerBase * this.powerMultiplier);
                if (this.burnTimeRemaining % 20 == 0) {
                    this.sendCookUpdateToClients();
                }
            }
        } else {
            this.surroundingCheckTicks = 1;
        }
        if (this.field_145850_b.field_72995_K) {
            this.lastOffsetY = this.offsetY;
            this.offsetY = (float)Math.max(Math.sin((float)this.field_145850_b.func_82737_E() / 20.0f) / 5.0, 0.25);
            if (this.burnTimeRemaining > 0) {
                --this.burnTimeRemaining;
            }
        }
        super.func_145845_h();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)((double)this.field_145848_d + 0.3), (double)(this.field_145849_e + 2));
    }

    @Override
    public MultiblockStructureDefinition getDefinition() {
        return this.structure;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("burnTimeRemaining", this.burnTimeRemaining);
        nbttagcompound.func_74768_a("maxBurnTime", this.maxBurnTime);
        if (this.inventory != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                String tag = String.format("ArrayIndex", i);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a(tag, (byte)i);
                this.inventory[i].func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            nbttagcompound.func_74782_a("BurnInventory", (NBTBase)nbttaglist);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.burnTimeRemaining = nbttagcompound.func_74762_e("burnTimeRemaining");
        this.setMaxBurnTime(nbttagcompound.func_74762_e("maxBurnTime"));
        if (nbttagcompound.func_74764_b("BurnInventory")) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("BurnInventory", 10);
            this.inventory = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                String tag = String.format("ArrayIndex", i);
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                byte byte0 = nbttagcompound1.func_74771_c(tag);
                if (byte0 < 0 || byte0 >= this.inventory.length) continue;
                this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            }
        }
    }

    @Override
    public int getChargeRate() {
        return 0;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return type == PowerTypes.NEUTRAL;
    }

    @Override
    public PowerTypes[] getValidPowerTypes() {
        return new PowerTypes[]{PowerTypes.NEUTRAL};
    }

    @Override
    public boolean canRequestPower() {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        if (i < 0 || i >= this.func_70302_i_()) {
            return null;
        }
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "obelisk";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return ObeliskFuelHelper.instance.getFuelBurnTime(itemstack) > 0;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }
}

