/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.AMCore;
import am2.api.flickers.IFlickerController;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.spell.enums.Affinity;
import am2.blocks.tileentities.flickers.FlickerOperatorRegistry;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class FlickerOperatorNaturesBounty
implements IFlickerFunctionality {
    @Override
    public boolean RequiresPower() {
        return false;
    }

    @Override
    public int PowerPerOperation() {
        return 5;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered) {
        return this.DoOperation(worldObj, habitat, powered, new Affinity[0]);
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
        int radius = 6;
        int diameter = radius * 2 + 1;
        boolean updatedOnce = false;
        if (!worldObj.field_72995_K) {
            for (int i = 0; i < (powered ? 5 : 1); ++i) {
                Block block;
                int effectY;
                int effectX = ((TileEntity)habitat).field_145851_c - radius + worldObj.field_73012_v.nextInt(diameter);
                int effectZ = ((TileEntity)habitat).field_145849_e - radius + worldObj.field_73012_v.nextInt(diameter);
                for (effectY = ((TileEntity)habitat).field_145848_d; worldObj.func_147437_c(effectX, effectY, effectZ) && effectY > 0; --effectY) {
                }
                while (!worldObj.func_147437_c(effectX, effectY, effectZ) && effectY > 0) {
                    ++effectY;
                }
                if (!((block = worldObj.func_147439_a(effectX, --effectY, effectZ)) instanceof IPlantable) && !(block instanceof IGrowable)) continue;
                block.func_149674_a(worldObj, effectX, effectY, effectZ, worldObj.field_73012_v);
                updatedOnce = true;
            }
        } else {
            int posY = ((TileEntity)habitat).field_145848_d;
            while (!worldObj.func_147437_c(((TileEntity)habitat).field_145851_c, posY, ((TileEntity)habitat).field_145849_e)) {
                ++posY;
            }
            --posY;
            for (int i = 0; i < AMCore.config.getGFXLevel() * 2; ++i) {
                AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(worldObj, "plant", (double)((TileEntity)habitat).field_145851_c + 0.5, (float)posY + 0.5f, (double)((TileEntity)habitat).field_145849_e + 0.5));
                if (particle == null) continue;
                particle.addRandomOffset(diameter, 0.0, diameter);
                particle.AddParticleController(new ParticleFloatUpward(particle, 0.01f, 0.04f, 1, false));
                particle.setMaxAge(16);
                particle.setParticleScale(0.08f);
            }
        }
        if (powered) {
            for (Affinity aff : flickers) {
                if (aff != Affinity.WATER) continue;
                FlickerOperatorRegistry.instance.getOperatorForMask(Affinity.WATER.getAffinityMask()).DoOperation(worldObj, habitat, powered);
            }
        }
        return updatedOnce;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController controller, boolean powered) {
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return powered ? 1 : 100;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController controller, boolean powered, Affinity[] flickers) {
    }

    @Override
    public Object[] getRecipe() {
        Object[] objectArray = new Object[15];
        objectArray[0] = "BAB";
        objectArray[1] = "LNW";
        objectArray[2] = "BGB";
        objectArray[3] = Character.valueOf('B');
        objectArray[4] = new ItemStack(Items.field_151100_aR, 1, 15);
        objectArray[5] = Character.valueOf('G');
        objectArray[6] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 6);
        objectArray[7] = Character.valueOf('N');
        objectArray[8] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 5);
        objectArray[9] = Character.valueOf('L');
        objectArray[10] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.LIFE.ordinal());
        objectArray[11] = Character.valueOf('A');
        objectArray[12] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.NATURE.ordinal());
        objectArray[13] = Character.valueOf('W');
        objectArray[14] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.WATER.ordinal());
        return objectArray;
    }
}

