/*
 * Decompiled with CFR 0.152.
 */
package am2.guis;

import am2.AMCore;
import am2.api.SkillTreeEntry;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.LearnStates;
import am2.api.spell.enums.SkillPointTypes;
import am2.api.spell.enums.SkillTrees;
import am2.guis.AMGuiHelper;
import am2.guis.AMGuiIcons;
import am2.guis.controls.GuiButtonSkillTreeTab;
import am2.lore.ArcaneCompendium;
import am2.lore.CompendiumEntryTypes;
import am2.playerextensions.AffinityData;
import am2.playerextensions.ExtendedProperties;
import am2.playerextensions.SkillData;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import am2.texture.SpellIconManager;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class GuiSkillTrees
extends GuiScreen {
    int xSize = 210;
    int ySize = 246;
    private GuiButtonSkillTreeTab offense;
    private GuiButtonSkillTreeTab defense;
    private GuiButtonSkillTreeTab utility;
    private GuiButtonSkillTreeTab talents;
    private GuiButtonSkillTreeTab affinity;
    private final int buttonPadding = 2;
    private final EntityPlayer player;
    private boolean isDragging = false;
    private int offsetX = 105;
    private int offsetY = 0;
    private final int IIcondims = 32;
    private int lastMouseX;
    private int lastMouseY;
    private SkillTrees activeTree;
    private SkillTreeEntry hoveredItem;
    private Affinity hoveredAffinity;
    private ArrayList<SkillTreeEntry> skillTree;
    private static final ResourceLocation rl_background = new ResourceLocation("arsmagica2", "textures/guis/SkillTreeUI.png");
    private static final ResourceLocation rl_offense = new ResourceLocation("arsmagica2", "textures/guis/SkillTree_Offense.png");
    private static final ResourceLocation rl_defense = new ResourceLocation("arsmagica2", "textures/guis/SkillTree_Defense.png");
    private static final ResourceLocation rl_utility = new ResourceLocation("arsmagica2", "textures/guis/SkillTree_Utility.png");
    private static final ResourceLocation rl_talents = new ResourceLocation("arsmagica2", "textures/guis/SkillTree_Talents.png");
    private static final ResourceLocation rl_items = new ResourceLocation("textures/atlas/items.png");

    public GuiSkillTrees(EntityPlayer player) {
        CompendiumEntryTypes.instance.initTextures();
        this.player = player;
        this.activeTree = SkillTrees.Offense;
        this.skillTree = SkillTreeManager.instance.getTree(this.activeTree);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int l = (this.field_146294_l - this.xSize) / 2 + 8;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        this.offense = new GuiButtonSkillTreeTab(0, l, i1, SkillTrees.Offense);
        this.defense = new GuiButtonSkillTreeTab(0, l + 22 + 2, i1, SkillTrees.Defense);
        this.utility = new GuiButtonSkillTreeTab(0, l + 44 + 4, i1, SkillTrees.Utility);
        this.talents = new GuiButtonSkillTreeTab(0, l + 66 + 6, i1, SkillTrees.Talents);
        this.affinity = new GuiButtonSkillTreeTab(0, l + 88 + 8, i1, SkillTrees.Affinity);
        this.offense.setActive(true);
        this.field_146292_n.add(this.offense);
        this.field_146292_n.add(this.defense);
        this.field_146292_n.add(this.utility);
        if (ExtendedProperties.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g).getMagicLevel() >= 5) {
            this.field_146292_n.add(this.talents);
        }
        if (!ArcaneCompendium.instance.getEntry("affinity").isLocked()) {
            this.field_146292_n.add(this.affinity);
        }
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton instanceof GuiButtonSkillTreeTab) {
            this.activeTree = ((GuiButtonSkillTreeTab)par1GuiButton).getTree();
            this.skillTree = SkillTreeManager.instance.getTree(this.activeTree);
            switch (this.activeTree) {
                case Defense: {
                    this.offsetX = 91;
                    this.offsetY = 0;
                    break;
                }
                case Offense: {
                    this.offsetX = 105;
                    this.offsetY = 0;
                    break;
                }
                case Utility: {
                    this.offsetX = 94;
                    this.offsetY = 3;
                }
            }
            for (Object button : this.field_146292_n) {
                if (!(button instanceof GuiButtonSkillTreeTab)) continue;
                ((GuiButtonSkillTreeTab)((Object)button)).setActive(false);
            }
            ((GuiButtonSkillTreeTab)par1GuiButton).setActive(true);
        }
        super.func_146284_a(par1GuiButton);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        SkillData sk = SkillData.For((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        if (AMCore.config.getSkillTreeSecondaryTierCap() < SkillTreeManager.instance.getHighestTier() && (sk.getPrimaryTree() == null || sk.getPrimaryTree() == SkillTrees.None) && sk.getSpellPoints(SkillPointTypes.BLUE) > 0) {
            String s = StatCollector.func_74838_a((String)"am2.gui.lockWarning");
            this.field_146289_q.func_78279_b(s, l - 120, i1 + 20, 110, 12542757);
        }
        if (this.isDragging) {
            int dx = this.lastMouseX - par1;
            int dy = this.lastMouseY - par2;
            this.offsetX += dx;
            this.offsetY += dy;
            if (this.offsetX < 0) {
                this.offsetX = 0;
            }
            if (this.offsetX > 180) {
                this.offsetX = 180;
            }
            if (this.offsetY < 0) {
                this.offsetY = 0;
            }
            if (this.offsetY > 180) {
                this.offsetY = 180;
            }
        }
        this.lastMouseX = par1;
        this.lastMouseY = par2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.activeTree == SkillTrees.Offense) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(rl_offense);
        } else if (this.activeTree == SkillTrees.Defense) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(rl_defense);
        } else if (this.activeTree == SkillTrees.Utility) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(rl_utility);
        } else if (this.activeTree == SkillTrees.Talents || this.activeTree == SkillTrees.Affinity) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(rl_talents);
        } else {
            return;
        }
        this.drawTexturedModalRect_Classic(l + 5, i1 + 22 + 5, this.offsetX, this.offsetY, 200, 200, 75, 75);
        if (this.activeTree == SkillTrees.Affinity) {
            this.drawAffinity();
        } else {
            this.drawSkillTree();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(rl_background);
        this.func_73729_b(l, i1 + 22, 0, 0, 210, 210);
        this.func_73729_b(l + this.xSize - 29, i1, 210, 0, 37, 37);
        String quantity = String.format("%d", sk.getSpellPoints(SkillPointTypes.BLUE));
        Minecraft.func_71410_x().field_71466_p.func_78276_b(quantity, l + this.xSize - 24 - Minecraft.func_71410_x().field_71466_p.func_78256_a(quantity) / 2, i1 + 5, 255);
        quantity = String.format("%d", sk.getSpellPoints(SkillPointTypes.GREEN));
        Minecraft.func_71410_x().field_71466_p.func_78276_b(quantity, l + this.xSize - 12 - Minecraft.func_71410_x().field_71466_p.func_78256_a(quantity) / 2, i1 + 5, 65280);
        quantity = String.format("%d", sk.getSpellPoints(SkillPointTypes.RED));
        Minecraft.func_71410_x().field_71466_p.func_78276_b(quantity, l + this.xSize - 18 - Minecraft.func_71410_x().field_71466_p.func_78256_a(quantity) / 2, i1 + 15, 0xFF0000);
        super.func_73863_a(par1, par2, par3);
        if (this.hoveredItem != null) {
            ArrayList<String> text = new ArrayList<String>();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            String s = SkillManager.instance.getDisplayName(this.hoveredItem.registeredItem);
            LearnStates state = sk.getLearnState(this.hoveredItem, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (state == LearnStates.LEARNED) {
                s = s + " (" + StatCollector.func_74838_a((String)"am2.gui.known") + ")";
            } else if (state == LearnStates.CAN_LEARN) {
                s = s + " (" + StatCollector.func_74838_a((String)"am2.gui.notLearned") + ")";
            } else if (state == LearnStates.DISABLED) {
                s = StatCollector.func_74838_a((String)"am2.gui.cfgDisabled");
            }
            text.add(s);
            SkillPointTypes type = SkillTreeManager.instance.getSkillPointTypeForPart(this.hoveredItem.registeredItem);
            if (this.hoveredItem.registeredItem instanceof ISpellComponent) {
                EnumSet<Affinity> aff = ((ISpellComponent)this.hoveredItem.registeredItem).getAffinity();
                int affX = this.lastMouseX + 14;
                int affY = this.lastMouseY - 34;
                this.drawGradientAround(affX - 2, affY - 2, 18 * aff.size() + 2, 18);
                for (Affinity a : aff) {
                    if (a == Affinity.NONE) continue;
                    this.DrawIconAtXY(a.representItem.func_77617_a(a.representMeta), "item", affX, affY, 16, 16, false);
                    affX += 18;
                }
            }
            if (!AMCore.config.colourblindMode()) {
                this.drawHoveringText(text, this.lastMouseX, this.lastMouseY, fr, state == LearnStates.LEARNED ? 0xFFFFFF : (type == SkillPointTypes.SILVER ? 0x888888 : (type == SkillPointTypes.BLUE ? 0x4444FF : (type == SkillPointTypes.GREEN ? 0x44FF44 : 0xFF4444))));
            } else {
                text.add(StatCollector.func_74838_a((String)("am2.gui." + type.toString().toLowerCase() + "Point")));
                this.drawHoveringText(text, this.lastMouseX, this.lastMouseY, fr, 0xFFFFFF);
            }
        }
        if (this.hoveredAffinity != null) {
            List list = AffinityData.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g).getColoredAffinityEffects(this.hoveredAffinity);
            this.drawHoveringText(list, this.lastMouseX, this.lastMouseY, this.field_146289_q, 0xFFFFFF);
        }
    }

    private void drawSkillTree() {
        int color;
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2 + 22;
        SkillData sk = SkillData.For((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        for (SkillTreeEntry entry : this.skillTree) {
            if (entry.prerequisites == null || entry.prerequisites.length == 0) continue;
            for (SkillTreeEntry prerequisite : entry.prerequisites) {
                color = 0;
                if (!sk.isEntryKnown(prerequisite) && sk.getLearnState(prerequisite, (EntityPlayer)Minecraft.func_71410_x().field_71439_g) != LearnStates.DISABLED) continue;
                color = 26112;
                this.line2d(l + entry.x - this.offsetX * 2 + 16, i1 + entry.y - this.offsetY * 2 + 16, l + entry.x - this.offsetX * 2 + 16, i1 + prerequisite.y - this.offsetY * 2 + 16, color);
                this.line2d(l + entry.x - this.offsetX * 2 + 16, i1 + prerequisite.y - this.offsetY * 2 + 16, l + prerequisite.x - this.offsetX * 2 + 16, i1 + prerequisite.y - this.offsetY * 2 + 16, color);
            }
        }
        for (SkillTreeEntry entry : this.skillTree) {
            if (entry.prerequisites == null || entry.prerequisites.length == 0) continue;
            for (SkillTreeEntry prerequisite : entry.prerequisites) {
                color = 0;
                LearnStates state = sk.getLearnState(entry, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                if (sk.isEntryKnown(prerequisite) && (state == LearnStates.CAN_LEARN || state == LearnStates.LEARNED) || sk.getLearnState(prerequisite, (EntityPlayer)Minecraft.func_71410_x().field_71439_g) == LearnStates.DISABLED) continue;
                color = 0x220000;
                this.line2d(l + entry.x - this.offsetX * 2 + 16, i1 + entry.y - this.offsetY * 2 + 16, l + entry.x - this.offsetX * 2 + 16, i1 + prerequisite.y - this.offsetY * 2 + 16, color);
                this.line2d(l + entry.x - this.offsetX * 2 + 16, i1 + prerequisite.y - this.offsetY * 2 + 16, l + prerequisite.x - this.offsetX * 2 + 16, i1 + prerequisite.y - this.offsetY * 2 + 16, color);
            }
        }
        SkillTreeEntry hovered = null;
        for (SkillTreeEntry entry : this.skillTree) {
            if (entry.registeredItem == null) continue;
            String name = SkillManager.instance.getSkillName(entry.registeredItem);
            if (name == null) {
                name = "";
            }
            IIcon IIcon2 = SpellIconManager.instance.getIcon(name);
            LearnStates state = sk.getLearnState(entry, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (state == LearnStates.LEARNED) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            } else if (state == LearnStates.CAN_LEARN) {
                float min = 0.2f;
                float delta = 0.45f * (1.0f - Math.abs((float)AMGuiHelper.instance.getFastTicker() - 20.0f) / 20.0f);
                float colorShift = 0.25f;
                SkillPointTypes type = SkillTreeManager.instance.getSkillPointTypeForPart(entry.registeredItem);
                if (type == SkillPointTypes.SILVER) {
                    GL11.glColor3f((float)(min + delta + colorShift), (float)(min + delta + colorShift), (float)(min + delta + colorShift));
                } else {
                    GL11.glColor3f((float)(min + delta + (type == SkillPointTypes.RED ? colorShift : 0.0f)), (float)(min + delta + (type == SkillPointTypes.GREEN ? colorShift : 0.0f)), (float)(min + delta + (type == SkillPointTypes.BLUE ? colorShift : 0.0f)));
                }
            } else {
                GL11.glColor3f((float)0.1f, (float)0.1f, (float)0.1f);
            }
            this.DrawConstrainedIconAtXY(IIcon2, l + entry.x - this.offsetX * 2, i1 + entry.y - this.offsetY * 2, 32, 32, false);
            if (state == LearnStates.LOCKED) {
                GL11.glColor4f((float)0.3f, (float)0.3f, (float)0.3f, (float)0.8f);
                this.DrawConstrainedIconAtXY(AMGuiIcons.padlock, (float)(l + entry.x - this.offsetX * 2) + 8.5f, i1 + entry.y - this.offsetY * 2 + 8, 15, 15, true);
            } else if (state == LearnStates.DISABLED) {
                GL11.glColor4f((float)1.0f, (float)0.3f, (float)0.3f, (float)0.8f);
                this.DrawConstrainedIconAtXY(AMGuiIcons.padlock, (float)(l + entry.x - this.offsetX * 2) + 8.5f, i1 + entry.y - this.offsetY * 2 + 8, 15, 15, true);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.lastMouseX <= l || this.lastMouseX >= l + this.xSize || this.lastMouseY <= i1 || this.lastMouseY >= i1 + this.ySize || this.lastMouseX <= l + entry.x - this.offsetX * 2 || this.lastMouseX >= l + entry.x - this.offsetX * 2 + 32 || this.lastMouseY <= i1 + entry.y - this.offsetY * 2 || this.lastMouseY >= i1 + entry.y - this.offsetY * 2 + 32) continue;
            hovered = entry;
        }
        this.hoveredItem = hovered;
    }

    private void drawAffinity() {
        this.hoveredAffinity = null;
        int l = (this.field_146294_l - this.xSize) / 2;
        int i1 = (this.field_146295_m - this.ySize) / 2;
        int IIconsize = 16;
        int halfIconSize = IIconsize / 2;
        int cx = l + this.xSize / 2 - halfIconSize;
        int cy = i1 + this.ySize / 2 - halfIconSize;
        int angle = -90;
        int distance = 85;
        int smallDist = 15;
        float angleOffset = 17.5f;
        AffinityData ad = AffinityData.For((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        for (Affinity aff : Affinity.getOrderedAffinities()) {
            IIcon IIcon2 = aff.representItem.func_77617_a(aff.representMeta);
            int newX = (int)((double)cx + Math.cos(Math.toRadians(angle)) * (double)distance);
            int newY = (int)((double)cy + Math.sin(Math.toRadians(angle)) * (double)distance);
            int cx1 = (int)((double)cx + Math.cos(Math.toRadians((float)angle + angleOffset)) * (double)smallDist);
            int cx2 = (int)((double)cx + Math.cos(Math.toRadians((float)angle - angleOffset)) * (double)smallDist);
            int cy1 = (int)((double)cy + Math.sin(Math.toRadians((float)angle + angleOffset)) * (double)smallDist);
            int cy2 = (int)((double)cy + Math.sin(Math.toRadians((float)angle - angleOffset)) * (double)smallDist);
            float depthDist = (float)(distance - smallDist) * ad.getAffinityDepth(aff) + (float)smallDist;
            int lx = (int)((double)cx + Math.cos(Math.toRadians(angle)) * (double)depthDist);
            int ly = (int)((double)cy + Math.sin(Math.toRadians(angle)) * (double)depthDist);
            int displace = (int)((float)(Math.max(cx1, cx2) - Math.min(cx1, cx2) + Math.max(cy1, cy2) - Math.min(cy1, cy2)) / 3.0f);
            if (ad.getAffinityDepth(aff) > 0.01f) {
                AMGuiHelper.fractalLine2d(lx + halfIconSize, ly + halfIconSize, cx1 + halfIconSize, cy1 + halfIconSize, this.field_73735_i, aff.color, displace, 1.1f);
                AMGuiHelper.fractalLine2d(lx + halfIconSize, ly + halfIconSize, cx2 + halfIconSize, cy2 + halfIconSize, this.field_73735_i, aff.color, displace, 1.1f);
                AMGuiHelper.fractalLine2d(cx1 + halfIconSize, cy1 + halfIconSize, lx + halfIconSize, ly + halfIconSize, this.field_73735_i, aff.color, displace, 0.8f);
                AMGuiHelper.fractalLine2d(cx2 + halfIconSize, cy2 + halfIconSize, lx + halfIconSize, ly + halfIconSize, this.field_73735_i, aff.color, displace, 0.8f);
            } else {
                AMGuiHelper.line2d(lx + halfIconSize, ly + halfIconSize, cx1 + halfIconSize, cy1 + halfIconSize, this.field_73735_i, aff.color);
                AMGuiHelper.line2d(lx + halfIconSize, ly + halfIconSize, cx2 + halfIconSize, cy2 + halfIconSize, this.field_73735_i, aff.color);
            }
            this.DrawIconAtXY(IIcon2, "items", newX, newY, IIconsize, IIconsize, false);
            String depthString = String.format("%.2f", Float.valueOf(ad.getAffinityDepth(aff) * 100.0f));
            this.field_146289_q.func_85187_a(depthString, newX + halfIconSize - this.field_146289_q.func_78256_a(depthString) / 2, newY + IIconsize, aff.color, false);
            angle += 36;
            if (this.lastMouseX <= newX || this.lastMouseX >= newX + IIconsize || this.lastMouseY <= newY || this.lastMouseY >= newY + IIconsize) continue;
            this.hoveredAffinity = aff;
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        if (par3 == 0) {
            if (this.hoveredItem != null) {
                SkillData sk = SkillData.For((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                if (!sk.isEntryKnown(this.hoveredItem) && sk.getLearnState(this.hoveredItem, (EntityPlayer)Minecraft.func_71410_x().field_71439_g) == LearnStates.CAN_LEARN) {
                    sk.learn(this.hoveredItem.registeredItem);
                }
            } else {
                if (this.activeTree != SkillTrees.Affinity) {
                    this.isDragging = true;
                }
                this.lastMouseX = par1;
                this.lastMouseY = par2;
            }
        }
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        super.func_146286_b(par1, par2, par3);
        if (par3 != -1) {
            this.isDragging = false;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void drawTexturedModalRect_Classic(int dst_x, int dst_y, int src_x, int src_y, int dst_width, int dst_height, int src_width, int src_height) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(dst_x + 0), (double)(dst_y + dst_height), (double)this.field_73735_i, (double)((float)(src_x + 0) * var7), (double)((float)(src_y + src_height) * var8));
        var9.func_78374_a((double)(dst_x + dst_width), (double)(dst_y + dst_height), (double)this.field_73735_i, (double)((float)(src_x + src_width) * var7), (double)((float)(src_y + src_height) * var8));
        var9.func_78374_a((double)(dst_x + dst_width), (double)(dst_y + 0), (double)this.field_73735_i, (double)((float)(src_x + src_width) * var7), (double)((float)(src_y + 0) * var8));
        var9.func_78374_a((double)(dst_x + 0), (double)(dst_y + 0), (double)this.field_73735_i, (double)((float)(src_x + 0) * var7), (double)((float)(src_y + 0) * var8));
        var9.func_78381_a();
    }

    private void DrawIconAtXY(IIcon IIcon2, String base, float x, float y, int w, int h, boolean semitransparent) {
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        if (semitransparent) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        this.field_146297_k.field_71446_o.func_110577_a(rl_items);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + (float)h), (double)this.field_73735_i, (double)IIcon2.func_94209_e(), (double)IIcon2.func_94210_h());
        tessellator.func_78374_a((double)(x + (float)w), (double)(y + (float)h), (double)this.field_73735_i, (double)IIcon2.func_94212_f(), (double)IIcon2.func_94210_h());
        tessellator.func_78374_a((double)(x + (float)w), (double)y, (double)this.field_73735_i, (double)IIcon2.func_94212_f(), (double)IIcon2.func_94206_g());
        tessellator.func_78374_a((double)x, (double)y, (double)this.field_73735_i, (double)IIcon2.func_94209_e(), (double)IIcon2.func_94206_g());
        tessellator.func_78381_a();
        if (semitransparent) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
    }

    private void DrawConstrainedIconAtXY(IIcon IIcon2, float x, float y, int w, int h, boolean semitransparent) {
        float tempH;
        float tempW;
        float delta;
        int l = (this.field_146294_l - this.xSize) / 2 + 3;
        int i1 = (this.field_146295_m - this.ySize) / 2 + 22;
        int wid = this.xSize - 10;
        int hei = this.ySize - 40;
        if (x + (float)w < (float)l || x > (float)(l + wid)) {
            return;
        }
        if (y + (float)h < (float)i1 || y > (float)(i1 + hei)) {
            return;
        }
        float wFactor = 1.0f;
        float hFactor = 1.0f;
        float minU = IIcon2.func_94209_e();
        float minV = IIcon2.func_94206_g();
        float maxU = IIcon2.func_94212_f();
        float maxV = IIcon2.func_94210_h();
        float deltaU = maxU - minU;
        float deltaV = maxV - minV;
        if (x < (float)l) {
            delta = (float)l - x;
            x += delta;
            tempW = (float)w - delta;
            wFactor = tempW / (float)w;
            if (wFactor <= 0.0f) {
                return;
            }
            minU += deltaU - deltaU * wFactor;
            w = (int)((float)w - delta);
        } else if (x + (float)w > (float)(l + wid)) {
            delta = x + (float)w - (float)(l + wid);
            tempW = (float)w - delta;
            wFactor = tempW / (float)w;
            if (wFactor <= 0.0f) {
                return;
            }
            maxU -= deltaU - deltaU * wFactor;
            w = (int)((float)w - delta);
        }
        if (y < (float)i1) {
            delta = (float)i1 - y;
            y += delta;
            tempH = (float)h - delta;
            hFactor = tempH / (float)h;
            if (hFactor <= 0.0f) {
                return;
            }
            minV += deltaV - deltaV * hFactor;
            h = (int)((float)h - delta);
        } else if (y + (float)h > (float)(i1 + hei)) {
            delta = y + (float)h - (float)(i1 + hei);
            tempH = (float)h - delta;
            hFactor = tempH / (float)h;
            if (hFactor <= 0.0f) {
                return;
            }
            maxV -= deltaV - deltaV * hFactor;
            h = (int)((float)h - delta);
        }
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        if (semitransparent) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
        this.field_146297_k.field_71446_o.func_110577_a(rl_items);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + (float)h), (double)this.field_73735_i, (double)minU, (double)maxV);
        tessellator.func_78374_a((double)(x + (float)w), (double)(y + (float)h), (double)this.field_73735_i, (double)maxU, (double)maxV);
        tessellator.func_78374_a((double)(x + (float)w), (double)y, (double)this.field_73735_i, (double)maxU, (double)minV);
        tessellator.func_78374_a((double)x, (double)y, (double)this.field_73735_i, (double)minU, (double)minV);
        tessellator.func_78381_a();
        if (semitransparent) {
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
    }

    private void line2d(int src_x, int src_y, int dst_x, int dst_y, int color) {
        int l = (this.field_146294_l - this.xSize) / 2 + 3;
        int i1 = (this.field_146295_m - this.ySize) / 2 + 22;
        int w = this.xSize - 5;
        int h = this.ySize - 40;
        if (src_x < l && dst_x < l || src_x > l + w && dst_x > l + w) {
            return;
        }
        if (src_y < i1 && dst_y < i1 || src_y > i1 + h && dst_y > i1 + h) {
            return;
        }
        if (src_x < l) {
            src_x = l;
        } else if (src_x > l + w) {
            src_x = l + w;
        }
        if (dst_x < l) {
            dst_x = l;
        } else if (dst_x > l + w) {
            dst_x = l + w;
        }
        if (src_y < i1) {
            src_y = i1;
        } else if (src_y > i1 + h) {
            src_y = i1 + h;
        }
        if (dst_y < i1) {
            dst_y = i1;
        } else if (dst_y > i1 + h) {
            dst_y = i1 + h;
        }
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)4.0f);
        GL11.glColor3f((float)((color & 0xFF0000) >> 16), (float)((color & 0xFF00) >> 8), (float)(color & 0xFF));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)src_x, (float)src_y, (float)this.field_73735_i);
        GL11.glVertex3f((float)dst_x, (float)dst_y, (float)this.field_73735_i);
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    private void drawGradientAround(int x, int y, int width, int height) {
        int pad = 3;
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int l1 = -267386864;
        this.func_73733_a(x - pad, y - 4, x + width + pad, y - pad, l1, l1);
        this.func_73733_a(x - pad, y + height + pad, x + width + pad, y + height + 4, l1, l1);
        this.func_73733_a(x - pad, y - pad, x + width + pad, y + height + pad, l1, l1);
        this.func_73733_a(x - 4, y - pad, x - pad, y + height + pad, l1, l1);
        this.func_73733_a(x + width + pad, y - pad, x + width + 4, y + height + pad, l1, l1);
        int i2 = 0x505000FF;
        int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
        this.func_73733_a(x - pad, y - pad + 1, x - pad + 1, y + height + pad - 1, i2, j2);
        this.func_73733_a(x + width + 2, y - pad + 1, x + width + pad, y + height + pad - 1, i2, j2);
        this.func_73733_a(x - pad, y - pad, x + width + pad, y - pad + 1, i2, i2);
        this.func_73733_a(x - pad, y + height + 2, x + width + pad, y + height + pad, j2, j2);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    protected void drawHoveringText(List par1List, int par2, int par3, FontRenderer font, int color) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                font.func_78261_a(s1, i1, j1, color);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }
}

