/*
 * Decompiled with CFR 0.152.
 */
package am2.particles.ribbon;

import am2.api.math.AMVector3;
import am2.particles.ribbon.PerlinNoise;
import am2.particles.ribbon.RibbonCurve;
import java.util.LinkedList;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class AMRibbon
extends EntityFX {
    int NUMCURVES = 5;
    int CURVERESOLUTION = 25;
    float RIBBONWIDTH = 2.25f;
    float NOISESTEP = 0.005f;
    float MAXSEPARATION = 2.0f;
    PerlinNoise noise;
    float ribbonSeparation;
    float noisePosn;
    Vector pts;
    LinkedList curves;
    float ribbonColor;
    float ribbonWidth;
    RibbonCurve currentCurve;
    int stepId;
    int movement = 2;
    AMVector3 ribbonTarget;

    public AMRibbon(World world, float pcolor, float width, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.func_70107_b(x, y, z);
        this.func_70016_h(0.0, 0.0, 0.0);
        this.noise = new PerlinNoise();
        this.curves = new LinkedList();
        this.pts = new Vector();
        this.ribbonColor = pcolor;
        this.ribbonWidth = width;
        this.stepId = 0;
        this.ribbonTarget = new AMVector3(this.random(-this.movement, this.movement), this.random(-this.movement, this.movement), this.random(-this.movement, this.movement));
        this.ribbonSeparation = this.lerp(-this.MAXSEPARATION, this.MAXSEPARATION, this.noise.noise1(this.noisePosn += this.NOISESTEP));
        this.pts.addElement(this.getRandPt());
        this.pts.addElement(this.getRandPt());
        this.pts.addElement(this.getRandPt());
        this.field_70546_d = 0;
        this.field_70547_e = 200;
        this.field_70155_l = 1.0;
        this.addRibbonCurve();
    }

    public void func_70539_a(Tessellator par1Tessellator, float partialframe, float cosyaw, float cospitch, float sinyaw, float sinsinpitch, float cossinpitch) {
        par1Tessellator.func_78381_a();
        GL11.glPushAttrib((int)16640);
        GL11.glDisable((int)2884);
        GL11.glTexEnvf((int)8960, (int)8704, (float)8448.0f);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        double d = this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialframe - RenderManager.field_78727_a.field_78730_l;
        double d1 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialframe - RenderManager.field_78727_a.field_78731_m;
        double d2 = this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialframe - RenderManager.field_78727_a.field_78728_n;
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.draw();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        par1Tessellator.func_78382_b();
    }

    public int func_70537_b() {
        return 2;
    }

    void draw() {
        this.ribbonTarget = new AMVector3(this.random(-this.movement, this.movement), this.random(-this.movement, this.movement), this.random(-this.movement, this.movement));
        this.ribbonSeparation = this.lerp(-this.MAXSEPARATION, this.MAXSEPARATION, this.noise.noise1(this.noisePosn += this.NOISESTEP));
        this.currentCurve.addSegment();
        int size = this.curves.size();
        if (size > this.NUMCURVES - 1) {
            RibbonCurve c = (RibbonCurve)this.curves.get(0);
            c.removeSegment();
        }
        ++this.stepId;
        if (this.stepId > this.CURVERESOLUTION) {
            this.addRibbonCurve();
        }
        for (int i = 0; i < size; ++i) {
            RibbonCurve c = (RibbonCurve)this.curves.get(i);
            c.draw();
        }
    }

    private float random(float min, float max) {
        return (float)(Math.random() * (double)max - (double)min);
    }

    private float lerp(float start, float stop, float amount) {
        return start + (stop - start) * amount;
    }

    void addRibbonCurve() {
        this.pts.addElement(this.getRandPt());
        AMVector3 nextPt = (AMVector3)this.pts.elementAt(this.pts.size() - 1);
        AMVector3 curPt = (AMVector3)this.pts.elementAt(this.pts.size() - 2);
        AMVector3 lastPt = (AMVector3)this.pts.elementAt(this.pts.size() - 3);
        AMVector3 lastMidPt = new AMVector3((curPt.x + lastPt.x) / 2.0f, (curPt.y + lastPt.y) / 2.0f, (curPt.z + lastPt.z) / 2.0f);
        AMVector3 midPt = new AMVector3((curPt.x + nextPt.x) / 2.0f, (curPt.y + nextPt.y) / 2.0f, (curPt.z + nextPt.z) / 2.0f);
        float width = 0.2f;
        this.currentCurve = new RibbonCurve(lastMidPt, midPt, curPt, width, this.CURVERESOLUTION, this.ribbonColor);
        this.curves.add(this.currentCurve);
        if (this.curves.size() > this.NUMCURVES) {
            this.curves.removeFirst();
        }
        this.stepId = 0;
    }

    private static AMVector3 getRelativeViewVector(AMVector3 pos) {
        EntityClientPlayerMP renderentity = Minecraft.func_71410_x().field_71439_g;
        return new AMVector3((float)renderentity.field_70165_t - pos.x, (float)renderentity.field_70163_u - pos.y, (float)renderentity.field_70161_v - pos.z);
    }

    AMVector3 getRandPt() {
        return new AMVector3(this.ribbonTarget.x + this.random(-this.ribbonSeparation, this.ribbonSeparation), this.ribbonTarget.y + this.random(-this.ribbonSeparation, this.ribbonSeparation), this.ribbonTarget.z + this.random(-this.ribbonSeparation, this.ribbonSeparation));
    }

    public boolean func_70112_a(double par1) {
        return true;
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }
}

