/*
 * Decompiled with CFR 0.152.
 */
package am2.preloader;

import am2.LogHelper;
import am2.preloader.AM2PreloaderContainer;
import java.lang.reflect.Field;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BytecodeTransformers
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        boolean is_obfuscated;
        boolean bl = is_obfuscated = !AM2PreloaderContainer.isDevEnvironment;
        if (transformedName.equals("am2.armor.ItemMageHood") && AM2PreloaderContainer.foundThaumcraft) {
            LogHelper.info("Core: Altering definition of " + transformedName + " to be thaumcraft compatible.", new Object[0]);
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            cn.interfaces.add("thaumcraft/api/IGoggles");
            cn.interfaces.add("thaumcraft/api/nodes/IRevealer");
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            bytes = cw.toByteArray();
        } else if (transformedName.equals("net.minecraft.client.renderer.EntityRenderer")) {
            LogHelper.info("Core: Altering definition of " + transformedName + ", " + (is_obfuscated ? " (obfuscated)" : "(not obfuscated)"), new Object[0]);
            bytes = this.alterEntityRenderer(bytes, is_obfuscated);
        } else if (transformedName.equals("net.minecraft.client.entity.EntityPlayerSP")) {
            LogHelper.info("Core: Altering definition of " + transformedName + ", " + (is_obfuscated ? " (obfuscated)" : "(not obfuscated)"), new Object[0]);
            bytes = this.alterEntityPlayerSP(bytes, is_obfuscated);
        } else if (transformedName.equals("net.minecraft.network.NetHandlerPlayServer")) {
            LogHelper.info("Core: Altering definition of " + transformedName + ", " + (is_obfuscated ? " (obfuscated)" : "(not obfuscated)"), new Object[0]);
            bytes = this.alterNetHandlerPlayServer(bytes, is_obfuscated);
        } else if (transformedName.equals("net.minecraft.client.renderer.entity.RendererLivingEntity")) {
            LogHelper.info("Core: Altering definition of " + transformedName + ", " + (is_obfuscated ? " (obfuscated)" : "(not obfuscated)"), new Object[0]);
            bytes = this.alterRendererLivingEntity(bytes, is_obfuscated);
        } else if (transformedName.equals("net.minecraft.world.World")) {
            LogHelper.info("Core: Altering definition of " + transformedName + ", " + (is_obfuscated ? " (obfuscated)" : "(not obfuscated)"), new Object[0]);
            bytes = this.alterWorld(bytes, is_obfuscated);
        } else if (transformedName.equals("net.minecraft.potion.PotionEffect") && !AM2PreloaderContainer.foundDragonAPI) {
            LogHelper.info("Core: Altering definition of " + transformedName + ", " + (is_obfuscated ? " (obfuscated)" : "(not obfuscated)"), new Object[0]);
            bytes = this.alterPotionEffect(bytes, is_obfuscated);
        } else if (transformedName.equals("net.minecraft.network.play.server.S1DPacketEntityEffect") && !AM2PreloaderContainer.foundDragonAPI) {
            LogHelper.info("Core: Altering definition of " + transformedName + ", " + (is_obfuscated ? " (obfuscated)" : "(not obfuscated)"), new Object[0]);
            String passedname = name.replace(".", "/");
            bytes = this.alterS1DPacketEntityEffect(bytes, is_obfuscated, passedname);
        } else if (transformedName.equals("net.minecraft.client.network.NetHandlerPlayClient") && !AM2PreloaderContainer.foundDragonAPI) {
            LogHelper.info("Core: Altering definition of " + transformedName + ", " + (is_obfuscated ? " (obfuscated)" : "(not obfuscated)"), new Object[0]);
            bytes = this.alterNetHandlerPlayClient(bytes, is_obfuscated);
        } else if (transformedName.equals("net.minecraft.network.play.server.S1EPacketRemoveEntityEffect") && !AM2PreloaderContainer.foundDragonAPI) {
            LogHelper.info("Core: Altering definition of " + transformedName + ", " + (is_obfuscated ? " (obfuscated)" : "(not obfuscated)"), new Object[0]);
            bytes = this.alterS1EPacketRemoveEntityEffect(bytes, is_obfuscated);
        }
        return bytes;
    }

    private byte[] alterRendererLivingEntity(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        obf_deobf_pair method1_name = new obf_deobf_pair();
        method1_name.setVal("doRender", false);
        method1_name.setVal("a", true);
        obf_deobf_pair method1_desc = new obf_deobf_pair();
        method1_desc.setVal("(Lnet/minecraft/entity/EntityLivingBase;DDDFF)V", false);
        method1_desc.setVal("(Lsv;DDDFF)V", true);
        obf_deobf_pair method1_searchinstruction_function = new obf_deobf_pair();
        method1_searchinstruction_function.setVal("renderLivingAt", false);
        method1_searchinstruction_function.setVal("a", true);
        obf_deobf_pair method1_searchinstruction_desc = new obf_deobf_pair();
        method1_searchinstruction_desc.setVal("(Lnet/minecraft/entity/EntityLivingBase;DDD)V", false);
        method1_searchinstruction_desc.setVal("(Lsv;DDD)V", true);
        obf_deobf_pair method1_replaceinstruction_desc = new obf_deobf_pair();
        method1_replaceinstruction_desc.setVal("(Lnet/minecraft/entity/EntityLivingBase;)V", false);
        method1_replaceinstruction_desc.setVal("(Lsv;)V", true);
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals(method1_name.getVal(is_obfuscated)) || !mn.desc.equals(method1_desc.getVal(is_obfuscated))) continue;
            AbstractInsnNode target = null;
            LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            for (AbstractInsnNode node : mn.instructions) {
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.name.equals(method1_searchinstruction_function.getVal(is_obfuscated)) || !method.desc.equals(method1_searchinstruction_desc.getVal(is_obfuscated))) continue;
                target = node;
                break;
            }
            if (target == null) continue;
            VarInsnNode aLoad = new VarInsnNode(25, 1);
            MethodInsnNode callout = new MethodInsnNode(184, "am2/utility/RenderUtilities", "setupShrinkRender", method1_replaceinstruction_desc.getVal(is_obfuscated));
            mn.instructions.insert(target, (AbstractInsnNode)aLoad);
            mn.instructions.insert((AbstractInsnNode)aLoad, (AbstractInsnNode)callout);
            LogHelper.debug("Core: Success!  Inserted opcodes!", new Object[0]);
            break;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterEntityRenderer(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        obf_deobf_pair method1_name = new obf_deobf_pair();
        method1_name.setVal("setupCameraTransform", false);
        method1_name.setVal("a", true);
        String method1_desc = "(FI)V";
        obf_deobf_pair method1_searchinstruction_function = new obf_deobf_pair();
        method1_searchinstruction_function.setVal("orientCamera", false);
        method1_searchinstruction_function.setVal("g", true);
        String method1_searchinstruction_desc = "(F)V";
        obf_deobf_pair method2_name = new obf_deobf_pair();
        method2_name.setVal("updateCameraAndRender", false);
        method2_name.setVal("b", true);
        String method2_desc = "(F)V";
        obf_deobf_pair method2_searchinstruction_class = new obf_deobf_pair();
        method2_searchinstruction_class.setVal("net/minecraft/profiler/Profiler", false);
        method2_searchinstruction_class.setVal("qi", true);
        obf_deobf_pair method2_searchinstruction_function = new obf_deobf_pair();
        method2_searchinstruction_function.setVal("startSection", false);
        method2_searchinstruction_function.setVal("a", true);
        String method2_searchinstruction_desc = "(Ljava/lang/String;)V";
        obf_deobf_pair method2_insertinstruction_desc = new obf_deobf_pair();
        method2_insertinstruction_desc.setVal("(Lnet/minecraft/client/renderer/EntityRenderer;FZ)Z", false);
        method2_insertinstruction_desc.setVal("(Lblt;FZ)Z", true);
        for (MethodNode mn : cn.methods) {
            if (mn.name.equals(method1_name.getVal(is_obfuscated)) && mn.desc.equals(method1_desc)) {
                MethodInsnNode callout;
                VarInsnNode floatset;
                AbstractInsnNode orientCameraNode = null;
                AbstractInsnNode gluPerspectiveNode = null;
                LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
                for (AbstractInsnNode node : mn.instructions) {
                    if (node instanceof MethodInsnNode) {
                        MethodInsnNode method = (MethodInsnNode)node;
                        if (orientCameraNode == null && method.name.equals(method1_searchinstruction_function.getVal(is_obfuscated)) && method.desc.equals(method1_searchinstruction_desc)) {
                            LogHelper.debug("Core: Located target method insn node: " + method.name + method.desc, new Object[0]);
                            orientCameraNode = node;
                            continue;
                        }
                        if (gluPerspectiveNode == null && method.name.equals("gluPerspective") && method.desc.equals("(FFFF)V")) {
                            LogHelper.debug("Core: Located target method insn node: " + method.name + method.desc, new Object[0]);
                            gluPerspectiveNode = node;
                            continue;
                        }
                    }
                    if (orientCameraNode == null || gluPerspectiveNode == null) continue;
                    break;
                }
                if (orientCameraNode != null) {
                    floatset = new VarInsnNode(23, 1);
                    callout = new MethodInsnNode(184, "am2/guis/AMGuiHelper", "shiftView", "(F)V");
                    mn.instructions.insert(orientCameraNode, (AbstractInsnNode)callout);
                    mn.instructions.insert(orientCameraNode, (AbstractInsnNode)floatset);
                    LogHelper.debug("Core: Success!  Inserted callout function op (shift)!", new Object[0]);
                }
                if (gluPerspectiveNode == null) continue;
                floatset = new VarInsnNode(23, 1);
                callout = new MethodInsnNode(184, "am2/guis/AMGuiHelper", "flipView", "(F)V");
                mn.instructions.insert(gluPerspectiveNode, (AbstractInsnNode)callout);
                mn.instructions.insert(gluPerspectiveNode, (AbstractInsnNode)floatset);
                LogHelper.debug("Core: Success!  Inserted callout function op (flip)!", new Object[0]);
                continue;
            }
            if (!mn.name.equals(method2_name.getVal(is_obfuscated)) || !mn.desc.equals(method2_desc)) continue;
            AbstractInsnNode target = null;
            LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            ListIterator instructions = mn.instructions.iterator();
            AbstractInsnNode node = null;
            boolean mouseFound = false;
            while (instructions.hasNext()) {
                node = (AbstractInsnNode)instructions.next();
                if (!mouseFound) {
                    if (!(node instanceof LdcInsnNode) || !((LdcInsnNode)node).cst.equals("mouse")) continue;
                    mouseFound = true;
                    continue;
                }
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.owner.equals(method2_searchinstruction_class.getVal(is_obfuscated)) || !method.name.equals(method2_searchinstruction_function.getVal(is_obfuscated)) || !method.desc.equals(method2_searchinstruction_desc)) continue;
                LogHelper.debug("Core: Located target method insn node: " + method.owner + "." + method.name + ", " + method.desc, new Object[0]);
                target = node;
                break;
            }
            if (target == null) continue;
            int iRegister = AM2PreloaderContainer.isOptiFinePresent() ? 3 : 2;
            VarInsnNode aLoad = new VarInsnNode(25, 0);
            VarInsnNode fLoad = new VarInsnNode(23, 1);
            VarInsnNode iLoad = new VarInsnNode(21, iRegister);
            MethodInsnNode callout = new MethodInsnNode(184, "am2/guis/AMGuiHelper", "overrideMouseInput", method2_insertinstruction_desc.getVal(is_obfuscated));
            VarInsnNode iStore = new VarInsnNode(54, iRegister);
            mn.instructions.insert(target, (AbstractInsnNode)iStore);
            mn.instructions.insert(target, (AbstractInsnNode)callout);
            mn.instructions.insert(target, (AbstractInsnNode)iLoad);
            mn.instructions.insert(target, (AbstractInsnNode)fLoad);
            mn.instructions.insert(target, (AbstractInsnNode)aLoad);
            LogHelper.debug("Core: Success!  Inserted opcodes!", new Object[0]);
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterEntityPlayerSP(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        obf_deobf_pair method1_name = new obf_deobf_pair();
        method1_name.setVal("onLivingUpdate", false);
        method1_name.setVal("e", true);
        String method1_desc = "()V";
        obf_deobf_pair method1_searchinstruction = new obf_deobf_pair();
        method1_searchinstruction.setVal("updatePlayerMoveState", false);
        method1_searchinstruction.setVal("a", true);
        String searchinstruction_desc = "()V";
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals(method1_name.getVal(is_obfuscated)) || !mn.desc.equals(method1_desc)) continue;
            AbstractInsnNode target = null;
            LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            ListIterator instructions = mn.instructions.iterator();
            while (instructions.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)instructions.next();
                if (!(node instanceof VarInsnNode) || ((VarInsnNode)node).getOpcode() != 25 || !((node = (AbstractInsnNode)instructions.next()) instanceof FieldInsnNode) || ((FieldInsnNode)node).getOpcode() != 180 || !((node = (AbstractInsnNode)instructions.next()) instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.name.equals(method1_searchinstruction.getVal(is_obfuscated)) || !method.desc.equals(searchinstruction_desc)) continue;
                LogHelper.debug("Core: Located target method insn node: " + method.name + method.desc, new Object[0]);
                target = node;
                break;
            }
            if (target == null) continue;
            MethodInsnNode callout = new MethodInsnNode(184, "am2/guis/AMGuiHelper", "overrideKeyboardInput", "()V");
            mn.instructions.insert(target, (AbstractInsnNode)callout);
            LogHelper.debug("Core: Success!  Inserted operations!", new Object[0]);
            break;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterWorld(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        obf_deobf_pair method1_name = new obf_deobf_pair();
        method1_name.setVal("playSoundAtEntity", false);
        method1_name.setVal("a", true);
        obf_deobf_pair method1_desc = new obf_deobf_pair();
        method1_desc.setVal("(Lnet/minecraft/entity/Entity;Ljava/lang/String;FF)V", false);
        method1_desc.setVal("(Lsa;Ljava/lang/String;FF)V", true);
        obf_deobf_pair method1_replacement_desc = new obf_deobf_pair();
        method1_replacement_desc.setVal("(Lnet/minecraft/entity/Entity;F)F", false);
        method1_replacement_desc.setVal("(Lsa;F)F", true);
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals(method1_name.getVal(is_obfuscated)) || !mn.desc.equals(method1_desc.getVal(is_obfuscated))) continue;
            AbstractInsnNode target = null;
            LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            ListIterator instructions = mn.instructions.iterator();
            while (instructions.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)instructions.next();
                if (!(node instanceof VarInsnNode) || ((VarInsnNode)node).getOpcode() != 25 || ((VarInsnNode)node).var != 5) continue;
                AbstractInsnNode potentialMatch = node;
                node = (AbstractInsnNode)instructions.next();
                if (!(node instanceof FieldInsnNode) || ((FieldInsnNode)node).getOpcode() != 180 || !((FieldInsnNode)node).name.equals("name") || !((FieldInsnNode)node).desc.equals("Ljava/lang/String;") || !((FieldInsnNode)node).owner.equals("net/minecraftforge/event/entity/PlaySoundAtEntityEvent")) continue;
                LogHelper.debug("Core: Located target method insn node: " + ((FieldInsnNode)node).name + ", " + ((FieldInsnNode)node).desc, new Object[0]);
                target = potentialMatch;
                break;
            }
            if (target == null) continue;
            VarInsnNode aload1 = new VarInsnNode(25, 1);
            VarInsnNode fload4 = new VarInsnNode(23, 4);
            MethodInsnNode callout = new MethodInsnNode(184, "am2/utility/EntityUtilities", "modifySoundPitch", method1_replacement_desc.getVal(is_obfuscated));
            VarInsnNode fstore4 = new VarInsnNode(56, 4);
            mn.instructions.insertBefore(target, (AbstractInsnNode)aload1);
            mn.instructions.insertBefore(target, (AbstractInsnNode)fload4);
            mn.instructions.insertBefore(target, (AbstractInsnNode)callout);
            mn.instructions.insertBefore(target, (AbstractInsnNode)fstore4);
            LogHelper.debug("Core: Success!  Inserted operations!", new Object[0]);
            break;
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterNetHandlerPlayServer(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        obf_deobf_pair method1_name = new obf_deobf_pair();
        method1_name.setVal("processPlayer", false);
        method1_name.setVal("a", true);
        obf_deobf_pair method1_desc = new obf_deobf_pair();
        method1_desc.setVal("(Lnet/minecraft/network/play/client/C03PacketPlayer;)V", false);
        method1_desc.setVal("(Ljd;)V", true);
        obf_deobf_pair method1_searchinstruction_class = new obf_deobf_pair();
        method1_searchinstruction_class.setVal("net/minecraft/network/play/client/C03PacketPlayer", false);
        method1_searchinstruction_class.setVal("jd", true);
        obf_deobf_pair method1_searchinstruction_function1 = new obf_deobf_pair();
        method1_searchinstruction_function1.setVal("func_149471_f", false);
        method1_searchinstruction_function1.setVal("f", true);
        obf_deobf_pair method1_searchinstruction_function2 = new obf_deobf_pair();
        method1_searchinstruction_function2.setVal("func_149467_d", false);
        method1_searchinstruction_function2.setVal("d", true);
        String method1_searchinstructions_desc = "()D";
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals(method1_name.getVal(is_obfuscated)) || !mn.desc.equals(method1_desc.getVal(is_obfuscated))) continue;
            AbstractInsnNode target = null;
            LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            ListIterator instructions = mn.instructions.iterator();
            while (instructions.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)instructions.next();
                if (!(node instanceof VarInsnNode) || ((VarInsnNode)node).var != 1 || ((VarInsnNode)node).getOpcode() != 25 || !((node = (AbstractInsnNode)instructions.next()) instanceof MethodInsnNode) || !this.matchMethodNode((MethodInsnNode)node, 182, method1_searchinstruction_class.getVal(is_obfuscated), method1_searchinstruction_function1.getVal(is_obfuscated), method1_searchinstructions_desc) || !((node = (AbstractInsnNode)instructions.next()) instanceof VarInsnNode) || ((VarInsnNode)node).var != 1 || ((VarInsnNode)node).getOpcode() != 25 || !((node = (AbstractInsnNode)instructions.next()) instanceof MethodInsnNode) || !this.matchMethodNode((MethodInsnNode)node, 182, method1_searchinstruction_class.getVal(is_obfuscated), method1_searchinstruction_function2.getVal(is_obfuscated), method1_searchinstructions_desc) || !((node = (AbstractInsnNode)instructions.next()) instanceof InsnNode) || ((InsnNode)node).getOpcode() != 103 || !((node = (AbstractInsnNode)instructions.next()) instanceof VarInsnNode) || ((VarInsnNode)node).var != 13 || ((VarInsnNode)node).getOpcode() != 57) continue;
                target = node;
                break;
            }
            if (target == null) continue;
            LdcInsnNode ldc = new LdcInsnNode((Object)1.5);
            VarInsnNode dstore13 = new VarInsnNode(57, 13);
            mn.instructions.insert(target, (AbstractInsnNode)ldc);
            mn.instructions.insert((AbstractInsnNode)ldc, (AbstractInsnNode)dstore13);
            LogHelper.debug("Core: Success!  Inserted opcodes!", new Object[0]);
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterPotionEffect(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        obf_deobf_pair method1_name = new obf_deobf_pair();
        method1_name.setVal("writeCustomPotionEffectToNBT", false);
        method1_name.setVal("a", true);
        obf_deobf_pair method1_desc = new obf_deobf_pair();
        method1_desc.setVal("(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;", false);
        method1_desc.setVal("(Ldh;)Ldh;", true);
        obf_deobf_pair method1_searchinstruction_class = new obf_deobf_pair();
        method1_searchinstruction_class.setVal("net/minecraft/nbt/NBTTagCompound", false);
        method1_searchinstruction_class.setVal("dh", true);
        obf_deobf_pair method1_searchinstruction_function = new obf_deobf_pair();
        method1_searchinstruction_function.setVal("setByte", false);
        method1_searchinstruction_function.setVal("a", true);
        obf_deobf_pair method1_searchinstruction_desc = new obf_deobf_pair();
        method1_searchinstruction_desc.setVal("(Ljava/lang/String;B)V", false);
        method1_searchinstruction_desc.setVal("(Ljava/lang/String;B)V", true);
        obf_deobf_pair method1_replaceinstruction_function = new obf_deobf_pair();
        method1_replaceinstruction_function.setVal("setInteger", false);
        method1_replaceinstruction_function.setVal("a", true);
        obf_deobf_pair method1_replaceinstruction_desc = new obf_deobf_pair();
        method1_replaceinstruction_desc.setVal("(Ljava/lang/String;I)V", false);
        method1_replaceinstruction_desc.setVal("(Ljava/lang/String;I)V", true);
        obf_deobf_pair method2_name = new obf_deobf_pair();
        method2_name.setVal("readCustomPotionEffectFromNBT", false);
        method2_name.setVal("b", true);
        obf_deobf_pair method2_desc = new obf_deobf_pair();
        method2_desc.setVal("(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/potion/PotionEffect;", false);
        method2_desc.setVal("(Ldh;)Lrw;", true);
        obf_deobf_pair method2_searchinstruction_class = new obf_deobf_pair();
        method2_searchinstruction_class.setVal("net/minecraft/nbt/NBTTagCompound", false);
        method2_searchinstruction_class.setVal("dh", true);
        obf_deobf_pair method2_searchinstruction_function = new obf_deobf_pair();
        method2_searchinstruction_function.setVal("getByte", false);
        method2_searchinstruction_function.setVal("d", true);
        obf_deobf_pair method2_searchinstruction_desc = new obf_deobf_pair();
        method2_searchinstruction_desc.setVal("(Ljava/lang/String;)B", false);
        method2_searchinstruction_desc.setVal("(Ljava/lang/String;)B", true);
        obf_deobf_pair method2_replaceinstruction_function = new obf_deobf_pair();
        method2_replaceinstruction_function.setVal("getInteger", false);
        method2_replaceinstruction_function.setVal("f", true);
        obf_deobf_pair method2_replaceinstruction_desc = new obf_deobf_pair();
        method2_replaceinstruction_desc.setVal("(Ljava/lang/String;)I", false);
        method2_replaceinstruction_desc.setVal("(Ljava/lang/String;)I", true);
        for (MethodNode mn : cn.methods) {
            MethodInsnNode target;
            if (mn.name.equals(method1_name.getVal(is_obfuscated)) && mn.desc.equals(method1_desc.getVal(is_obfuscated))) {
                target = null;
                AbstractInsnNode toRemove = null;
                LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
                for (AbstractInsnNode node : mn.instructions) {
                    if (!(node instanceof MethodInsnNode)) continue;
                    MethodInsnNode method = (MethodInsnNode)node;
                    if (!method.owner.equals(method1_searchinstruction_class.getVal(is_obfuscated)) || !method.name.equals(method1_searchinstruction_function.getVal(is_obfuscated)) || !method.desc.equals(method1_searchinstruction_desc.getVal(is_obfuscated))) continue;
                    target = method;
                    toRemove = method.getPrevious();
                    break;
                }
                if (target == null) continue;
                MethodInsnNode newset = new MethodInsnNode(182, method1_searchinstruction_class.getVal(is_obfuscated), method1_replaceinstruction_function.getVal(is_obfuscated), method1_replaceinstruction_desc.getVal(is_obfuscated));
                InsnNode new_nop = new InsnNode(0);
                mn.instructions.set(toRemove, (AbstractInsnNode)new_nop);
                mn.instructions.set(target, (AbstractInsnNode)newset);
                LogHelper.debug("Core: Success!  Replaced opcodes!", new Object[0]);
                continue;
            }
            if (!mn.name.equals(method2_name.getVal(is_obfuscated)) || !mn.desc.equals(method2_desc.getVal(is_obfuscated))) continue;
            target = null;
            LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            for (AbstractInsnNode node : mn.instructions) {
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.owner.equals(method2_searchinstruction_class.getVal(is_obfuscated)) || !method.name.equals(method2_searchinstruction_function.getVal(is_obfuscated)) || !method.desc.equals(method2_searchinstruction_desc.getVal(is_obfuscated))) continue;
                target = method;
                break;
            }
            if (target == null) continue;
            MethodInsnNode newset = new MethodInsnNode(182, method2_searchinstruction_class.getVal(is_obfuscated), method2_replaceinstruction_function.getVal(is_obfuscated), method2_replaceinstruction_desc.getVal(is_obfuscated));
            mn.instructions.set(target, (AbstractInsnNode)newset);
            LogHelper.debug("Core: Success!  Replaced opcodes!", new Object[0]);
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterS1DPacketEntityEffect(byte[] bytes, boolean is_obfuscated, String classname) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        obf_deobf_pair potionid_bytevar_name = new obf_deobf_pair();
        potionid_bytevar_name.setVal("field_149432_b", false);
        potionid_bytevar_name.setVal("b", true);
        String potionid_bytevar_origdesc = "B";
        String initmethod_name = "<init>";
        obf_deobf_pair initmethod_desc = new obf_deobf_pair();
        initmethod_desc.setVal("(ILnet/minecraft/potion/PotionEffect;)V", false);
        initmethod_desc.setVal("(ILrw;)V", true);
        obf_deobf_pair initmethod_searchinstruction_owner = new obf_deobf_pair();
        initmethod_searchinstruction_owner.setVal("net/minecraft/potion/PotionEffect", false);
        initmethod_searchinstruction_owner.setVal("rw", true);
        obf_deobf_pair initmethod_searchinstruction_function = new obf_deobf_pair();
        initmethod_searchinstruction_function.setVal("getPotionID", false);
        initmethod_searchinstruction_function.setVal("a", true);
        String initmethod_searchinstruction_desc = "()I";
        obf_deobf_pair method1_name = new obf_deobf_pair();
        method1_name.setVal("readPacketData", false);
        method1_name.setVal("a", true);
        obf_deobf_pair method1_desc = new obf_deobf_pair();
        method1_desc.setVal("(Lnet/minecraft/network/PacketBuffer;)V", false);
        method1_desc.setVal("(Let;)V", true);
        obf_deobf_pair method1_searchinstruction_owner = new obf_deobf_pair();
        method1_searchinstruction_owner.setVal("net/minecraft/network/PacketBuffer", false);
        method1_searchinstruction_owner.setVal("et", true);
        String method1_searchinstruction_function = "readByte";
        String method1_searchinstruction_desc = "()B";
        String method1_replaceinstruction_function = "readInt";
        String method1_replaceinstruction_desc = "()I";
        obf_deobf_pair method2_name = new obf_deobf_pair();
        method2_name.setVal("writePacketData", false);
        method2_name.setVal("b", true);
        obf_deobf_pair method2_desc = new obf_deobf_pair();
        method2_desc.setVal("(Lnet/minecraft/network/PacketBuffer;)V", false);
        method2_desc.setVal("(Let;)V", true);
        obf_deobf_pair method2_searchinstruction_owner = new obf_deobf_pair();
        method2_searchinstruction_owner.setVal("net/minecraft/network/PacketBuffer", false);
        method2_searchinstruction_owner.setVal("et", true);
        String method2_searchinstruction_function = "writeByte";
        String method2_searchinstruction_desc = "(I)Lio/netty/buffer/ByteBuf;";
        String method2_replaceinstruction_function = "writeInt";
        String method2_replaceinstruction_desc = "(I)Lio/netty/buffer/ByteBuf;";
        obf_deobf_pair method3_name = new obf_deobf_pair();
        method3_name.setVal("func_149427_e", false);
        method3_name.setVal("e", true);
        String method3_newdesc = "()I";
        String potionID_intvar_name = "potionID_intvalue";
        String potionID_intvar_desc = "I";
        int potionID_intvar_access = 2;
        FieldNode potionID_intvar = new FieldNode(potionID_intvar_access, potionID_intvar_name, potionID_intvar_desc, null, null);
        cn.fields.add(potionID_intvar);
        for (MethodNode mn : cn.methods) {
            AbstractInsnNode node;
            ListIterator instructions;
            AbstractInsnNode target2;
            AbstractInsnNode target;
            if (mn.name.equals(initmethod_name) && mn.desc.equals(initmethod_desc.getVal(is_obfuscated))) {
                AbstractInsnNode toRemove1 = null;
                AbstractInsnNode toRemove2 = null;
                AbstractInsnNode toRemove3 = null;
                AbstractInsnNode toReplace = null;
                LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
                ListIterator instructions2 = mn.instructions.iterator();
                while (instructions2.hasNext()) {
                    AbstractInsnNode node2 = (AbstractInsnNode)instructions2.next();
                    if (!(node2 instanceof MethodInsnNode)) continue;
                    MethodInsnNode method = (MethodInsnNode)node2;
                    if (!method.owner.equals(initmethod_searchinstruction_owner.getVal(is_obfuscated)) || !method.name.equals(initmethod_searchinstruction_function.getVal(is_obfuscated)) || !method.desc.equals(initmethod_searchinstruction_desc) || !((node2 = (AbstractInsnNode)instructions2.next()) instanceof IntInsnNode) || ((IntInsnNode)node2).getOpcode() != 17) continue;
                    toRemove1 = node2;
                    node2 = (AbstractInsnNode)instructions2.next();
                    if (!(node2 instanceof InsnNode) || ((InsnNode)node2).getOpcode() != 126) continue;
                    toRemove2 = node2;
                    node2 = (AbstractInsnNode)instructions2.next();
                    if (!(node2 instanceof InsnNode) || ((InsnNode)node2).getOpcode() != 145) continue;
                    toRemove3 = node2;
                    node2 = (AbstractInsnNode)instructions2.next();
                    if (!(node2 instanceof FieldInsnNode) || ((FieldInsnNode)node2).getOpcode() != 181 || !((FieldInsnNode)node2).name.equals(potionid_bytevar_name.getVal(is_obfuscated)) || !((FieldInsnNode)node2).desc.equals(potionid_bytevar_origdesc)) continue;
                    toReplace = node2;
                    break;
                }
                if (toRemove1 == null || toRemove2 == null || toRemove3 == null || toReplace == null) continue;
                InsnNode new_nop = new InsnNode(0);
                FieldInsnNode new_potion_id_variable = new FieldInsnNode(181, classname, potionID_intvar_name, potionID_intvar_desc);
                mn.instructions.set(toRemove1, (AbstractInsnNode)new_nop);
                mn.instructions.set(toRemove2, (AbstractInsnNode)new_nop);
                mn.instructions.set(toRemove3, (AbstractInsnNode)new_nop);
                mn.instructions.set(toReplace, (AbstractInsnNode)new_potion_id_variable);
                LogHelper.debug("Core: Success! Replaced opcodes!" + mn.name + mn.desc, new Object[0]);
                continue;
            }
            if (mn.name.equals(method1_name.getVal(is_obfuscated)) && mn.desc.equals(method1_desc.getVal(is_obfuscated))) {
                target = null;
                target2 = null;
                LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
                instructions = mn.instructions.iterator();
                while (instructions.hasNext()) {
                    node = (AbstractInsnNode)instructions.next();
                    if (!(node instanceof MethodInsnNode)) continue;
                    MethodInsnNode method = (MethodInsnNode)node;
                    if (!method.owner.equals(method1_searchinstruction_owner.getVal(is_obfuscated)) || !method.name.equals(method1_searchinstruction_function) || !method.desc.equals(method1_searchinstruction_desc)) continue;
                    target = node;
                    node = (AbstractInsnNode)instructions.next();
                    if (!(node instanceof FieldInsnNode) || ((FieldInsnNode)node).getOpcode() != 181 || !((FieldInsnNode)node).name.equals(potionid_bytevar_name.getVal(is_obfuscated)) || !((FieldInsnNode)node).desc.equals(potionid_bytevar_origdesc)) continue;
                    target2 = node;
                    break;
                }
                if (target == null || target2 == null) continue;
                MethodInsnNode new_readint = new MethodInsnNode(182, method1_searchinstruction_owner.getVal(is_obfuscated), method1_replaceinstruction_function, method1_replaceinstruction_desc);
                FieldInsnNode new_potion_id_variable = new FieldInsnNode(181, classname, potionID_intvar_name, potionID_intvar_desc);
                mn.instructions.set(target, (AbstractInsnNode)new_readint);
                mn.instructions.set(target2, (AbstractInsnNode)new_potion_id_variable);
                LogHelper.debug("Core: Success!  Replaced opcodes!", new Object[0]);
                continue;
            }
            if (!mn.name.equals(method2_name.getVal(is_obfuscated)) || !mn.desc.equals(method2_desc.getVal(is_obfuscated))) continue;
            target = null;
            target2 = null;
            LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            instructions = mn.instructions.iterator();
            while (instructions.hasNext()) {
                node = (AbstractInsnNode)instructions.next();
                if (!(node instanceof FieldInsnNode) || ((FieldInsnNode)node).getOpcode() != 180 || !((FieldInsnNode)node).name.equals(potionid_bytevar_name.getVal(is_obfuscated)) || !((FieldInsnNode)node).desc.equals(potionid_bytevar_origdesc)) continue;
                target = node;
                node = (AbstractInsnNode)instructions.next();
                if (!(node instanceof MethodInsnNode) || !((MethodInsnNode)node).owner.equals(method2_searchinstruction_owner.getVal(is_obfuscated)) || !((MethodInsnNode)node).name.equals(method2_searchinstruction_function) || !((MethodInsnNode)node).desc.equals(method2_searchinstruction_desc)) continue;
                target2 = node;
                break;
            }
            if (target == null || target2 == null) continue;
            FieldInsnNode new_potion_id_variable = new FieldInsnNode(180, classname, potionID_intvar_name, potionID_intvar_desc);
            MethodInsnNode new_writeint = new MethodInsnNode(182, method2_searchinstruction_owner.getVal(is_obfuscated), method2_replaceinstruction_function, method2_replaceinstruction_desc);
            mn.instructions.set(target, (AbstractInsnNode)new_potion_id_variable);
            mn.instructions.set(target2, (AbstractInsnNode)new_writeint);
            LogHelper.debug("Core: Success!  Replaced opcodes!", new Object[0]);
        }
        LogHelper.debug("Core: Creating new getPotionID method", new Object[0]);
        MethodNode newGetPotionIDMethod = new MethodNode(1, "getPotionID", method3_newdesc, null, null);
        newGetPotionIDMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newGetPotionIDMethod.instructions.add((AbstractInsnNode)new FieldInsnNode(180, classname, potionID_intvar_name, potionID_intvar_desc));
        newGetPotionIDMethod.instructions.add((AbstractInsnNode)new InsnNode(172));
        cn.methods.add(newGetPotionIDMethod);
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterNetHandlerPlayClient(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        obf_deobf_pair method1_name = new obf_deobf_pair();
        method1_name.setVal("handleEntityEffect", false);
        method1_name.setVal("a", true);
        obf_deobf_pair method1_desc = new obf_deobf_pair();
        method1_desc.setVal("(Lnet/minecraft/network/play/server/S1DPacketEntityEffect;)V", false);
        method1_desc.setVal("(Lin;)V", true);
        obf_deobf_pair method1_searchinstruction_class = new obf_deobf_pair();
        method1_searchinstruction_class.setVal("net/minecraft/network/play/server/S1DPacketEntityEffect", false);
        method1_searchinstruction_class.setVal("in", true);
        obf_deobf_pair method1_searchinstruction_function = new obf_deobf_pair();
        method1_searchinstruction_function.setVal("func_149427_e", false);
        method1_searchinstruction_function.setVal("e", true);
        String method1_searchinstruction_desc = "()B";
        String method1_replaceinstruction_function = "getPotionID";
        String method1_replaceinstruction_desc = "()I";
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals(method1_name.getVal(is_obfuscated)) || !mn.desc.equals(method1_desc.getVal(is_obfuscated))) continue;
            MethodInsnNode target = null;
            LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            for (AbstractInsnNode node : mn.instructions) {
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode method = (MethodInsnNode)node;
                if (!method.owner.equals(method1_searchinstruction_class.getVal(is_obfuscated)) || !method.name.equals(method1_searchinstruction_function.getVal(is_obfuscated)) || !method.desc.equals(method1_searchinstruction_desc)) continue;
                target = method;
                break;
            }
            if (target == null) continue;
            MethodInsnNode newset = new MethodInsnNode(182, method1_searchinstruction_class.getVal(is_obfuscated), method1_replaceinstruction_function, method1_replaceinstruction_desc);
            mn.instructions.set(target, (AbstractInsnNode)newset);
            LogHelper.debug("Core: Success!  Replaced opcode!", new Object[0]);
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] alterS1EPacketRemoveEntityEffect(byte[] bytes, boolean is_obfuscated) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        obf_deobf_pair method1_name = new obf_deobf_pair();
        method1_name.setVal("readPacketData", false);
        method1_name.setVal("a", true);
        obf_deobf_pair method1_desc = new obf_deobf_pair();
        method1_desc.setVal("(Lnet/minecraft/network/PacketBuffer;)V", false);
        method1_desc.setVal("(Let;)V", true);
        obf_deobf_pair method1_searchinstruction_owner = new obf_deobf_pair();
        method1_searchinstruction_owner.setVal("net/minecraft/network/PacketBuffer", false);
        method1_searchinstruction_owner.setVal("et", true);
        String method1_searchinstruction_function = "readUnsignedByte";
        String method1_searchinstruction_desc = "()S";
        String method1_replaceinstruction_function = "readInt";
        String method1_replaceinstruction_desc = "()I";
        obf_deobf_pair method2_name = new obf_deobf_pair();
        method2_name.setVal("writePacketData", false);
        method2_name.setVal("b", true);
        obf_deobf_pair method2_desc = new obf_deobf_pair();
        method2_desc.setVal("(Lnet/minecraft/network/PacketBuffer;)V", false);
        method2_desc.setVal("(Let;)V", true);
        obf_deobf_pair method2_searchinstruction_owner = new obf_deobf_pair();
        method2_searchinstruction_owner.setVal("net/minecraft/network/PacketBuffer", false);
        method2_searchinstruction_owner.setVal("et", true);
        String method2_searchinstruction_function = "writeByte";
        String method2_searchinstruction_desc = "(I)Lio/netty/buffer/ByteBuf;";
        String method2_replaceinstruction_function = "writeInt";
        String method2_replaceinstruction_desc = "(I)Lio/netty/buffer/ByteBuf;";
        for (MethodNode mn : cn.methods) {
            AbstractInsnNode target;
            if (mn.name.equals(method1_name.getVal(is_obfuscated)) && mn.desc.equals(method1_desc.getVal(is_obfuscated))) {
                target = null;
                LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
                for (AbstractInsnNode node : mn.instructions) {
                    if (!(node instanceof MethodInsnNode)) continue;
                    MethodInsnNode method = (MethodInsnNode)node;
                    if (!method.owner.equals(method1_searchinstruction_owner.getVal(is_obfuscated)) || !method.name.equals(method1_searchinstruction_function) || !method.desc.equals(method1_searchinstruction_desc)) continue;
                    target = node;
                    break;
                }
                if (target == null) continue;
                MethodInsnNode new_readint = new MethodInsnNode(182, method1_searchinstruction_owner.getVal(is_obfuscated), method1_replaceinstruction_function, method1_replaceinstruction_desc);
                mn.instructions.set(target, (AbstractInsnNode)new_readint);
                LogHelper.debug("Core: Success!  Replaced opcodes!", new Object[0]);
                continue;
            }
            if (!mn.name.equals(method2_name.getVal(is_obfuscated)) || !mn.desc.equals(method2_desc.getVal(is_obfuscated))) continue;
            target = null;
            LogHelper.debug("Core: Located target method " + mn.name + mn.desc, new Object[0]);
            for (AbstractInsnNode node : mn.instructions) {
                if (!(node instanceof MethodInsnNode) || !((MethodInsnNode)node).owner.equals(method2_searchinstruction_owner.getVal(is_obfuscated)) || !((MethodInsnNode)node).name.equals(method2_searchinstruction_function) || !((MethodInsnNode)node).desc.equals(method2_searchinstruction_desc)) continue;
                target = node;
                break;
            }
            if (target == null) continue;
            MethodInsnNode new_writeint = new MethodInsnNode(182, method2_searchinstruction_owner.getVal(is_obfuscated), method2_replaceinstruction_function, method2_replaceinstruction_desc);
            mn.instructions.set(target, (AbstractInsnNode)new_writeint);
            LogHelper.debug("Core: Success!  Replaced opcodes!", new Object[0]);
        }
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private boolean matchFieldNode(FieldInsnNode node, int opcode, String owner, String name, String desc) {
        return node.getOpcode() == opcode && node.owner.equals(owner) && node.name.equals(name) && node.desc.equals(desc);
    }

    private boolean matchMethodNode(MethodInsnNode node, int opcode, String owner, String name, String desc) {
        return node.getOpcode() == opcode && node.owner.equals(owner) && node.name.equals(name) && node.desc.equals(desc);
    }

    private void debugPrintInsns(MethodNode mn) {
        ListIterator it = mn.instructions.iterator();
        LogHelper.debug("Core: Beginning dump of Insns for %s %s", mn.name, mn.desc);
        LogHelper.debug("================================================================================", new Object[0]);
        LogHelper.log(Level.INFO, "", new Object[0]);
        while (it.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            String className = node.toString().split("@")[0];
            className = className.substring(className.lastIndexOf(".") + 1);
            if (node instanceof VarInsnNode) {
                LogHelper.log(Level.INFO, this.opcodeToString(node.getOpcode()) + " " + ((VarInsnNode)node).var, new Object[0]);
                continue;
            }
            if (node instanceof FieldInsnNode) {
                LogHelper.log(Level.INFO, this.opcodeToString(node.getOpcode()) + " " + ((FieldInsnNode)node).owner + "/" + ((FieldInsnNode)node).name + " (" + ((FieldInsnNode)node).desc + ")", new Object[0]);
                continue;
            }
            if (node instanceof MethodInsnNode) {
                LogHelper.log(Level.INFO, this.opcodeToString(node.getOpcode()) + " " + ((MethodInsnNode)node).owner + "/" + ((MethodInsnNode)node).name + " " + ((MethodInsnNode)node).desc, new Object[0]);
                continue;
            }
            LogHelper.log(Level.INFO, className + " >> " + this.opcodeToString(node.getOpcode()), new Object[0]);
        }
        LogHelper.debug("================================================================================", new Object[0]);
        LogHelper.debug("Core: End", new Object[0]);
    }

    private String opcodeToString(int opcode) {
        Field[] fields;
        for (Field f : fields = Opcodes.class.getFields()) {
            if (f.getType() != Integer.class && f.getType() != Integer.TYPE) continue;
            try {
                if (f.getInt(null) != opcode) continue;
                return f.getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "OPCODE_UNKNOWN";
    }

    public class obf_deobf_pair {
        private String deobf_val = "";
        private String obf_val = "";

        public void setVal(String value, boolean is_obfuscated) {
            if (is_obfuscated) {
                this.obf_val = value;
            } else {
                this.deobf_val = value;
            }
        }

        public String getVal(boolean is_obfuscated) {
            if (is_obfuscated) {
                return this.obf_val;
            }
            return this.deobf_val;
        }
    }
}

