/*
 * Decompiled with CFR 0.152.
 */
package am2.spell;

import am2.AMCore;
import am2.LogHelper;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Items;
import net.minecraft.util.IIcon;

@SideOnly(value=Side.CLIENT)
public class SpellTextureHelper {
    public static final SpellTextureHelper instance = new SpellTextureHelper();
    private IIcon[] icons;
    private static final String iconsPath = "/assets/arsmagica2/textures/items/spells/icons/";
    private static final String iconsPrefix = "/spells/icons/";

    private SpellTextureHelper() {
    }

    public void loadAllIcons(IIconRegister register) {
        try {
            List<String> resources = SpellTextureHelper.getResourceListing();
            if (resources.size() == 0) {
                LogHelper.error("No spell IIcons found?!?", new Object[0]);
            } else {
                LogHelper.info("Located %d spell IIcons", resources.size());
            }
            this.icons = new IIcon[resources.size()];
            int count = 0;
            for (String s : resources) {
                this.icons[count++] = ResourceManager.RegisterTexture(s, register);
            }
        }
        catch (Throwable e) {
            if (this.icons == null) {
                this.icons = new IIcon[0];
            }
            e.printStackTrace();
        }
    }

    public static List<String> getResourceListing() throws IOException, URISyntaxException {
        CodeSource src = AMCore.class.getProtectionDomain().getCodeSource();
        ArrayList<String> toReturn = new ArrayList<String>();
        if (src != null) {
            String path;
            File file;
            URL jar = src.getLocation();
            if (jar.getProtocol() == "jar") {
                String path2 = jar.toString().replace("jar:", "").replace("file:", "").replace("!/am2/AMCore.class", "").replace('/', File.separatorChar);
                path2 = URLDecoder.decode(path2, "UTF-8");
                LogHelper.debug(path2, new Object[0]);
                JarFile jarFile = new JarFile(path2);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String name;
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith("assets/arsmagica2/textures/items/spells/icons/") || (name = entry.getName().replace("assets/arsmagica2/textures/items/spells/icons/", "")).equals("")) continue;
                    toReturn.add("spells/icons/" + name.replace(".png", ""));
                }
                jarFile.close();
            } else if (jar.getProtocol() == "file" && (file = new File(path = jar.toURI().toString().replace("/am2/AMCore.class", iconsPath).replace("file:/", "").replace("%20", " ").replace("/", "\\"))).exists() && file.isDirectory()) {
                for (File sub : file.listFiles()) {
                    toReturn.add(iconsPrefix + sub.getName().replace(".png", ""));
                }
            }
            return toReturn;
        }
        return toReturn;
    }

    public IIcon getIcon(int index) {
        if (this.icons.length == 0) {
            return Items.field_151048_u.func_77617_a(0);
        }
        if (index < 0 || index >= this.icons.length) {
            index = 0;
        }
        return this.icons[index];
    }

    public IIcon[] getAllIcons() {
        return this.icons;
    }
}

