/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemSpellBook;
import am2.particles.AMParticle;
import am2.particles.ParticleOrbitPoint;
import am2.spell.SpellUtils;
import am2.utility.DummyEntityPlayer;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;

public class Appropriation
implements ISpellComponent {
    private static final String storageKey = "stored_data";
    private static final String storageType = "storage_type";

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = Items.field_151079_bi;
        objectArray[1] = new ItemStack((Block)BlocksCommonProxy.AMOres, 1, 9);
        objectArray[2] = Blocks.field_150486_ae;
        return objectArray;
    }

    @Override
    public int getID() {
        return 71;
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        ItemStack originalSpellStack = this.getOriginalSpellStack((EntityPlayer)caster);
        if (originalSpellStack == null) {
            return false;
        }
        if (originalSpellStack.field_77990_d == null) {
            return false;
        }
        Block block = world.func_147439_a(blockx, blocky, blockz);
        if (block == null) {
            return false;
        }
        for (String s : AMCore.config.getAppropriationBlockBlacklist()) {
            if (block.func_149739_a() != s) continue;
            return false;
        }
        if (!world.field_72995_K) {
            if (originalSpellStack.field_77990_d.func_74764_b(storageKey)) {
                if (world.func_147439_a(blockx, blocky, blockz) == Blocks.field_150350_a) {
                    blockFace = -1;
                }
                if (blockFace != -1) {
                    switch (blockFace) {
                        case 0: {
                            --blocky;
                            break;
                        }
                        case 1: {
                            ++blocky;
                            break;
                        }
                        case 2: {
                            --blockz;
                            break;
                        }
                        case 3: {
                            ++blockz;
                            break;
                        }
                        case 4: {
                            --blockx;
                            break;
                        }
                        case 5: {
                            ++blockx;
                        }
                    }
                }
                if (world.func_147437_c(blockx, blocky, blockz) || !world.func_147439_a(blockx, blocky, blockz).func_149688_o().func_76220_a()) {
                    NBTTagCompound nbt = null;
                    if (stack.func_77978_p() != null) {
                        nbt = (NBTTagCompound)stack.func_77978_p().func_74737_b();
                    }
                    EntityPlayerMP casterPlayer = (EntityPlayerMP)DummyEntityPlayer.fromEntityLiving(caster);
                    world.captureBlockSnapshots = true;
                    this.restore((EntityPlayer)caster, world, originalSpellStack, blockx, blocky, blockz, impactX, impactY, impactZ);
                    world.captureBlockSnapshots = false;
                    NBTTagCompound newNBT = null;
                    if (stack.func_77978_p() != null) {
                        newNBT = (NBTTagCompound)stack.func_77978_p().func_74737_b();
                    }
                    BlockEvent.MultiPlaceEvent placeEvent = null;
                    List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
                    world.capturedBlockSnapshots.clear();
                    if (nbt != null) {
                        stack.func_77982_d(nbt);
                    }
                    if (blockSnapshots.size() > 1) {
                        placeEvent = ForgeEventFactory.onPlayerMultiBlockPlace((EntityPlayer)casterPlayer, (List)blockSnapshots, (ForgeDirection)ForgeDirection.UNKNOWN);
                    } else if (blockSnapshots.size() == 1) {
                        placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)casterPlayer, (BlockSnapshot)((BlockSnapshot)blockSnapshots.get(0)), (ForgeDirection)ForgeDirection.UNKNOWN);
                    }
                    if (placeEvent != null && placeEvent.isCanceled()) {
                        for (BlockSnapshot blocksnapshot : blockSnapshots) {
                            world.restoringBlockSnapshots = true;
                            blocksnapshot.restore(true, false);
                            world.restoringBlockSnapshots = false;
                        }
                        return false;
                    }
                    if (nbt != null) {
                        stack.func_77982_d(newNBT);
                    }
                    for (BlockSnapshot blocksnapshot : blockSnapshots) {
                        int blockX = blocksnapshot.x;
                        int blockY = blocksnapshot.y;
                        int blockZ = blocksnapshot.z;
                        int metadata = world.func_72805_g(blockX, blockY, blockZ);
                        int updateFlag = blocksnapshot.flag;
                        Block oldBlock = blocksnapshot.replacedBlock;
                        Block newBlock = world.func_147439_a(blockX, blockY, blockZ);
                        if (newBlock != null && !newBlock.hasTileEntity(metadata)) {
                            newBlock.func_149726_b(world, blockX, blockY, blockZ);
                        }
                        world.markAndNotifyBlock(blockX, blockY, blockZ, null, oldBlock, newBlock, updateFlag);
                    }
                    world.capturedBlockSnapshots.clear();
                }
            } else {
                if (block == null || block.func_149712_f(world, blockx, blocky, blockz) == -1.0f) {
                    return false;
                }
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a(storageType, "block");
                data.func_74768_a("blockID", Block.func_149682_b((Block)block));
                int meta = world.func_72805_g(blockx, blocky, blockz);
                data.func_74768_a("meta", meta);
                EntityPlayerMP casterPlayer = (EntityPlayerMP)DummyEntityPlayer.fromEntityLiving(caster);
                if (!ForgeEventFactory.doPlayerHarvestCheck((EntityPlayer)casterPlayer, (Block)block, (boolean)true)) {
                    return false;
                }
                BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)casterPlayer.field_71134_c.func_73081_b(), (EntityPlayerMP)casterPlayer, (int)blockx, (int)blocky, (int)blockz);
                if (event.isCanceled()) {
                    return false;
                }
                TileEntity te = world.func_147438_o(blockx, blocky, blockz);
                if (te != null) {
                    NBTTagCompound teData = new NBTTagCompound();
                    te.func_145841_b(teData);
                    data.func_74782_a("tileEntity", (NBTBase)teData);
                    try {
                        world.func_147475_p(blockx, blocky, blockz);
                    }
                    catch (Throwable exception) {
                        exception.printStackTrace();
                    }
                }
                originalSpellStack.field_77990_d.func_74782_a(storageKey, (NBTBase)data);
                this.setOriginalSpellStackData((EntityPlayer)caster, originalSpellStack);
                world.func_147468_f(blockx, blocky, blockz);
            }
        }
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityPlayer || target instanceof IBossDisplayData) {
            return false;
        }
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        for (Class clazz : AMCore.config.getAppropriationMobBlacklist()) {
            if (target.getClass() != clazz) continue;
            return false;
        }
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        ItemStack originalSpellStack = this.getOriginalSpellStack((EntityPlayer)caster);
        if (originalSpellStack == null) {
            return false;
        }
        if (!world.field_72995_K) {
            if (originalSpellStack.field_77990_d.func_74764_b(storageKey)) {
                this.restore((EntityPlayer)caster, world, originalSpellStack, (int)target.field_70165_t, (int)target.field_70163_u, (int)target.field_70161_v, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v);
            } else {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("class", target.getClass().getName());
                data.func_74778_a(storageType, "ent");
                NBTTagCompound targetData = new NBTTagCompound();
                target.func_70109_d(targetData);
                data.func_74782_a("targetNBT", (NBTBase)targetData);
                originalSpellStack.field_77990_d.func_74782_a(storageKey, (NBTBase)data);
                this.setOriginalSpellStackData((EntityPlayer)caster, originalSpellStack);
                target.func_70106_y();
            }
        }
        return true;
    }

    private void setOriginalSpellStackData(EntityPlayer caster, ItemStack modifiedStack) {
        ItemStack originalSpellStack = caster.func_71045_bC();
        if (originalSpellStack == null) {
            return;
        }
        if (originalSpellStack.func_77973_b() instanceof ItemSpellBook) {
            ((ItemSpellBook)originalSpellStack.func_77973_b()).replaceAciveItemStack(originalSpellStack, modifiedStack);
        } else {
            caster.field_71071_by.func_70299_a(caster.field_71071_by.field_70461_c, modifiedStack);
        }
    }

    private ItemStack getOriginalSpellStack(EntityPlayer caster) {
        ItemStack originalSpellStack = caster.func_71045_bC();
        if (originalSpellStack == null) {
            return null;
        }
        if (originalSpellStack.func_77973_b() instanceof ItemSpellBook) {
            originalSpellStack = ((ItemSpellBook)originalSpellStack.func_77973_b()).GetActiveItemStack(originalSpellStack);
            boolean hasAppropriation = false;
            for (int i = 0; i < SpellUtils.instance.numStages(originalSpellStack); ++i) {
                if (!SpellUtils.instance.componentIsPresent(originalSpellStack, Appropriation.class, i)) continue;
                hasAppropriation = true;
                break;
            }
            if (!hasAppropriation) {
                return null;
            }
        }
        return originalSpellStack;
    }

    private void restore(EntityPlayer player, World world, ItemStack stack, int x, int y, int z, double hitX, double hitY, double hitZ) {
        if (stack.field_77990_d.func_74764_b(storageKey)) {
            NBTTagCompound storageCompound = stack.field_77990_d.func_74775_l(storageKey);
            if (storageCompound != null) {
                String type = storageCompound.func_74779_i(storageType);
                if (type.equals("ent")) {
                    String clazz = storageCompound.func_74779_i("class");
                    NBTTagCompound entData = storageCompound.func_74775_l("targetNBT");
                    try {
                        Entity ent = (Entity)Class.forName(clazz).getConstructor(World.class).newInstance(world);
                        ent.func_70020_e(entData);
                        ent.func_70107_b(hitX, hitY, hitZ);
                        world.func_72838_d(ent);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                } else if (type.equals("block")) {
                    TileEntity te;
                    int blockID = storageCompound.func_74762_e("blockID");
                    int meta = storageCompound.func_74762_e("meta");
                    Block block = Block.func_149729_e((int)blockID);
                    if (block == null) {
                        if (!player.field_70170_p.field_72995_K) {
                            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.approError")));
                        }
                        stack.field_77990_d.func_82580_o(storageKey);
                        return;
                    }
                    world.func_147465_d(x, y, z, block, meta, 2);
                    if (storageCompound.func_74764_b("tileEntity") && (te = world.func_147438_o(x, y, z)) != null) {
                        te.func_145839_a(storageCompound.func_74775_l("tileEntity"));
                        te.field_145851_c = x;
                        te.field_145848_d = y;
                        te.field_145849_e = z;
                        te.func_145834_a(world);
                    }
                }
            }
            stack.field_77990_d.func_82580_o(storageKey);
            this.setOriginalSpellStackData(player, stack);
        }
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 415.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 100.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 5 + 5 * AMCore.config.getGFXLevel(); ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "water_ball", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.setMaxAge(10);
            particle.setParticleScale(0.1f);
            particle.AddParticleController(new ParticleOrbitPoint(particle, x, y, z, 1, false).SetTargetDistance(world.field_73012_v.nextDouble() + (double)0.1f).SetOrbitSpeed(0.2f));
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.WATER);
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }
}

