/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.RitualShapeHelper;
import am2.api.ArsMagicaApi;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.math.AMVector3;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.buffs.BuffList;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleExpandingCollapsingRingAtPoint;
import am2.playerextensions.ExtendedProperties;
import am2.utility.DimensionUtilities;
import am2.utility.EntityUtilities;
import am2.utility.KeystoneUtilities;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class Recall
implements ISpellComponent,
IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        int z;
        int y;
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (caster.func_82165_m(BuffList.astralDistortion.field_76415_H) || ((EntityLivingBase)target).func_82165_m(BuffList.astralDistortion.field_76415_H)) {
            if (caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.cantTeleport")));
            }
            return false;
        }
        int x = (int)Math.floor(target.field_70165_t);
        ItemStack[] ritualRunes = RitualShapeHelper.instance.checkForRitual(this, world, x, y = (int)Math.floor(target.field_70163_u), z = (int)Math.floor(target.field_70161_v), false);
        if (ritualRunes != null) {
            return this.handleRitualReagents(ritualRunes, world, x, y, z, caster, target);
        }
        ExtendedProperties casterProperties = ExtendedProperties.For(caster);
        if (!casterProperties.getMarkSet()) {
            if (caster instanceof EntityPlayer && !world.field_72995_K) {
                ((EntityPlayer)caster).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.noMark")));
            }
            return false;
        }
        if (casterProperties.getMarkDimension() != caster.field_71093_bK) {
            if (caster instanceof EntityPlayer && !world.field_72995_K) {
                ((EntityPlayer)caster).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.diffDimMark")));
            }
            return false;
        }
        if (!world.field_72995_K) {
            ((EntityLivingBase)target).func_70634_a(casterProperties.getMarkX(), casterProperties.getMarkY(), casterProperties.getMarkZ());
        }
        return true;
    }

    private boolean handleRitualReagents(ItemStack[] ritualRunes, World world, int x, int y, int z, EntityLivingBase caster, Entity target) {
        boolean hasVinteumDust = false;
        for (ItemStack stack : ritualRunes) {
            if (stack.func_77973_b() != ItemsCommonProxy.itemOre) continue;
            if (stack.func_77960_j() != 0) continue;
            hasVinteumDust = true;
            break;
        }
        if (!hasVinteumDust && ritualRunes.length == 3) {
            long key = KeystoneUtilities.instance.getKeyFromRunes(ritualRunes);
            AMVector3 vector = AMCore.proxy.blocks.getNextKeystonePortalLocation(world, x, y, z, false, key);
            if (vector == null || vector.equals(new AMVector3(x, y, z))) {
                if (caster instanceof EntityPlayer && !world.field_72995_K) {
                    ((EntityPlayer)caster).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.noMatchingGate")));
                }
                return false;
            }
            RitualShapeHelper.instance.consumeRitualReagents(this, world, x, y, z);
            RitualShapeHelper.instance.consumeRitualShape(this, world, x, y, z);
            ((EntityLivingBase)target).func_70634_a((double)vector.x, (double)(vector.y - target.field_70131_O), (double)vector.z);
            return true;
        }
        if (hasVinteumDust) {
            ArrayList<ItemStack> copy = new ArrayList<ItemStack>();
            for (ItemStack stack : ritualRunes) {
                if (stack.func_77973_b() != ItemsCommonProxy.rune || stack.func_77960_j() > 16) continue;
                copy.add(stack);
            }
            ItemStack[] newRunes = copy.toArray(new ItemStack[copy.size()]);
            long key = KeystoneUtilities.instance.getKeyFromRunes(newRunes);
            EntityPlayer player = EntityUtilities.getPlayerForCombo(world, (int)key);
            if (player == null) {
                if (caster instanceof EntityPlayer && !world.field_72995_K) {
                    ((EntityPlayer)caster).func_145747_a((IChatComponent)new ChatComponentText("am2.tooltip.noMatchingPlayer"));
                }
                return false;
            }
            if (player == caster) {
                if (caster instanceof EntityPlayer && !world.field_72995_K) {
                    ((EntityPlayer)caster).func_145747_a((IChatComponent)new ChatComponentText("am2.tooltip.cantSummonSelf"));
                }
                return false;
            }
            RitualShapeHelper.instance.consumeRitualReagents(this, world, x, y, z);
            if (target.field_70170_p.field_73011_w.field_76574_g != caster.field_70170_p.field_73011_w.field_76574_g) {
                DimensionUtilities.doDimensionTransfer((EntityLivingBase)player, caster.field_70170_p.field_73011_w.field_76574_g);
            }
            ((EntityLivingBase)target).func_70634_a((double)x, (double)y, (double)z);
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 500.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "arcane", x, y - 1.0, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 0.0, 1.0);
            particle.AddParticleController(new ParticleExpandingCollapsingRingAtPoint(particle, x, y - 1.0, z, 0.1, 3.0, 0.3, 1, false).setCollapseOnce());
            particle.setMaxAge(20);
            particle.setParticleScale(0.2f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.ARCANE);
    }

    @Override
    public int getID() {
        return 44;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[4];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 11);
        objectArray[1] = Items.field_151111_aL;
        objectArray[2] = new ItemStack((Item)Items.field_151148_bJ, 1, Short.MAX_VALUE);
        objectArray[3] = Items.field_151079_bi;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.1f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.ringedCross;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack((Item)ItemsCommonProxy.rune, 1, Short.MAX_VALUE), new ItemStack((Item)ItemsCommonProxy.rune, 1, Short.MAX_VALUE), new ItemStack((Item)ItemsCommonProxy.rune, 1, Short.MAX_VALUE)};
    }

    @Override
    public int getReagentSearchRadius() {
        return RitualShapeHelper.instance.ringedCross.getWidth();
    }
}

