/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shapes;

import am2.AMCore;
import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellCastResult;
import am2.api.spell.enums.SpellModifiers;
import am2.items.ItemsCommonProxy;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.spell.modifiers.Colour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class Chain
implements ISpellShape {
    @Override
    public int getID() {
        return 3;
    }

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, int side, boolean giveXP, int useCount) {
        MovingObjectPosition mop = item.getMovingObjectPosition(caster, world, 8.0, true, false);
        double range = SpellUtils.instance.getModifiedDouble_Mul(4.0, stack, caster, (Entity)target, world, 0, SpellModifiers.RANGE);
        int num_targets = SpellUtils.instance.getModifiedInt_Add(3, stack, caster, (Entity)target, world, 0, SpellModifiers.PROCS);
        ArrayList<EntityLivingBase> targets = new ArrayList<EntityLivingBase>();
        if (target != null) {
            mop = new MovingObjectPosition((Entity)target);
        }
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g != null) {
            Entity e = mop.field_72308_g;
            if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
            }
            if (e instanceof EntityLivingBase) {
                EntityLivingBase closest;
                do {
                    targets.add((EntityLivingBase)e);
                    List nearby = world.func_72872_a(EntityLivingBase.class, e.field_70121_D.func_72314_b(range, range, range));
                    closest = null;
                    for (EntityLivingBase near : nearby) {
                        if (targets.contains(near) || near == caster || closest != null && !(closest.func_70068_e(e) > near.func_70068_e(e))) continue;
                        closest = near;
                    }
                } while ((e = closest) != null && targets.size() < num_targets);
            }
        }
        ItemStack newItemStack = SpellUtils.instance.popStackStage(stack);
        boolean atLeastOneApplication = false;
        SpellCastResult result = SpellCastResult.SUCCESS;
        EntityLivingBase prevEntity = null;
        for (EntityLivingBase e : targets) {
            if (e == caster) continue;
            result = SpellHelper.instance.applyStageToEntity(stack, caster, world, (Entity)e, 0, giveXP);
            SpellHelper.instance.applyStackStage(newItemStack, caster, e, e.field_70165_t, e.field_70163_u, e.field_70161_v, 0, world, true, giveXP, 0);
            if (world.field_72995_K) {
                if (prevEntity == null) {
                    this.spawnChainParticles(world, x, y, z, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v, stack);
                } else {
                    this.spawnChainParticles(world, prevEntity.field_70165_t, prevEntity.field_70163_u + (double)e.func_70047_e(), prevEntity.field_70161_v, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v, stack);
                }
            }
            prevEntity = e;
            if (result != SpellCastResult.SUCCESS) continue;
            atLeastOneApplication = true;
        }
        if (atLeastOneApplication) {
            return SpellCastResult.SUCCESS;
        }
        return result;
    }

    private void spawnChainParticles(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, ItemStack spellStack) {
        int color = this.getPFXColor(spellStack);
        Affinity aff = SpellUtils.instance.mainAffinityFor(spellStack);
        if (aff == Affinity.LIGHTNING) {
            AMCore.proxy.particleManager.BoltFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, 1, color);
        } else {
            if (color == -1) {
                color = aff.color;
            }
            AMCore.proxy.particleManager.BeamFromPointToPoint(world, startX, startY, startZ, endX, endY, endZ, color);
        }
    }

    private int getPFXColor(ItemStack stack) {
        int color = -1;
        if (SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, stack, 0)) {
            ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(stack, 0);
            int ordinalCount = 0;
            for (ISpellModifier mod : mods) {
                if (!(mod instanceof Colour)) continue;
                byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(stack, mod, 0, ordinalCount++);
                color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta);
            }
        }
        return color;
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[5];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 6);
        objectArray[1] = Items.field_151058_ca;
        objectArray[2] = Items.field_151042_j;
        objectArray[3] = Blocks.field_150479_bC;
        objectArray[4] = Items.field_151007_F;
        return objectArray;
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 1.5f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return false;
    }

    @Override
    public String getSoundForAffinity(Affinity affinity, ItemStack stack, World world) {
        switch (affinity) {
            case AIR: {
                return "arsmagica2:spell.cast.air";
            }
            case ARCANE: {
                return "arsmagica2:spell.cast.arcane";
            }
            case EARTH: {
                return "arsmagica2:spell.cast.earth";
            }
            case ENDER: {
                return "arsmagica2:spell.cast.ender";
            }
            case FIRE: {
                return "arsmagica2:spell.cast.fire";
            }
            case ICE: {
                return "arsmagica2:spell.cast.ice";
            }
            case LIFE: {
                return "arsmagica2:spell.cast.life";
            }
            case LIGHTNING: {
                return "arsmagica2:spell.cast.lightning";
            }
            case NATURE: {
                return "arsmagica2:spell.cast.nature";
            }
            case WATER: {
                return "arsmagica2:spell.cast.water";
            }
        }
        return "arsmagica2:spell.cast.none";
    }
}

