/*
 * Decompiled with CFR 0.152.
 */
package am2.worldgen;

import am2.AMCore;
import am2.blocks.BlocksCommonProxy;
import am2.entities.SpawnBlacklists;
import am2.worldgen.AM2FlowerGen;
import am2.worldgen.AM2PoolGen;
import am2.worldgen.WitchwoodTreeHuge;
import am2.worldgen.WorldGenEssenceLakes;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class AM2WorldDecorator
implements IWorldGenerator {
    private final WorldGenMinable vinteum;
    private final WorldGenMinable blueTopaz;
    private final WorldGenMinable chimerite;
    private final WorldGenMinable sunstone;
    private final AM2FlowerGen blueOrchid;
    private final AM2FlowerGen desertNova;
    private final AM2FlowerGen wakebloom;
    private final AM2FlowerGen aum;
    private final AM2FlowerGen tarmaRoot;
    private ArrayList<Integer> dimensionBlacklist = new ArrayList();
    private final WitchwoodTreeHuge witchwoodTree;
    private final AM2PoolGen pools;
    private final WorldGenEssenceLakes lakes;

    public AM2WorldDecorator() {
        for (int i : AMCore.config.getWorldgenBlacklist()) {
            if (i == -1) continue;
            this.dimensionBlacklist.add(i);
        }
        this.vinteum = new WorldGenMinable((Block)BlocksCommonProxy.AMOres, 0, 4, Blocks.field_150348_b);
        this.chimerite = new WorldGenMinable((Block)BlocksCommonProxy.AMOres, 1, 6, Blocks.field_150348_b);
        this.blueTopaz = new WorldGenMinable((Block)BlocksCommonProxy.AMOres, 2, 6, Blocks.field_150348_b);
        this.sunstone = new WorldGenMinable((Block)BlocksCommonProxy.AMOres, 4, 3, Blocks.field_150353_l);
        this.blueOrchid = new AM2FlowerGen(BlocksCommonProxy.cerublossom, 0);
        this.desertNova = new AM2FlowerGen(BlocksCommonProxy.desertNova, 0);
        this.wakebloom = new AM2FlowerGen(BlocksCommonProxy.wakebloom, 0);
        this.aum = new AM2FlowerGen(BlocksCommonProxy.aum, 0);
        this.tarmaRoot = new AM2FlowerGen(BlocksCommonProxy.tarmaRoot, 0);
        this.witchwoodTree = new WitchwoodTreeHuge(true);
        this.pools = new AM2PoolGen();
        this.lakes = new WorldGenEssenceLakes((Block)BlocksCommonProxy.liquidEssence);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!SpawnBlacklists.worldgenCanHappenInDimension(world.field_73011_w.field_76574_g)) {
            return;
        }
        if (world.field_73011_w.field_76577_b == WorldType.field_77138_c) {
            return;
        }
        if (this.dimensionBlacklist.contains(world.field_73011_w.field_76574_g)) {
            return;
        }
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.generateOverworld(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            }
        }
    }

    public void generateNether(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateOre(this.sunstone, 20, world, random, 5, 120, chunkX, chunkZ);
    }

    public void generateOverworld(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateOre(this.vinteum, 6, world, random, 10, 45, chunkX, chunkZ);
        this.generateOre(this.chimerite, 8, world, random, 10, 80, chunkX, chunkZ);
        this.generateOre(this.blueTopaz, 8, world, random, 10, 80, chunkX, chunkZ);
        this.generateOre(this.sunstone, 20, world, random, 5, 120, chunkX, chunkZ);
        this.generateFlowers(this.blueOrchid, world, random, chunkX, chunkZ);
        this.generateFlowers(this.desertNova, world, random, chunkX, chunkZ);
        this.generateFlowers(this.tarmaRoot, world, random, chunkX, chunkZ);
        BiomeGenBase biome = world.func_72807_a(chunkX << 4, chunkZ << 4);
        BiomeDictionary.Type[] biomeTypes = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        boolean typeValid = false;
        for (BiomeDictionary.Type type : biomeTypes) {
            if (type == BiomeDictionary.Type.BEACH || type == BiomeDictionary.Type.SWAMP || type == BiomeDictionary.Type.JUNGLE || type == BiomeDictionary.Type.PLAINS || type == BiomeDictionary.Type.WATER) {
                typeValid = true;
                continue;
            }
            if (type != BiomeDictionary.Type.FROZEN) continue;
            typeValid = false;
            break;
        }
        if (biome != BiomeGenBase.field_76771_b && typeValid && random.nextInt(10) < 7) {
            this.generateFlowers(this.wakebloom, world, random, chunkX, chunkZ);
        }
        if (random.nextInt(35) == 0) {
            this.generateTree((WorldGenerator)this.witchwoodTree, world, random, chunkX, chunkZ);
        }
        if (random.nextInt(25) == 0) {
            this.generatePools(world, random, chunkX, chunkZ);
        }
        if ((BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) && random.nextInt(4) == 0 && TerrainGen.populate((IChunkProvider)chunkProvider, (World)world, (Random)random, (int)chunkX, (int)chunkZ, (boolean)true, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int lakeGenX = chunkX * 16 + random.nextInt(16) + 8;
            int lakeGenY = random.nextInt(128);
            int lakeGenZ = chunkZ * 16 + random.nextInt(16) + 8;
            new WorldGenEssenceLakes((Block)BlocksCommonProxy.liquidEssence).func_76484_a(world, random, lakeGenX, lakeGenY, lakeGenZ);
        }
    }

    private void generateFlowers(AM2FlowerGen flowers, World world, Random random, int chunkX, int chunkZ) {
        int x = (chunkX << 4) + random.nextInt(16) + 8;
        int y = random.nextInt(128);
        int z = (chunkZ << 4) + random.nextInt(16) + 8;
        flowers.func_76484_a(world, random, x, y, z);
    }

    private void generateOre(WorldGenMinable mineable, int amount, World world, Random random, int minY, int maxY, int chunkX, int chunkZ) {
        for (int i = 0; i < amount; ++i) {
            int x = (chunkX << 4) + random.nextInt(16);
            int y = random.nextInt(maxY - minY) + minY;
            int z = (chunkZ << 4) + random.nextInt(16);
            mineable.func_76484_a(world, random, x, y, z);
        }
    }

    private void generateTree(WorldGenerator trees, World world, Random random, int chunkX, int chunkZ) {
        int z;
        int y;
        int x = chunkX * 16 + random.nextInt(16);
        if (new WitchwoodTreeHuge(true).func_76484_a(world, random, x, y = world.func_72976_f(x, z = chunkZ * 16 + random.nextInt(16)), z)) {
            this.aum.func_76484_a(world, random, x, y, z);
        }
    }

    private void generatePools(World world, Random random, int chunkX, int chunkZ) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int y = world.func_72976_f(x, z);
        this.pools.generate(world, random, x, y, z);
    }
}

