/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.api.inventory.IInventoryConnection;
import cofh.core.CoFHProps;
import cofh.core.entity.CoFHFakePlayer;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiBreaker;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileBreaker
extends TileDeviceBase
implements IFluidHandler,
IInventoryConnection {
    CoFHFakePlayer myFakePlayer;
    LinkedList<ItemStack> stuffedItems = new LinkedList();
    public boolean augmentFluid;

    public static void initialize() {
        int n = BlockDevice.Types.BREAKER.ordinal();
        TileDeviceBase.defaultSideConfig[n] = new TileTEBase.SideConfig();
        TileDeviceBase.defaultSideConfig[n].numConfig = 2;
        TileDeviceBase.defaultSideConfig[n].slotGroups = new int[][]{new int[0], new int[0]};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSide = new boolean[]{false, false};
        TileDeviceBase.defaultSideConfig[n].allowExtractionSide = new boolean[]{false, false};
        TileDeviceBase.defaultSideConfig[n].allowInsertionSlot = new boolean[0];
        TileDeviceBase.defaultSideConfig[n].allowExtractionSlot = new boolean[0];
        TileDeviceBase.defaultSideConfig[n].sideTex = new int[]{0, 4};
        TileDeviceBase.defaultSideConfig[n].defaultSides = new byte[]{0, 0, 0, 0, 0, 0};
        GameRegistry.registerTileEntity(TileBreaker.class, (String)"thermalexpansion.Breaker");
    }

    public TileBreaker() {
        super(BlockDevice.Types.BREAKER);
    }

    @Override
    public void cofh_validate() {
        if (ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            this.myFakePlayer = new CoFHFakePlayer((WorldServer)((TileEntity)this).field_145850_b);
        }
        super.cofh_validate();
    }

    @Override
    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
        this.sideCache[this.facing ^ 1] = 1;
    }

    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        if (((TileEntity)this).field_145850_b.func_82737_E() % 16L == 0L && this.redstoneControlOrDisable()) {
            if (!this.isEmpty()) {
                this.outputBuffer();
            }
            if (this.isEmpty()) {
                this.breakBlock();
            }
        }
    }

    public boolean isEmpty() {
        return this.stuffedItems.size() == 0;
    }

    public void breakBlock() {
        FluidStack fluidStack;
        int[] nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)this.facing);
        Block block = ((TileEntity)this).field_145850_b.func_147439_a(nArray[0], nArray[1], nArray[2]);
        FluidStack fluidStack2 = fluidStack = this.augmentFluid ? FluidHelper.getFluidFromWorld((World)((TileEntity)this).field_145850_b, (int)nArray[0], (int)nArray[1], (int)nArray[2], (boolean)true) : null;
        if (fluidStack != null) {
            for (int i = 0; i < 6 && fluidStack.amount > 0; ++i) {
                if (this.sideCache[i] != 1) continue;
                fluidStack.amount -= FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (int)i, (FluidStack)fluidStack, (boolean)true);
            }
            ((TileEntity)this).field_145850_b.func_147468_f(nArray[0], nArray[1], nArray[2]);
        } else if (CoFHFakePlayer.isBlockBreakable((CoFHFakePlayer)this.myFakePlayer, (World)((TileEntity)this).field_145850_b, (int)nArray[0], (int)nArray[1], (int)nArray[2])) {
            this.stuffedItems.addAll(BlockHelper.breakBlock((World)((TileEntity)this).field_145850_b, (EntityPlayer)this.myFakePlayer, (int)nArray[0], (int)nArray[1], (int)nArray[2], (Block)block, (int)0, (boolean)true, (boolean)false));
        }
    }

    public void outputBuffer() {
        for (int i = 0; i < 6; ++i) {
            int[] nArray;
            TileEntity tileEntity;
            if (i == this.facing || this.sideCache[i] != 1 || !InventoryHelper.isInsertion((Object)(tileEntity = ((TileEntity)this).field_145850_b.func_147438_o((nArray = BlockHelper.getAdjacentCoordinatesForSide((int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e, (int)i))[0], nArray[1], nArray[2])))) continue;
            LinkedList<ItemStack> linkedList = new LinkedList<ItemStack>();
            for (Object object : this.stuffedItems) {
                object = object == null || object.func_77973_b() == null ? null : InventoryHelper.addToInsertion((Object)tileEntity, (int)i, (ItemStack)object);
                if (object == null) continue;
                linkedList.add((ItemStack)object);
            }
            this.stuffedItems = linkedList;
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiBreaker(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTEBase(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("StuffedInv", 10);
        this.stuffedItems.clear();
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            this.stuffedItems.add(ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList = new NBTTagList();
        for (int i = 0; i < this.stuffedItems.size(); ++i) {
            if (this.stuffedItems.get(i) == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            this.stuffedItems.get(i).func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("StuffedInv", (NBTBase)nBTTagList);
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return CoFHProps.EMPTY_TANK_INFO;
    }

    public IInventoryConnection.ConnectionType canConnectInventory(ForgeDirection forgeDirection) {
        if (forgeDirection != ForgeDirection.UNKNOWN && forgeDirection.ordinal() != this.facing && this.sideCache[forgeDirection.ordinal()] == 1) {
            return IInventoryConnection.ConnectionType.FORCE;
        }
        return IInventoryConnection.ConnectionType.DEFAULT;
    }
}

