/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.api.energy.EnergyStorage;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileAugmentable;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.gui.client.machine.GuiTransposer;
import cofh.thermalexpansion.gui.container.machine.ContainerTransposer;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TilePump
extends TileAugmentable
implements IFluidHandler {
    static final int TYPE = BlockDevice.Types.EXTENDER.ordinal();
    static TileTEBase.SideConfig defaultSideConfig = new TileTEBase.SideConfig();
    public static boolean enableSecurity = true;
    int outputTracker;
    FluidTankAdv tank = new FluidTankAdv(10000);
    public boolean reverse;

    public static void initialize() {
        defaultSideConfig = new TileTEBase.SideConfig();
        TilePump.defaultSideConfig.numConfig = 2;
        TilePump.defaultSideConfig.slotGroups = new int[][]{new int[0], new int[0]};
        TilePump.defaultSideConfig.allowInsertionSide = new boolean[]{false, false};
        TilePump.defaultSideConfig.allowExtractionSide = new boolean[]{false, false};
        TilePump.defaultSideConfig.allowInsertionSlot = new boolean[0];
        TilePump.defaultSideConfig.allowExtractionSlot = new boolean[0];
        TilePump.defaultSideConfig.sideTex = new int[]{0, 4};
        TilePump.defaultSideConfig.defaultSides = new byte[]{0, 0, 1, 1, 1, 1};
        GameRegistry.registerTileEntity(TilePump.class, (String)"thermalexpansion.Pump");
        TilePump.configure();
    }

    public static void configure() {
        String string = "Enable this to allow for Pumps to be securable.";
        enableSecurity = ThermalExpansion.config.get("Security", "Device.Pump.Securable", enableSecurity, string);
    }

    public TilePump() {
        this.sideConfig = defaultSideConfig;
        this.sideCache = new byte[]{0, 0, 1, 1, 1, 1};
        this.energyStorage = new EnergyStorage(0);
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return BlockDevice.Types.EXTENDER.ordinal();
    }

    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiTransposer(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTransposer(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public FluidTankAdv getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.outputTracker = nBTTagCompound.func_74762_e("Tracker");
        this.reverse = nBTTagCompound.func_74767_n("Rev");
        this.tank.readFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Tracker", this.outputTracker);
        nBTTagCompound.func_74757_a("Rev", this.reverse);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public int getNumConfig(int n) {
        return 3;
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        return null;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (!this.reverse || forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] != 1) {
            return 0;
        }
        return this.tank.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (this.reverse || forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] != 2) {
            return null;
        }
        return this.tank.drain(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        if (this.reverse || forgeDirection == ForgeDirection.UNKNOWN || this.sideCache[forgeDirection.ordinal()] != 2) {
            return null;
        }
        return this.tank.drain(n, bl);
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return false;
        }
        return !this.reverse && this.sideCache[forgeDirection.ordinal()] == 1;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        if (forgeDirection == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.reverse && this.sideCache[forgeDirection.ordinal()] == 2;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

