/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityHomingArrow;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ArchangelSmite
extends RingToggle
implements IPedestalItem,
IModeChanger {
    public ArchangelSmite() {
        super("archangel_smite");
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!world.field_72995_K && this.getMode(stack) == 1 && entity instanceof EntityLivingBase) {
            this.fireArrow(stack, world, (EntityLivingBase)entity);
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.fireArrow(stack, world, (EntityLivingBase)player);
        }
        return stack;
    }

    private void fireArrow(ItemStack ring, World world, EntityLivingBase shooter) {
        EntityHomingArrow arrow = new EntityHomingArrow(world, shooter, 2.0f);
        if (!(shooter instanceof EntityPlayer) || ArchangelSmite.consumeFuel((EntityPlayer)shooter, ring, EMCHelper.getEmcValue(Items.field_151032_g), true)) {
            world.func_72956_a((Entity)shooter, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
            world.func_72838_d((Entity)arrow);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.getTexture("rings", "archangel_smite"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int dmg) {
        return this.field_77791_bV;
    }

    @Override
    public void updateInPedestal(World world, int x, int y, int z) {
        if (!world.field_72995_K && ProjectEConfig.archangelPedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_147438_o(x, y, z);
            if (tile.getActivityCooldown() == 0) {
                if (!world.func_72872_a(EntityLiving.class, tile.getEffectBounds()).isEmpty()) {
                    for (int i = 0; i < 3; ++i) {
                        EntityHomingArrow arrow = new EntityHomingArrow(world, (EntityLivingBase)FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)PECore.FAKEPLAYER_GAMEPROFILE), 2.0f);
                        arrow.field_70165_t = tile.centeredX;
                        arrow.field_70163_u = tile.centeredY + 2.0;
                        arrow.field_70161_v = tile.centeredZ;
                        arrow.field_70159_w = 0.0;
                        arrow.field_70179_y = 0.0;
                        arrow.field_70181_x = 1.0;
                        world.func_72956_a((Entity)arrow, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + 0.5f);
                        world.func_72838_d((Entity)arrow);
                    }
                }
                tile.setActivityCooldown(ProjectEConfig.archangelPedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.archangelPedCooldown != -1) {
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.archangel.pedestal1"));
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.archangel.pedestal2"), MathUtils.tickToSecFormatted(ProjectEConfig.archangelPedCooldown)));
        }
        return list;
    }
}

