/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import moze_intel.projecte.gameObjs.tiles.TileEmcDirection;
import moze_intel.projecte.utils.Coordinates;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;

public class OrientationSyncPKT
implements IMessage {
    private int orientation;
    private int x;
    private int y;
    private int z;

    public OrientationSyncPKT() {
    }

    public OrientationSyncPKT(TileEntity tile, int orientation) {
        this.orientation = orientation;
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
    }

    public void fromBytes(ByteBuf buf) {
        this.orientation = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.orientation);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static class Handler
    implements IMessageHandler<OrientationSyncPKT, IMessage> {
        public IMessage onMessage(OrientationSyncPKT pkt, MessageContext ctx) {
            TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_147438_o(pkt.x, pkt.y, pkt.z);
            if (tile instanceof TileEmcDirection) {
                ((TileEmcDirection)tile).setOrientation(pkt.orientation);
            } else {
                PELogger.logFatal("Couldn't find Tile Entity in passed in packet! Please report to dev!");
                PELogger.logFatal("Coordinates: " + new Coordinates(pkt.x, pkt.y, pkt.z));
            }
            return null;
        }
    }
}

