/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.client.particle.MowzieParticle;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class OrbParticle
extends MowzieParticle {
    private double targetX;
    private double targetY;
    private double targetZ;
    private double startX;
    private double startY;
    private double startZ;
    private double signX;
    private double signZ;
    private int mode;
    private double duration;

    public OrbParticle(World world, double x, double y, double z, double targetX, double targetZ) {
        super(world, x, y, z);
        this.targetX = targetX;
        this.targetZ = targetZ;
        this.setTextureIndex(0, 0);
        this.field_70544_f = 1.5f + this.field_70146_Z.nextFloat() * 0.5f;
        this.field_70547_e = 120;
        this.signX = Math.signum(targetX - this.field_70165_t);
        this.signZ = Math.signum(targetZ - this.field_70161_v);
        this.mode = 0;
    }

    public OrbParticle(World world, double x, double y, double z, double targetX, double targetY, double targetZ, double speed) {
        this(world, x, y, z, targetX, targetZ);
        this.targetY = targetY;
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.duration = speed;
        this.mode = 1;
    }

    public int func_70070_b(float delta) {
        return 0xF0 | super.func_70070_b(delta) & 0xFF0000;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.mode == 0) {
            double vecX = this.targetX - this.field_70165_t;
            double vecZ = this.targetZ - this.field_70161_v;
            double dist = Math.sqrt(vecX * vecX + vecZ * vecZ);
            if (dist > 2.0 || Math.signum(vecX) != this.signX || Math.signum(vecZ) != this.signZ || this.field_70546_d > this.field_70547_e) {
                this.func_70106_y();
                return;
            }
            double peak = 0.5;
            this.field_82339_as = (float)(dist > 0.5 ? MathUtils.linearTransformd(dist, 0.5, 2.0, 1.0, 0.0) : MathUtils.linearTransformd(dist, 0.1f, 0.5, 0.0, 1.0));
            double minVel = 0.05;
            double maxVel = 0.3;
            double progress = Math.sin(-0.7853981633974483 * dist) + 1.0;
            double magMultipler = (progress * 0.25 + 0.05) / dist;
            this.field_70159_w = vecX *= magMultipler;
            this.field_70181_x = progress;
            this.field_70179_y = vecZ *= magMultipler;
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else if (this.mode == 1) {
            this.field_82339_as = (float)(10.0 * Math.sqrt(Math.pow(this.field_70165_t - this.startX, 2.0) + Math.pow(this.field_70163_u - this.startY, 2.0) + Math.pow(this.field_70161_v - this.startZ, 2.0)) / Math.sqrt(Math.pow(this.targetX - this.startX, 2.0) + Math.pow(this.targetY - this.startY, 2.0) + Math.pow(this.targetZ - this.startZ, 2.0)));
            this.field_70165_t = this.startX + (this.targetX - this.startX) / (1.0 + Math.exp(-(8.0 / this.duration) * ((double)this.field_70546_d - this.duration / 2.0)));
            this.field_70163_u = this.startY + (this.targetY - this.startY) / (1.0 + Math.exp(-(8.0 / this.duration) * ((double)this.field_70546_d - this.duration / 2.0)));
            this.field_70161_v = this.startZ + (this.targetZ - this.startZ) / (1.0 + Math.exp(-(8.0 / this.duration) * ((double)this.field_70546_d - this.duration / 2.0)));
            if ((double)this.field_70546_d == this.duration) {
                this.func_70106_y();
            }
        }
        ++this.field_70546_d;
    }
}

