/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.server.entity.EntitySunstrike;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SunstrikeRenderer
extends Render {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/effects/textureSunstrike.png");
    private static final Random RANDOMIZER = new Random(0L);
    private static final double TEXTURE_WIDTH = 256.0;
    private static final double TEXTURE_HEIGHT = 32.0;
    private static final double BEAM_MIN_U = 0.875;
    private static final double BEAM_MAX_U = 1.0;
    private static final double PIXEL_SCALE = 0.0625;
    private static final int MAX_HEIGHT = 256;
    private static final float DRAW_FADE_IN_RATE = 2.0f;
    private static final float DRAW_FADE_IN_POINT = 0.5f;
    private static final float DRAW_OPACITY_MULTIPLER = 0.7f;
    private static final double RING_RADIUS = 1.6;
    private static final int RING_FRAME_SIZE = 16;
    private static final int RING_FRAME_COUNT = 10;
    private static final int BREAM_FRAME_COUNT = 31;
    private static final double BEAM_DRAW_START_RADIUS = 2.0;
    private static final double BEAM_DRAW_END_RADIUS = 0.25;
    private static final double BEAM_STRIKE_RADIUS = 1.0;
    private static final double LINGER_RADIUS = 1.2;
    private static final double SCORCH_MIN_U = 0.75;
    private static final double SCORCH_MAX_U = 0.8125;
    private static final double SCORCH_MIN_V = 0.5;
    private static final double SCORCH_MAX_V = 1.0;

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float delta) {
        EntitySunstrike sunstrike = (EntitySunstrike)entity;
        double maxY = 256.0 - sunstrike.field_70163_u;
        if (maxY < 0.0) {
            return;
        }
        RANDOMIZER.setSeed(sunstrike.getVariant());
        boolean isLingering = sunstrike.isLingering(delta);
        boolean isStriking = sunstrike.isStriking(delta);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        this.setupGL();
        this.func_110777_b(sunstrike);
        if (isLingering) {
            this.drawScorch(sunstrike, delta);
        } else if (isStriking) {
            this.drawStrike(sunstrike, maxY, delta);
        }
        this.revertGL();
        GL11.glPopMatrix();
    }

    private void drawScorch(EntitySunstrike sunstrike, float delta) {
        World world = this.field_76990_c.field_78722_g;
        double ex = sunstrike.field_70142_S + (sunstrike.field_70165_t - sunstrike.field_70142_S) * (double)delta;
        double ey = sunstrike.field_70137_T + (sunstrike.field_70163_u - sunstrike.field_70137_T) * (double)delta + (double)sunstrike.func_70053_R();
        double ez = sunstrike.field_70136_U + (sunstrike.field_70161_v - sunstrike.field_70136_U) * (double)delta;
        int minX = MathHelper.func_76128_c((double)(ex - 1.2));
        int maxX = MathHelper.func_76128_c((double)(ex + 1.2));
        int minY = MathHelper.func_76128_c((double)(ey - 1.2));
        int maxY = MathHelper.func_76128_c((double)ey);
        int minZ = MathHelper.func_76128_c((double)(ez - 1.2));
        int maxZ = MathHelper.func_76128_c((double)(ez + 1.2));
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        float opacityMultiplier = (0.6f + RANDOMIZER.nextFloat() * 0.2f) * this.field_76990_c.field_78722_g.func_72801_o(MathHelper.func_76128_c((double)ex), MathHelper.func_76128_c((double)ey), MathHelper.func_76128_c((double)ez));
        byte mirrorX = (byte)(RANDOMIZER.nextBoolean() ? -1 : 1);
        byte mirrorZ = (byte)(RANDOMIZER.nextBoolean() ? -1 : 1);
        for (int bx = minX; bx <= maxX; ++bx) {
            for (int by = minY; by <= maxY; ++by) {
                for (int bz = minZ; bz <= maxZ; ++bz) {
                    Block block = world.func_147439_a(bx, by - 1, bz);
                    if (block.func_149688_o() == Material.field_151579_a || world.func_72957_l(bx, by, bz) <= 3) continue;
                    this.drawScorchBlock(block, bx, by, bz, ex, ey - (double)sunstrike.func_70053_R(), ez, opacityMultiplier, mirrorX, mirrorZ);
                }
            }
        }
        GL11.glDepthMask((boolean)false);
        t.func_78381_a();
        GL11.glDepthMask((boolean)true);
    }

    private void drawScorchBlock(Block block, int bx, int by, int bz, double ex, double ey, double ez, float opacityMultiplier, byte mirrorX, byte mirrorZ) {
        float opacity;
        Tessellator t = Tessellator.field_78398_a;
        if (block.func_149686_d() && (opacity = (float)((1.0 - (ey - (double)by) / 2.0) * (double)opacityMultiplier)) >= 0.0f) {
            if (opacity > 1.0f) {
                opacity = 1.0f;
            }
            t.func_78369_a(1.0f, 1.0f, 1.0f, opacity);
            double minX = (double)bx + block.func_149704_x() - ex;
            double maxX = (double)bx + block.func_149753_y() - ex;
            double y = (double)by + block.func_149665_z() - ey + 0.015625;
            double minZ = (double)bz + block.func_149706_B() - ez;
            double maxZ = (double)bz + block.func_149693_C() - ez;
            double minU = ((double)mirrorX * minX / 2.0 / 1.2 + 0.5) * 0.0625 + 0.75;
            double maxU = ((double)mirrorX * maxX / 2.0 / 1.2 + 0.5) * 0.0625 + 0.75;
            double minV = ((double)mirrorZ * minZ / 2.0 / 1.2 + 0.5) * 0.5 + 0.5;
            double maxV = ((double)mirrorZ * maxZ / 2.0 / 1.2 + 0.5) * 0.5 + 0.5;
            t.func_78374_a(minX, y, minZ, minU, minV);
            t.func_78374_a(minX, y, maxZ, minU, maxV);
            t.func_78374_a(maxX, y, maxZ, maxU, maxV);
            t.func_78374_a(maxX, y, minZ, maxU, minV);
        }
    }

    private void drawStrike(EntitySunstrike sunstrike, double maxY, float delta) {
        float opacity;
        float drawTime = sunstrike.getStrikeDrawTime(delta);
        float strikeTime = sunstrike.getStrikeDamageTime(delta);
        boolean drawing = sunstrike.isStrikeDrawing(delta);
        float f = opacity = drawing && drawTime < 0.5f ? drawTime * 2.0f : 1.0f;
        if (drawing) {
            opacity *= 0.7f;
        }
        this.drawRing(drawing, drawTime, strikeTime, opacity);
        GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        this.drawBeam(drawing, drawTime, strikeTime, opacity, maxY);
    }

    private void drawRing(boolean drawing, float drawTime, float strikeTime, float opacity) {
        int frame = (int)((drawing ? drawTime : strikeTime) * 11.0f);
        if (frame > 10) {
            frame = 10;
        }
        double minU = (double)(frame * 16) / 256.0;
        double maxU = minU + 0.0625;
        double minV = drawing ? 0.0 : 0.5;
        double maxV = minV + 0.5;
        double offset = 0.1 * (double)(frame % 2);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78380_c(240);
        t.func_78369_a(1.0f, 1.0f, 1.0f, opacity);
        t.func_78374_a(-1.6 + offset, 0.0, -1.6 + offset, minU, minV);
        t.func_78374_a(-1.6 + offset, 0.0, 1.6 + offset, minU, maxV);
        t.func_78374_a(1.6 + offset, 0.0, 1.6 + offset, maxU, maxV);
        t.func_78374_a(1.6 + offset, 0.0, -1.6 + offset, maxU, minV);
        GL11.glDepthMask((boolean)false);
        t.func_78381_a();
        GL11.glDepthMask((boolean)true);
    }

    private void drawBeam(boolean drawing, float drawTime, float strikeTime, float opacity, double maxY) {
        int frame;
        int n = frame = drawing ? 0 : (int)(strikeTime * 32.0f);
        if (frame > 31) {
            frame = 31;
        }
        double radius = 1.0;
        if (drawing) {
            radius = -1.75 * (double)drawTime + 2.0;
        }
        double minV = (double)frame / 32.0;
        double maxV = (double)(frame + 1) / 32.0;
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78380_c(240);
        t.func_78369_a(1.0f, 1.0f, 1.0f, opacity);
        t.func_78374_a(-radius, 0.0, 0.0, 0.875, minV);
        t.func_78374_a(-radius, maxY, 0.0, 0.875, maxV);
        t.func_78374_a(radius, maxY, 0.0, 1.0, maxV);
        t.func_78374_a(radius, 0.0, 0.0, 1.0, minV);
        t.func_78381_a();
    }

    private void setupGL() {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.0f);
    }

    private void revertGL() {
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.1f);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return TEXTURE;
    }
}

