/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribeLeader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TribeLeaderRenderer
extends RenderLiving {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/entity/textureTribeLeader.png");
    private static final ResourceLocation BURST_TEXTURE = new ResourceLocation("mowziesmobs", "textures/effects/textureSunstrike.png");
    private static final double BURST_RADIUS = 3.5;
    private static final int BURST_FRAME_COUNT = 10;
    private static final int BURST_START_FRAME = 12;

    public TribeLeaderRenderer(ModelBase model, float shadowSize) {
        super(model, shadowSize);
    }

    public ResourceLocation func_110775_a(Entity entity) {
        return TEXTURE;
    }

    protected float func_77037_a(EntityLivingBase entity) {
        return 0.0f;
    }

    public void func_76986_a(EntityLiving entityLiving, double x, double y, double z, float yaw, float delta) {
        EntityTribeLeader barako = (EntityTribeLeader)entityLiving;
        if (barako.getAnimation() == EntityTribeLeader.ATTACK_ANIMATION && barako.getAnimationTick() > 12 && barako.getAnimationTick() < 21) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)(y + 1.1), (double)z);
            this.setupGL();
            this.func_110776_a(BURST_TEXTURE);
            GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glDisable((int)2929);
            this.drawBurst((float)(barako.getAnimationTick() - 12) + delta);
            GL11.glEnable((int)2929);
            this.revertGL();
            GL11.glPopMatrix();
        }
        super.func_76986_a(entityLiving, x, y, z, yaw, delta);
    }

    private void drawBurst(float tick) {
        int frame;
        int dissapateFrame = 6;
        float firstSpeed = 2.0f;
        float secondSpeed = 1.0f;
        int n = frame = (int)(tick * firstSpeed) <= dissapateFrame ? (int)(tick * firstSpeed) : (int)((float)dissapateFrame + (tick - (float)dissapateFrame / firstSpeed) * secondSpeed);
        if (frame > 10) {
            frame = 10;
        }
        double minU = 0.0625 * (double)frame;
        double maxU = minU + 0.0625;
        double minV = 0.5;
        double maxV = minV + 0.5;
        double offset = 0.219 * (double)(frame % 2);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78380_c(240);
        t.func_78369_a(1.0f, 1.0f, 1.0f, tick < 8.0f ? 0.8f : 0.4f);
        t.func_78374_a(-3.5 + offset, -3.5 + offset, 0.0, minU, minV);
        t.func_78374_a(-3.5 + offset, 3.5 + offset, 0.0, minU, maxV);
        t.func_78374_a(3.5 + offset, 3.5 + offset, 0.0, maxU, maxV);
        t.func_78374_a(3.5 + offset, -3.5 + offset, 0.0, maxU, minV);
        GL11.glDepthMask((boolean)false);
        t.func_78381_a();
        GL11.glDepthMask((boolean)true);
    }

    private void setupGL() {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.0f);
    }

    private void revertGL() {
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glAlphaFunc((int)516, (float)0.1f);
    }
}

