/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribeLeader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySolarBeam
extends Entity {
    private final double RADIUS = 20.0;
    public EntityLivingBase caster;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public ControlledAnimation appear = new ControlledAnimation(3);
    public boolean on = true;
    public int blockSide = -1;

    public EntitySolarBeam(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70158_ak = true;
    }

    public EntitySolarBeam(World world, EntityLivingBase caster, double x, double y, double z, float yaw, float pitch, int duration) {
        this(world);
        this.caster = caster;
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setDuration(duration);
        this.func_70107_b(x, y, z);
        this.calculateEndPos();
        this.func_85030_a("mowziesmobs:laser", 2.0f, 1.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1 && this.field_70170_p.field_72995_K) {
            this.caster = (EntityLivingBase)this.field_70170_p.func_73045_a(this.getCasterID());
        }
        if (!this.field_70170_p.field_72995_K && this.getHasPlayer()) {
            this.updateWithPlayer();
        }
        if (!this.on && this.appear.getTimer() == 0) {
            this.func_70106_y();
        }
        if (this.on && this.field_70173_aa > 20) {
            this.appear.increaseTimer();
        } else {
            this.appear.decreaseTimer();
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa <= 10) {
            int particleCount = 8;
            while (--particleCount != 0) {
                double radius = 2.0;
                double yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                double pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                double ox = radius * Math.sin(yaw) * Math.sin(pitch);
                double oy = radius * Math.cos(pitch);
                double oz = radius * Math.cos(yaw) * Math.sin(pitch);
                double offsetX = -2.0 * Math.cos(this.getYaw());
                double offsetZ = -2.0 * Math.sin(this.getYaw());
                if (this.getHasPlayer()) {
                    offsetZ = 0.0;
                    offsetX = 0.0;
                }
                MowziesMobs.PROXY.spawnOrbFX(this.field_70170_p, this.field_70165_t + ox + offsetX, this.field_70163_u + oy + 0.3, this.field_70161_v + oz + offsetZ, this.field_70165_t + offsetX, this.field_70163_u + 0.3, this.field_70161_v + offsetZ, 10.0);
            }
        }
        if (this.field_70173_aa > 20) {
            this.calculateEndPos();
            List hit = this.raytraceEntities(this.field_70170_p, Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), Vec3.func_72443_a((double)this.endPosX, (double)this.endPosY, (double)this.endPosZ), false, true, true).entities;
            if (this.blockSide != -1) {
                this.spawnExplosionParticles(2);
            }
            if (!this.field_70170_p.field_72995_K) {
                for (EntityLivingBase target : hit) {
                    if (this.caster instanceof EntityTribeLeader && target instanceof LeaderSunstrikeImmune) continue;
                    target.func_70097_a(DamageSource.field_76370_b, 2.0f);
                    target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.caster), 1.5f);
                }
            } else if ((double)(this.field_70173_aa - 15) < this.getDuration()) {
                int particleCount = 4;
                while (--particleCount != 0) {
                    double radius = 1.0;
                    double yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    double pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    double ox = radius * Math.sin(yaw) * Math.sin(pitch);
                    double oy = radius * Math.cos(pitch);
                    double oz = radius * Math.cos(yaw) * Math.sin(pitch);
                    double o2x = -1.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
                    double o2y = -1.0 * Math.sin(this.getPitch());
                    double o2z = -1.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
                    MowziesMobs.PROXY.spawnOrbFX(this.field_70170_p, this.field_70165_t + o2x + ox, this.field_70163_u + o2y + oy, this.field_70161_v + o2z + oz, this.collidePosX + o2x + ox, this.collidePosY + o2y + oy, this.collidePosZ + o2z + oz, 15.0);
                }
                int particleCount2 = 4;
                while (--particleCount2 != 0) {
                    double radius = 2.0;
                    double yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    double pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    double ox = radius * Math.sin(yaw) * Math.sin(pitch);
                    double oy = radius * Math.cos(pitch);
                    double oz = radius * Math.cos(yaw) * Math.sin(pitch);
                    double o2x = -1.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
                    double o2y = -1.0 * Math.sin(this.getPitch());
                    double o2z = -1.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
                    MowziesMobs.PROXY.spawnOrbFX(this.field_70170_p, this.collidePosX + o2x, this.collidePosY + o2y, this.collidePosZ + o2z, this.collidePosX + o2x + ox, this.collidePosY + o2y + oy, this.collidePosZ + o2z + oz, 20.0);
                }
            }
        }
        if ((double)(this.field_70173_aa - 20) > this.getDuration()) {
            this.on = false;
        }
    }

    private void spawnExplosionParticles(int amount) {
        int i;
        for (i = 0; i < amount; ++i) {
            float velocity = 0.1f;
            float yaw = (float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI);
            float motionY = this.field_70146_Z.nextFloat() * 0.08f;
            float motionX = 0.1f * MathHelper.func_76134_b((float)yaw);
            float motionZ = 0.1f * MathHelper.func_76126_a((float)yaw);
            this.field_70170_p.func_72869_a("flame", this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ);
        }
        for (i = 0; i < amount / 2; ++i) {
            this.field_70170_p.func_72869_a("lava", this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, 0.0, 0.0, 0.0);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(2, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(3, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(4, (Object)0);
        this.field_70180_af.func_75682_a(5, (Object)0);
        this.field_70180_af.func_75682_a(6, (Object)0);
    }

    public double getYaw() {
        return this.field_70180_af.func_111145_d(2);
    }

    public void setYaw(float yaw) {
        this.field_70180_af.func_75692_b(2, (Object)Float.valueOf(yaw));
    }

    public double getPitch() {
        return this.field_70180_af.func_111145_d(3);
    }

    public void setPitch(float pitch) {
        this.field_70180_af.func_75692_b(3, (Object)Float.valueOf(pitch));
    }

    public double getDuration() {
        return this.field_70180_af.func_75679_c(4);
    }

    public void setDuration(int duration) {
        this.field_70180_af.func_75692_b(4, (Object)duration);
    }

    public boolean getHasPlayer() {
        return this.field_70180_af.func_75683_a(5) == 1;
    }

    public void setHasPlayer(boolean player) {
        this.field_70180_af.func_75692_b(5, (Object)(player ? (byte)1 : 0));
    }

    public int getCasterID() {
        return this.field_70180_af.func_75679_c(6);
    }

    public void setCasterID(int id) {
        this.field_70180_af.func_75692_b(6, (Object)id);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.func_70106_y();
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    private void calculateEndPos() {
        this.endPosX = this.field_70165_t + 20.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
        this.endPosZ = this.field_70161_v + 20.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
        this.endPosY = this.field_70163_u + 20.0 * Math.sin(this.getPitch());
    }

    public HitResult raytraceEntities(World world, Vec3 from, Vec3 to, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        HitResult result = new HitResult();
        result.setBlockHit(world.func_147447_a(Vec3.func_72443_a((double)from.field_72450_a, (double)from.field_72448_b, (double)from.field_72449_c), to, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock));
        if (result.blockHit != null) {
            this.collidePosX = ((HitResult)result).blockHit.field_72307_f.field_72450_a;
            this.collidePosY = ((HitResult)result).blockHit.field_72307_f.field_72448_b;
            this.collidePosZ = ((HitResult)result).blockHit.field_72307_f.field_72449_c;
            this.blockSide = ((HitResult)result).blockHit.field_72310_e;
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = -1;
        }
        List entities = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)Math.min(this.field_70165_t, this.collidePosX), (double)Math.min(this.field_70163_u, this.collidePosY), (double)Math.min(this.field_70161_v, this.collidePosZ), (double)Math.max(this.field_70165_t, this.collidePosX), (double)Math.max(this.field_70163_u, this.collidePosY), (double)Math.max(this.field_70161_v, this.collidePosZ)).func_72314_b(1.0, 1.0, 1.0));
        for (EntityLivingBase entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.func_70111_Y() + 0.5f;
            AxisAlignedBB aabb = entity.field_70121_D.func_72314_b((double)pad, (double)pad, (double)pad);
            MovingObjectPosition hit = aabb.func_72327_a(from, to);
            if (aabb.func_72318_a(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (hit == null) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70112_a(double distance) {
        return distance < 1024.0;
    }

    private void updateWithPlayer() {
        this.setYaw((float)((double)(this.caster.field_70759_as + 90.0f) * Math.PI / 180.0));
        this.setPitch((float)((double)(-this.caster.field_70125_A) * Math.PI / 180.0));
        this.func_70107_b(this.caster.field_70165_t, this.caster.field_70163_u + (double)1.2f, this.caster.field_70161_v);
    }

    public static class HitResult {
        private MovingObjectPosition blockHit;
        private List<EntityLivingBase> entities = new ArrayList<EntityLivingBase>();

        public MovingObjectPosition getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(MovingObjectPosition blockHit) {
            this.blockHit = blockHit;
        }

        public void addEntityHit(EntityLivingBase entity) {
            this.entities.add(entity);
        }
    }
}

