/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribeLeader;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S18PacketEntityTeleport;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntitySunstrike
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int STRIKE_EXPLOSION = 35;
    private static final int VARIANT_MIN_ID = 2;
    private static final int VARIANT_MAX_ID = 3;
    private static final int STRIKE_LENGTH = 43;
    private static final int STRIKE_LINGER = 1243;
    private int prevStrikeTime;
    private int strikeTime;
    private EntityLivingBase caster;

    public EntitySunstrike(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70158_ak = true;
    }

    public EntitySunstrike(World world, EntityLivingBase caster, int x, int y, int z) {
        this(world);
        this.caster = caster;
        this.func_70107_b((float)x + 0.5f, (float)y + 1.0625f, (float)z + 0.5f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(2, (Object)0);
        this.field_70180_af.func_75682_a(3, (Object)0);
    }

    public float getStrikeTime(float delta) {
        return this.getActualStrikeTime(delta) / 43.0f;
    }

    public float getStrikeDrawTime(float delta) {
        return this.getActualStrikeTime(delta) / 35.0f;
    }

    public float getStrikeDamageTime(float delta) {
        return (this.getActualStrikeTime(delta) - 35.0f) / 8.0f;
    }

    public boolean isStrikeDrawing(float delta) {
        return this.getActualStrikeTime(delta) < 35.0f;
    }

    public boolean isLingering(float delta) {
        return this.getActualStrikeTime(delta) > 40.0f;
    }

    public boolean isStriking(float delta) {
        return this.getActualStrikeTime(delta) < 43.0f;
    }

    private float getActualStrikeTime(float delta) {
        return (float)this.prevStrikeTime + (float)(this.strikeTime - this.prevStrikeTime) * delta;
    }

    private void setStrikeTime(int strikeTime) {
        this.prevStrikeTime = this.strikeTime = strikeTime;
    }

    public long getVariant() {
        return (long)this.field_70180_af.func_75679_c(3) << 32 | (long)this.field_70180_af.func_75679_c(2) & 0xFFFFFFFFL;
    }

    private void setVariant(long variant) {
        this.field_70180_af.func_75692_b(3, (Object)((int)(variant >> 32)));
        this.field_70180_af.func_75692_b(2, (Object)((int)variant));
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70112_a(double distance) {
        return distance < 1024.0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevStrikeTime = this.strikeTime;
        if (this.field_70170_p.field_72995_K) {
            if (this.strikeTime == 0) {
                MowziesMobs.PROXY.playSunstrikeSound(this);
            } else if (this.strikeTime < 25) {
                float time = this.getStrikeTime(1.0f);
                int timeBonus = (int)(time * 5.0f);
                int orbCount = this.field_70146_Z.nextInt(4 + timeBonus) + timeBonus + 1;
                while (orbCount-- > 0) {
                    float theta = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    float min = 0.2f;
                    float max = 1.9f;
                    float r = this.field_70146_Z.nextFloat() * 1.6999999f + 0.2f;
                    float ox = r * MathHelper.func_76134_b((float)theta);
                    float oz = r * MathHelper.func_76126_a((float)theta);
                    float minY = 0.1f;
                    float oy = this.field_70146_Z.nextFloat() * (time * 6.0f - 0.1f) + 0.1f;
                    MowziesMobs.PROXY.spawnOrbFX(this.field_70170_p, this.field_70165_t + (double)ox, this.field_70163_u + (double)oy, this.field_70161_v + (double)oz, this.field_70165_t, this.field_70161_v);
                }
            } else if (this.strikeTime > 35) {
                this.smolder();
            } else if (this.strikeTime == 35) {
                this.spawnExplosionParticles(10);
            }
        } else {
            this.moveDownToGround();
            if (this.strikeTime >= 1243 || !this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), (int)Math.round(this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))) {
                this.func_70106_y();
            } else if (this.strikeTime == 35) {
                this.damageEntityLivingBaseNearby(3.0);
            }
        }
        ++this.strikeTime;
    }

    public void moveDownToGround() {
        MovingObjectPosition rayTrace = this.rayTrace(this);
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && rayTrace.field_72310_e == 1) {
            Block hitBlock = this.field_70170_p.func_147439_a(rayTrace.field_72311_b, rayTrace.field_72312_c, rayTrace.field_72309_d);
            if (this.strikeTime > 43 && hitBlock != this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v))) {
                this.func_70106_y();
            }
            this.func_70107_b(this.field_70165_t, (float)rayTrace.field_72312_c + 1.0625f, this.field_70161_v);
            if (hitBlock instanceof BlockSlab && this.field_70170_p.func_72805_g(rayTrace.field_72311_b, rayTrace.field_72312_c, rayTrace.field_72309_d) < 8) {
                this.func_70107_b(this.field_70165_t, (float)rayTrace.field_72312_c + 1.0625f - 0.5f, this.field_70161_v);
            }
            for (EntityPlayer entityPlayer : ((WorldServer)this.field_70170_p).func_73039_n().getTrackingPlayers((Entity)this)) {
                ((EntityPlayerMP)entityPlayer).field_71135_a.func_147359_a((Packet)new S18PacketEntityTeleport((Entity)this));
            }
        }
    }

    public void damageEntityLivingBaseNearby(double radius) {
        AxisAlignedBB region = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - radius), (double)(this.field_70163_u - 0.5), (double)(this.field_70161_v - radius), (double)(this.field_70165_t + radius), (double)Double.POSITIVE_INFINITY, (double)(this.field_70161_v + radius));
        List entities = this.field_70170_p.func_72839_b((Entity)this, region);
        double radiusSq = radius * radius;
        for (Entity entity : entities) {
            if (!(entity instanceof EntityLivingBase) || !(this.func_70068_e(entity) < radiusSq) || this.caster instanceof EntityTribeLeader && entity instanceof LeaderSunstrikeImmune || this.caster instanceof EntityPlayer && entity == this.caster) continue;
            entity.func_70097_a(DamageSource.field_76370_b, 4.5f);
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.caster), 4.5f);
            entity.func_70015_d(5);
        }
    }

    private void smolder() {
        if (this.field_70146_Z.nextFloat() < 0.1f) {
            int amount = this.field_70146_Z.nextInt(2) + 1;
            while (amount-- > 0) {
                float theta = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float r = this.field_70146_Z.nextFloat() * 0.7f;
                float x = r * MathHelper.func_76134_b((float)theta);
                float z = r * MathHelper.func_76126_a((float)theta);
                this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t + (double)x, this.field_70163_u + 0.1, this.field_70161_v + (double)z, 0.0, 0.0, 0.0);
            }
        }
    }

    private void spawnExplosionParticles(int amount) {
        int i;
        for (i = 0; i < amount; ++i) {
            float velocity = 0.1f;
            float yaw = (float)i * ((float)Math.PI * 2 / (float)amount);
            float vy = this.field_70146_Z.nextFloat() * 0.08f;
            float vx = 0.1f * MathHelper.func_76134_b((float)yaw);
            float vz = 0.1f * MathHelper.func_76126_a((float)yaw);
            this.field_70170_p.func_72869_a("flame", this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v, (double)vx, (double)vy, (double)vz);
        }
        for (i = 0; i < amount / 2; ++i) {
            this.field_70170_p.func_72869_a("lava", this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v, 0.0, 0.0, 0.0);
        }
    }

    public void onSummon() {
        this.setVariant(this.field_70146_Z.nextLong());
    }

    private MovingObjectPosition rayTrace(EntitySunstrike entity) {
        Vec3 startPos = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        Vec3 endPos = Vec3.func_72443_a((double)entity.field_70165_t, (double)0.0, (double)entity.field_70161_v);
        return entity.field_70170_p.func_147447_a(startPos, endPos, false, true, true);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("strikeTime", this.strikeTime);
        compound.func_74772_a("variant", this.getVariant());
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setStrikeTime(compound.func_74762_e("strikeTime"));
        this.setVariant(compound.func_74763_f("variant"));
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.strikeTime);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.setStrikeTime(buffer.readInt());
    }
}

