/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.tribe;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.server.ai.BarakoaAttackTargetAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationRadiusAttack;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSolarBeam;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSpawnBarakoa;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSunStrike;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.tribe.EntityTribesman;
import com.bobmowzie.mowziesmobs.server.item.ItemTestStructure;
import java.util.Random;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityTribeLeader
extends MowzieEntity
implements LeaderSunstrikeImmune {
    public static final Animation DIE_ANIMATION = Animation.create((int)130);
    public static final Animation HURT_ANIMATION = Animation.create((int)13);
    public static final Animation BELLY_ANIMATION = Animation.create((int)40);
    public static final Animation TALK_ANIMATION = Animation.create((int)80);
    public static final Animation SUNSTRIKE_ANIMATION = Animation.create((int)15);
    public static final Animation ATTACK_ANIMATION = Animation.create((int)30);
    public static final Animation SPAWN_ANIMATION = Animation.create((int)20);
    public static final Animation SOLAR_BEAM_ANIMATION = Animation.create((int)100);
    private static final int MAX_HEALTH = 150;
    private static final int SUNSTRIKE_PAUSE_MAX = 40;
    private static final int SUNSTRIKE_PAUSE_MIN = 15;
    private static final int LASER_PAUSE = 230;
    private static final int BARAKOA_PAUSE = 150;
    public ControlledAnimation legsUp = new ControlledAnimation(15);
    public ControlledAnimation angryEyebrow = new ControlledAnimation(5);
    public int whichDialogue = 0;
    public int barakoaSpawnCount = 0;
    private int direction = 0;
    private boolean blocksByFeet = true;
    private int timeUntilSunstrike = 0;
    private int timeUntilLaser = 0;
    private int timeUntilBarakoa = 0;
    private boolean pacified = false;

    public EntityTribeLeader(World world) {
        super(world);
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new BarakoaAttackTargetAI(this, EntityPlayer.class, 0, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, 0, false));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityTribeLeader>(this, BELLY_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, new AnimationAI<EntityTribeLeader>(this, TALK_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, new AnimationSunStrike<EntityTribeLeader>(this, SUNSTRIKE_ANIMATION));
        this.field_70714_bg.func_75776_a(2, new AnimationRadiusAttack<EntityTribeLeader>(this, ATTACK_ANIMATION, 5.0f, 5, 4.5f, 12));
        this.field_70714_bg.func_75776_a(2, new AnimationSpawnBarakoa<EntityTribeLeader>(this, SPAWN_ANIMATION));
        this.field_70714_bg.func_75776_a(2, new AnimationSolarBeam<EntityTribeLeader>(this, SOLAR_BEAM_ANIMATION));
        this.field_70714_bg.func_75776_a(3, new AnimationTakeDamage<EntityTribeLeader>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityTribeLeader>(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityTribesman.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_70105_a(1.5f, 2.4f);
        if (this.getDirection() == 0) {
            this.setDirection(this.field_70146_Z.nextInt(4) + 1);
        }
    }

    public EntityTribeLeader(World world, int direction) {
        this(world);
        this.setDirection(direction);
    }

    public float func_70047_e() {
        return 1.4f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected String func_70639_aQ() {
        if (this.getAnimation() == NO_ANIMATION) {
            if (this.func_70638_az() == null) {
                int soundType = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1, (int)10);
                if (soundType < 7) {
                    this.func_85030_a("mowziesmobs:barakoTalk" + soundType, 1.4f, 1.0f);
                    this.setWhichDialogue(soundType);
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, TALK_ANIMATION);
                }
            } else {
                int soundType = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1, (int)10);
                if (soundType < 7) {
                    this.func_85030_a("mowziesmobs:barakoAngry" + soundType, 1.4f, 1.0f);
                }
            }
        }
        return null;
    }

    protected String func_70621_aR() {
        return "mowziesmobs:barakoHurt";
    }

    protected String func_70673_aS() {
        this.func_85030_a("mowziesmobs:barakoDie", 1.4f, 1.0f);
        return null;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.pacified) {
            this.func_70624_b(null);
        }
        if (this.field_70173_aa == 1) {
            this.direction = this.getDirection();
        }
        this.repelEntities(2.2f, 2.5f, 2.2f, 2.2f);
        this.field_70761_aq = this.field_70177_z = (float)((this.direction - 1) * 90);
        this.field_70165_t = this.field_70169_q;
        this.field_70161_v = this.field_70166_s;
        if (this.func_70638_az() != null) {
            EntityLivingBase target = this.func_70638_az();
            this.setAngry(1);
            float entityHitAngle = (float)((Math.atan2(target.field_70161_v - this.field_70161_v, target.field_70165_t - this.field_70165_t) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.field_70177_z % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = Math.abs(entityHitAngle - entityAttackingAngle);
            if (this.getAnimation() == NO_ANIMATION && this.func_110143_aJ() <= 70.0f && this.timeUntilLaser <= 0 && (entityRelativeAngle < 60.0f || entityRelativeAngle > 300.0f)) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SOLAR_BEAM_ANIMATION);
                this.timeUntilLaser = 230;
            } else if (this.getAnimation() == NO_ANIMATION && this.targetDistance <= 5.0f) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ATTACK_ANIMATION);
            } else if (this.getAnimation() == NO_ANIMATION && this.field_70146_Z.nextInt(50) == 0 && this.targetDistance > 5.0f && this.timeUntilBarakoa <= 0) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SPAWN_ANIMATION);
                this.timeUntilBarakoa = 150;
            } else if (this.getAnimation() == NO_ANIMATION && this.timeUntilSunstrike <= 0 && this.targetDistance > 5.0f) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SUNSTRIKE_ANIMATION);
                this.timeUntilSunstrike = this.getTimeUntilSunstrike();
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.setAngry(0);
        }
        if (this.field_70173_aa % 20 == 0) {
            this.blocksByFeet = this.checkBlocksByFeet();
        }
        if (this.blocksByFeet) {
            this.legsUp.increaseTimer();
        } else {
            this.legsUp.decreaseTimer();
        }
        if (this.getAngry() == 1) {
            this.angryEyebrow.increaseTimer();
        } else {
            this.angryEyebrow.decreaseTimer();
        }
        if (this.getAnimation() == NO_ANIMATION && this.func_70638_az() == null && this.field_70146_Z.nextInt(200) == 0) {
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, BELLY_ANIMATION);
        }
        if (this.getAnimation() == BELLY_ANIMATION && (this.getAnimationTick() == 9 || this.getAnimationTick() == 29)) {
            this.func_85030_a("mowziesmobs:barakoBelly", 1.4f, 1.0f);
        }
        if (this.getAnimation() == TALK_ANIMATION && this.getAnimationTick() == 1) {
            this.whichDialogue = this.getWhichDialogue();
        }
        if (this.getAnimation() == ATTACK_ANIMATION) {
            this.field_70759_as = this.field_70177_z;
            if (this.getAnimationTick() == 1) {
                this.func_85030_a("mowziesmobs:barakoBurst", 1.5f, 1.5f);
            }
            if (this.getAnimationTick() == 10) {
                if (this.field_70170_p.field_72995_K) {
                    this.spawnExplosionParticles(30);
                }
                this.func_85030_a("mowziesmobs:barakoAttack", 1.5f, 0.9f);
            }
            if (this.getAnimationTick() <= 6 && this.field_70170_p.field_72995_K) {
                int particleCount = 8;
                while (--particleCount != 0) {
                    double radius = 2.0;
                    double yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    double pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    double ox = radius * Math.sin(yaw) * Math.sin(pitch);
                    double oy = radius * Math.cos(pitch);
                    double oz = radius * Math.cos(yaw) * Math.sin(pitch);
                    double offsetX = -0.3 * Math.sin((double)this.field_70177_z * Math.PI / 180.0);
                    double offsetZ = -0.3 * Math.cos((double)this.field_70177_z * Math.PI / 180.0);
                    double offsetY = 1.0;
                    MowziesMobs.PROXY.spawnOrbFX(this.field_70170_p, this.field_70165_t + ox + offsetX, this.field_70163_u + offsetY + oy, this.field_70161_v + oz + offsetZ, this.field_70165_t + offsetX, this.field_70163_u + offsetY, this.field_70161_v + offsetZ, 6.0);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.getAnimation() != SOLAR_BEAM_ANIMATION) {
            this.func_70691_i(0.2f);
        }
        if (this.timeUntilSunstrike > 0) {
            --this.timeUntilSunstrike;
        }
        if (this.timeUntilLaser > 0) {
            --this.timeUntilLaser;
        }
        if (this.timeUntilBarakoa > 0) {
            --this.timeUntilBarakoa;
        }
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    private boolean checkBlocksByFeet() {
        Block blockRight;
        Block blockLeft;
        if (this.direction == 1) {
            blockLeft = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t) + 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) + 1);
            blockRight = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t) - 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) + 1);
        } else if (this.direction == 2) {
            blockLeft = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t) - 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) + 1);
            blockRight = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t) - 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) - 1);
        } else if (this.direction == 3) {
            blockLeft = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t) - 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) - 1);
            blockRight = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t) + 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) - 1);
        } else if (this.direction == 4) {
            blockLeft = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t) + 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) - 1);
            blockRight = this.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)this.field_70165_t) + 1, Math.round((float)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v) + 1);
        } else {
            return false;
        }
        return !(blockLeft instanceof BlockAir) || !(blockRight instanceof BlockAir);
    }

    private void spawnExplosionParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            float velocity = 0.25f;
            float yaw = (float)i * ((float)Math.PI * 2 / (float)amount);
            float vy = this.field_70146_Z.nextFloat() * 0.1f - 0.05f;
            float vx = 0.25f * MathHelper.func_76134_b((float)yaw);
            float vz = 0.25f * MathHelper.func_76126_a((float)yaw);
            this.field_70170_p.func_72869_a("flame", this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (double)vx, (double)vy, (double)vz);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(28, (Object)0);
        this.field_70180_af.func_75682_a(29, (Object)0);
        this.field_70180_af.func_75682_a(30, (Object)0);
    }

    public int getDirection() {
        return this.field_70180_af.func_75679_c(28);
    }

    public void setDirection(Integer direction) {
        this.field_70180_af.func_75692_b(28, (Object)direction);
    }

    public int getWhichDialogue() {
        return this.field_70180_af.func_75679_c(29);
    }

    public void setWhichDialogue(Integer i) {
        this.field_70180_af.func_75692_b(29, (Object)i);
    }

    public int getAngry() {
        return this.field_70180_af.func_75679_c(30);
    }

    public void setAngry(Integer i) {
        this.field_70180_af.func_75692_b(30, (Object)i);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("direction", this.getDirection());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDirection(compound.func_74762_e("direction"));
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
    }

    protected boolean func_70085_c(EntityPlayer player) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemTestStructure) {
            this.pacified = true;
        }
        return super.func_70085_c(player);
    }

    private int getTimeUntilSunstrike() {
        int damageTaken = (int)(150.0f - this.func_110143_aJ());
        if (damageTaken > 60) {
            damageTaken = 60;
        }
        return (int)(40.0f - (float)damageTaken / 60.0f * 25.0f);
    }

    public Animation[] getAnimations() {
        return new Animation[]{DIE_ANIMATION, HURT_ANIMATION, BELLY_ANIMATION, TALK_ANIMATION, SUNSTRIKE_ANIMATION, ATTACK_ANIMATION, SPAWN_ANIMATION, SOLAR_BEAM_ANIMATION};
    }
}

