/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.wroughtnaut;

import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationActivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDeactivateAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNStompAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationFWNVerticalAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityWroughtnaut
extends MowzieEntity {
    public static final Animation DIE_ANIMATION = Animation.create((int)130);
    public static final Animation HURT_ANIMATION = Animation.create((int)15);
    public static final Animation ATTACK_ANIMATION = Animation.create((int)50);
    public static final Animation VERTICAL_ATTACK_ANIMATION = Animation.create((int)105);
    public static final Animation STOMP_ATTACK_ANIMATION = Animation.create((int)40);
    public static final Animation ACTIVATE_ANIMATION = Animation.create((int)45);
    public static final Animation DEACTIVATE_ANIMATION = Animation.create((int)15);
    private static final Animation[] ANIMATIONS = new Animation[]{DIE_ANIMATION, HURT_ANIMATION, ATTACK_ANIMATION, VERTICAL_ATTACK_ANIMATION, STOMP_ATTACK_ANIMATION, ACTIVATE_ANIMATION, DEACTIVATE_ANIMATION};
    private static final String[] LIVING_SOUNDS = new String[]{"mowziesmobs:wroughtnautGrunt1", "mowziesmobs:wroughtnautGrunt3", "mowziesmobs:wroughtnautShout1", "mowziesmobs:wroughtnautShout2", "mowziesmobs:wroughtnautShout3"};
    private static final float[][] VERTICAL_ATTACK_BLOCK_OFFSETS = new float[][]{{-0.1f, -0.1f}, {-0.1f, 0.1f}, {0.1f, 0.1f}, {0.1f, -0.1f}};
    public ControlledAnimation walkAnim = new ControlledAnimation(10);
    public boolean swingDirection;
    public boolean vulnerable;
    private int attacksWithoutVertical;
    private int ticksSinceLastStomp;
    private CeilingDisturbance disturbance;

    public EntityWroughtnaut(World world) {
        super(world);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationFWNAttackAI(this, ATTACK_ANIMATION, "mowziesmobs:wroughtnautWhoosh", 4.0f, 5.5f, 100.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationFWNVerticalAttackAI(this, VERTICAL_ATTACK_ANIMATION, "mowziesmobs:wroughtnautWhoosh", 1.0f, 5.5f, 40.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationFWNStompAttackAI(this, STOMP_ATTACK_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationTakeDamage<EntityWroughtnaut>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationDieAI<EntityWroughtnaut>(this));
        this.field_70714_bg.func_75776_a(1, new AnimationActivateAI<EntityWroughtnaut>(this, ACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(1, new AnimationDeactivateAI<EntityWroughtnaut>(this, DEACTIVATE_ANIMATION));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, true));
        this.field_70728_aV = 30;
        this.func_70105_a(2.5f, 3.7f);
        this.active = false;
        this.field_70138_W = 1.0f;
    }

    @Override
    public int getAttack() {
        return 30;
    }

    public String func_70621_aR() {
        return "mowziesmobs:wroughtnautHurt1";
    }

    public String func_70673_aS() {
        this.func_85030_a("mowziesmobs:wroughtnautScream", 1.0f, 1.0f);
        return null;
    }

    protected void func_70069_a(float distance) {
        if ((distance = ForgeHooks.onLivingFall((EntityLivingBase)this, (float)distance)) <= 0.0f) {
            return;
        }
        super.func_70069_a(distance);
        PotionEffect jump = this.func_70660_b(Potion.field_76430_j);
        float jumpAid = jump != null ? (float)(jump.func_76458_c() + 1) : 0.0f;
        int damage = MathHelper.func_76123_f((float)(distance - 3.0f - jumpAid));
        if (damage > 0) {
            this.func_85030_a(this.func_146067_o(damage), 1.0f, 1.0f);
            this.func_70097_a(DamageSource.field_76379_h, damage);
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            int y = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2 - (double)this.field_70129_M));
            int z = MathHelper.func_76128_c((double)this.field_70161_v);
            Block block = this.field_70170_p.func_147439_a(x, y, z);
            if (block.func_149688_o() != Material.field_151579_a) {
                Block.SoundType step = block.field_149762_H;
                this.func_85030_a(step.func_150498_e(), step.func_150497_c() * 0.5f, step.func_150494_d() * 0.75f);
            }
        }
    }

    protected String func_70639_aQ() {
        if (this.getAnimation() == NO_ANIMATION && this.isActive()) {
            this.func_85030_a(LIVING_SOUNDS[this.field_70146_Z.nextInt(LIVING_SOUNDS.length)], 1.0f, 1.0f);
        }
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null) {
            if (this.vulnerable && source.func_76346_g() != null) {
                float entityRelativeAngle;
                int arc = 220;
                Entity entitySource = source.func_76346_g();
                float entityHitAngle = (float)((Math.atan2(entitySource.field_70161_v - this.field_70161_v, entitySource.field_70165_t - this.field_70165_t) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.field_70761_aq % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                if ((entityRelativeAngle = entityHitAngle - entityAttackingAngle) <= (float)(arc / 2) && entityRelativeAngle >= (float)(-arc / 2) || entityRelativeAngle >= (float)(360 - arc / 2) || entityRelativeAngle <= (float)(-arc + 45)) {
                    this.func_85030_a("minecraft:random.anvil_land", 0.4f, 2.0f);
                    return false;
                }
                if (this.currentAnim != null) {
                    this.currentAnim.func_75251_c();
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, NO_ANIMATION);
                }
                return super.func_70097_a(source, amount);
            }
            this.func_85030_a("minecraft:random.anvil_land", 0.4f, 2.0f);
        }
        return false;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAnimation() == NO_ANIMATION) {
                if (this.isActive()) {
                    if (this.func_70638_az() == null && this.field_70701_bs == 0.0f && Math.abs(this.field_70165_t - (double)this.getRestPosX()) <= 4.0 && Math.abs(this.field_70163_u - (double)this.getRestPosY()) <= 4.0 && Math.abs(this.field_70161_v - (double)this.getRestPosZ()) <= 4.0) {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, DEACTIVATE_ANIMATION);
                        this.setActive(false);
                    }
                } else if (this.func_70638_az() != null && this.targetDistance <= 5.0f) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ACTIVATE_ANIMATION);
                    this.setActive(true);
                }
            }
            ++this.ticksSinceLastStomp;
        }
        if (!this.isActive()) {
            this.field_70165_t = this.field_70169_q;
            this.field_70161_v = this.field_70166_s;
            this.field_70177_z = this.field_70126_B;
        }
        this.field_70761_aq = this.field_70177_z;
        if (this.func_70638_az() != null && this.isActive()) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.2);
            } else {
                this.func_70661_as().func_75499_g();
            }
            if (this.func_70638_az().field_70163_u - this.field_70163_u >= -1.0 && this.func_70638_az().field_70163_u - this.field_70163_u <= 3.0 && this.getAnimation() == NO_ANIMATION) {
                boolean couldStomp;
                boolean bl = couldStomp = this.targetDistance < 6.0f && this.ticksSinceLastStomp > 600;
                if ((double)this.targetDistance < 3.5 && Math.abs(MathHelper.func_76138_g((double)(this.getAngleBetweenEntities((Entity)this.func_70638_az(), (Entity)this) - (double)this.field_70177_z))) < 35.0 && (!couldStomp || this.field_70146_Z.nextInt(3) > 0)) {
                    if (this.attacksWithoutVertical >= 4 || this.field_70146_Z.nextInt(4) == 0) {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, VERTICAL_ATTACK_ANIMATION);
                        this.attacksWithoutVertical = 0;
                    } else {
                        AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, ATTACK_ANIMATION);
                        ++this.attacksWithoutVertical;
                    }
                } else if (couldStomp) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, STOMP_ATTACK_ANIMATION);
                    this.ticksSinceLastStomp = 0;
                    ++this.attacksWithoutVertical;
                }
            }
        } else if (!this.func_70661_as().func_75492_a((double)this.getRestPosX(), (double)this.getRestPosY(), (double)this.getRestPosZ(), 0.2)) {
            this.setRestPosX((int)this.field_70165_t);
            this.setRestPosY((int)this.field_70163_u);
            this.setRestPosZ((int)this.field_70161_v);
        }
        if (this.getAnimation() == ATTACK_ANIMATION && this.getAnimationTick() == 1) {
            this.swingDirection = this.field_70146_Z.nextBoolean();
        } else if (this.getAnimation() == ACTIVATE_ANIMATION) {
            int tick = this.getAnimationTick();
            if (tick == 1) {
                this.func_85030_a("mowziesmobs:wroughtnautGrunt2", 1.0f, 1.0f);
            } else if (tick == 27 || tick == 44) {
                this.func_85030_a("mob.zombie.metal", 0.5f, 0.5f);
            }
        } else if (this.getAnimation() == VERTICAL_ATTACK_ANIMATION && this.getAnimationTick() == 29) {
            this.doVerticalAttackHitFX();
        }
        float moveX = (float)(this.field_70165_t - this.field_70169_q);
        float moveZ = (float)(this.field_70161_v - this.field_70166_s);
        float speed = MathHelper.func_76129_c((float)(moveX * moveX + moveZ * moveZ));
        if ((double)speed > 0.01) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.walkAnim.increaseTimer();
            }
        } else {
            this.walkAnim.decreaseTimer();
        }
        if (this.getAnimation() != NO_ANIMATION) {
            this.walkAnim.decreaseTimer(2);
        }
        if (this.frame % 20 == 5 && (double)speed > 0.03 && this.getAnimation() == NO_ANIMATION && this.active) {
            this.func_85030_a("mob.zombie.metal", 0.5f, 0.5f);
        }
        this.repelEntities(2.2f, 4.0f, 2.2f, 2.2f);
        if (!this.active && this.func_70638_az() == null) {
            this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 20, 1, true));
        }
        if (this.disturbance != null && this.disturbance.update()) {
            this.disturbance = null;
        }
    }

    private void doVerticalAttackHitFX() {
        double theta = (double)(this.field_70761_aq - 4.0f) * (Math.PI / 180);
        double perpX = Math.cos(theta);
        double perpZ = Math.sin(theta);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double x = this.field_70165_t + 4.2 * vecX;
        double y = this.field_70121_D.field_72338_b + 0.1;
        double z = this.field_70161_v + 4.2 * vecZ;
        int hitY = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2));
        for (int t = 0; t < VERTICAL_ATTACK_BLOCK_OFFSETS.length; ++t) {
            int hitZ;
            float ox = VERTICAL_ATTACK_BLOCK_OFFSETS[t][0];
            float oy = VERTICAL_ATTACK_BLOCK_OFFSETS[t][1];
            int hitX = MathHelper.func_76128_c((double)(x + (double)ox));
            Block block = this.field_70170_p.func_147439_a(hitX, hitY, hitZ = MathHelper.func_76128_c((double)(z + (double)oy)));
            if (block.func_149645_b() == -1) continue;
            String particle = "blockcrack_" + Block.func_149682_b((Block)block) + "_" + this.field_70170_p.func_72805_g(hitX, hitY, hitZ);
            for (int n = 0; n < 6; ++n) {
                double pa = this.field_70146_Z.nextDouble() * 2.0 * Math.PI;
                double pd = this.field_70146_Z.nextDouble() * 0.6 + 0.1;
                double px = x + Math.cos(pa) * pd;
                double pz = z + Math.sin(pa) * pd;
                double magnitude = this.field_70146_Z.nextDouble() * 4.0 + 5.0;
                double velX = perpX * magnitude;
                double velY = this.field_70146_Z.nextDouble() * 3.0 + 6.0;
                double velZ = perpZ * magnitude;
                if (vecX * (pz - this.field_70161_v) - vecZ * (px - this.field_70165_t) > 0.0) {
                    velX = -velX;
                    velZ = -velZ;
                }
                this.field_70170_p.func_72869_a(particle, px, y, pz, velX, velY, velZ);
            }
        }
        int hitX = MathHelper.func_76128_c((double)x);
        int ceilY = MathHelper.func_76128_c((double)this.field_70121_D.field_72337_e);
        int hitZ = MathHelper.func_76128_c((double)z);
        int maxHeight = 5;
        int height = 5;
        while (height-- > 0 && !this.field_70170_p.func_147439_a(hitX, ceilY, hitZ).func_149688_o().func_76230_c()) {
            ++ceilY;
        }
        float strength = (float)height / 5.0f;
        if (strength >= 0.0f) {
            int radius = MathHelper.func_76123_f((float)(MathHelper.func_76129_c((float)(1.0f - strength * strength)) * 5.0f));
            this.disturbance = new CeilingDisturbance(hitX, ceilY, hitZ, radius, this.field_70146_Z.nextInt(5) + 3, this.field_70146_Z.nextInt(60) + 20);
        }
    }

    public void onSpawn() {
        this.setRestPosX((int)this.field_70165_t);
        this.setRestPosY((int)this.field_70163_u);
        this.setRestPosZ((int)this.field_70161_v);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.onSpawn();
        return super.func_110161_a(data);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(29, (Object)0);
        this.field_70180_af.func_75682_a(30, (Object)0);
        this.field_70180_af.func_75682_a(31, (Object)0);
        this.field_70180_af.func_75682_a(28, (Object)0);
    }

    public int getRestPosX() {
        return this.field_70180_af.func_75679_c(29);
    }

    public void setRestPosX(int restPosX) {
        this.field_70180_af.func_75692_b(29, (Object)restPosX);
    }

    public int getRestPosY() {
        return this.field_70180_af.func_75679_c(30);
    }

    public void setRestPosY(int restPosY) {
        this.field_70180_af.func_75692_b(30, (Object)restPosY);
    }

    public int getRestPosZ() {
        return this.field_70180_af.func_75679_c(31);
    }

    public void setRestPosZ(int restPosZ) {
        this.field_70180_af.func_75692_b(31, (Object)restPosZ);
    }

    public boolean isActive() {
        return this.field_70180_af.func_75683_a(28) != 0;
    }

    public void setActive(boolean isActive) {
        this.field_70180_af.func_75692_b(28, (Object)((byte)(isActive ? 1 : 0)));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("restPosX", this.getRestPosX());
        compound.func_74768_a("restPosY", this.getRestPosY());
        compound.func_74768_a("restPosZ", this.getRestPosZ());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRestPosX(compound.func_74762_e("restPosX"));
        this.setRestPosY(compound.func_74762_e("restPosY"));
        this.setRestPosZ(compound.func_74762_e("restPosZ"));
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            this.func_145779_a(ItemHandler.INSTANCE.wrought_axe, 1);
            this.func_145779_a(ItemHandler.INSTANCE.wrought_helmet, 1);
        }
        super.func_70645_a(source);
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    private class CeilingDisturbance {
        private final int ceilX;
        private final int ceilY;
        private final int ceilZ;
        private final int radius;
        private int delay;
        private int remainingTicks;
        private int duration;

        public CeilingDisturbance(int x, int y, int z, int radius, int delay, int remainingTicks) {
            this.ceilX = x;
            this.ceilY = y;
            this.ceilZ = z;
            this.radius = radius;
            this.delay = delay;
            this.remainingTicks = remainingTicks;
            this.duration = remainingTicks;
        }

        public boolean update() {
            if (--this.delay > 0) {
                return false;
            }
            float t = (float)this.remainingTicks / (float)this.duration;
            int amount = MathHelper.func_76123_f((float)((1.0f - MathHelper.func_76133_a((double)(1.0f - t * t))) * (float)this.radius * (float)this.radius * 0.15f));
            boolean playSound = true;
            while (amount-- > 0) {
                int blockZ;
                double theta = EntityWroughtnaut.this.field_70146_Z.nextDouble() * Math.PI * 2.0;
                double dist = EntityWroughtnaut.this.field_70146_Z.nextDouble() * (double)this.radius;
                double x = (double)this.ceilX + Math.cos(theta) * dist;
                double y = (double)this.ceilY - 0.1 - EntityWroughtnaut.this.field_70146_Z.nextDouble() * 0.3;
                double z = (double)this.ceilZ + Math.sin(theta) * dist;
                int blockX = MathHelper.func_76128_c((double)x);
                Block block = EntityWroughtnaut.this.field_70170_p.func_147439_a(blockX, this.ceilY, blockZ = MathHelper.func_76128_c((double)z));
                if (block.func_149645_b() == -1) continue;
                String particle = "blockdust_" + Block.func_149682_b((Block)block) + "_" + EntityWroughtnaut.this.field_70170_p.func_72805_g(blockX, this.ceilY, blockZ);
                EntityWroughtnaut.this.field_70170_p.func_72869_a(particle, x, y, z, 0.0, 0.0, 0.0);
                if (!playSound || !(EntityWroughtnaut.this.field_70146_Z.nextFloat() < 0.075f)) continue;
                Block.SoundType sound = block.field_149762_H;
                EntityWroughtnaut.this.field_70170_p.func_72980_b(EntityWroughtnaut.this.field_70165_t, EntityWroughtnaut.this.field_70163_u, EntityWroughtnaut.this.field_70161_v, sound.func_150495_a(), sound.func_150497_c() * 2.0f, sound.func_150494_d() * 0.6f, false);
                playSound = false;
            }
            return --this.remainingTicks <= 0;
        }
    }
}

