/*
 * Decompiled with CFR 0.152.
 */
package coolalias.structuregenapi.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BlockRotationData {
    private static final Map<Block, Rotation> blockRotationData = new HashMap<Block, Rotation>();

    public static final Rotation getBlockRotationType(Block block) {
        return blockRotationData.get(block);
    }

    public static final boolean registerCustomBlockRotation(Block block, Rotation rotationType) {
        return BlockRotationData.registerCustomBlockRotation(block, rotationType, false);
    }

    public static final boolean registerCustomBlockRotation(Block block, Rotation rotationType, boolean override) {
        if (blockRotationData.containsKey(block)) {
            Logger.getLogger("StructureGenAPI").warning("Block " + block + " already has a rotation type." + (override ? " Overriding previous data." : ""));
            if (override) {
                blockRotationData.remove(block);
            } else {
                return false;
            }
        }
        blockRotationData.put(block, rotationType);
        return true;
    }

    static {
        blockRotationData.put(Blocks.field_150467_bQ, Rotation.ANVIL);
        blockRotationData.put(Blocks.field_150454_av, Rotation.DOOR);
        blockRotationData.put(Blocks.field_150466_ao, Rotation.DOOR);
        blockRotationData.put(Blocks.field_150324_C, Rotation.GENERIC);
        blockRotationData.put(Blocks.field_150375_by, Rotation.GENERIC);
        blockRotationData.put(Blocks.field_150396_be, Rotation.GENERIC);
        blockRotationData.put(Blocks.field_150423_aK, Rotation.GENERIC);
        blockRotationData.put(Blocks.field_150428_aP, Rotation.GENERIC);
        blockRotationData.put(Blocks.field_150378_br, Rotation.GENERIC);
        blockRotationData.put((Block)Blocks.field_150479_bC, Rotation.GENERIC);
        blockRotationData.put((Block)Blocks.field_150486_ae, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150447_bR, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150367_z, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150409_cd, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150477_bB, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150470_am, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150460_al, Rotation.PISTON_CONTAINER);
        blockRotationData.put((Block)Blocks.field_150438_bZ, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150468_ap, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150444_as, Rotation.PISTON_CONTAINER);
        blockRotationData.put((Block)Blocks.field_150331_J, Rotation.PISTON_CONTAINER);
        blockRotationData.put((Block)Blocks.field_150326_M, Rotation.PISTON_CONTAINER);
        blockRotationData.put((Block)Blocks.field_150332_K, Rotation.PISTON_CONTAINER);
        blockRotationData.put((Block)Blocks.field_150320_F, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150408_cc, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150319_E, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150318_D, Rotation.PISTON_CONTAINER);
        blockRotationData.put(Blocks.field_150371_ca, Rotation.QUARTZ);
        blockRotationData.put(Blocks.field_150448_aq, Rotation.RAIL);
        blockRotationData.put((Block)Blocks.field_150455_bV, Rotation.REPEATER);
        blockRotationData.put((Block)Blocks.field_150441_bU, Rotation.REPEATER);
        blockRotationData.put((Block)Blocks.field_150416_aS, Rotation.REPEATER);
        blockRotationData.put((Block)Blocks.field_150413_aR, Rotation.REPEATER);
        blockRotationData.put(Blocks.field_150472_an, Rotation.SIGNPOST);
        blockRotationData.put(Blocks.field_150465_bP, Rotation.SKULL);
        blockRotationData.put(Blocks.field_150389_bf, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150387_bl, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150370_cb, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150372_bz, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150446_ar, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150390_bg, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150400_ck, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150487_bG, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150401_cl, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150481_bH, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150476_ad, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150485_bF, Rotation.STAIRS);
        blockRotationData.put(Blocks.field_150415_aT, Rotation.TRAPDOOR);
        blockRotationData.put(Blocks.field_150395_bd, Rotation.VINE);
        blockRotationData.put(Blocks.field_150442_at, Rotation.LEVER);
        blockRotationData.put(Blocks.field_150430_aB, Rotation.WALL_MOUNTED);
        blockRotationData.put(Blocks.field_150471_bO, Rotation.WALL_MOUNTED);
        blockRotationData.put(Blocks.field_150429_aA, Rotation.WALL_MOUNTED);
        blockRotationData.put(Blocks.field_150437_az, Rotation.WALL_MOUNTED);
        blockRotationData.put(Blocks.field_150478_aa, Rotation.WALL_MOUNTED);
        blockRotationData.put(Blocks.field_150364_r, Rotation.WOOD);
        blockRotationData.put(Blocks.field_150363_s, Rotation.WOOD);
    }

    public static enum Rotation {
        ANVIL,
        DOOR,
        GENERIC,
        PISTON_CONTAINER,
        QUARTZ,
        RAIL,
        REPEATER,
        SIGNPOST,
        SKULL,
        STAIRS,
        TRAPDOOR,
        VINE,
        WALL_MOUNTED,
        LEVER,
        WOOD;

    }
}

