/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether;

import com.gildedgames.util.core.SidedObject;
import com.gildedgames.util.core.UtilCore;
import com.gildedgames.util.core.nbt.NBT;
import com.gildedgames.util.core.nbt.NBTFactory;
import com.gildedgames.util.core.nbt.NBTFile;
import com.gildedgames.util.io_manager.IOCore;
import com.gildedgames.util.io_manager.exceptions.IOManagerTakenException;
import com.gildedgames.util.io_manager.factory.IOFactory;
import com.gildedgames.util.io_manager.io.IOFile;
import com.gildedgames.util.player.PlayerCore;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.UUID;
import net.aetherteam.aether.AetherConfig;
import net.aetherteam.aether.AetherCraftingHandler;
import net.aetherteam.aether.AetherEvents;
import net.aetherteam.aether.AetherFluids;
import net.aetherteam.aether.AetherGuiHandler;
import net.aetherteam.aether.AetherPickupHandler;
import net.aetherteam.aether.AetherRanks;
import net.aetherteam.aether.AetherServices;
import net.aetherteam.aether.CommonProxy;
import net.aetherteam.aether.achievements.AetherAchievements;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.client.gui.AetherOverlays;
import net.aetherteam.aether.commands.CommandColorize;
import net.aetherteam.aether.creative_tabs.AetherAccessoryTab;
import net.aetherteam.aether.creative_tabs.AetherArmorTab;
import net.aetherteam.aether.creative_tabs.AetherBlockTab;
import net.aetherteam.aether.creative_tabs.AetherCompanionTab;
import net.aetherteam.aether.creative_tabs.AetherFoodTab;
import net.aetherteam.aether.creative_tabs.AetherMaterialsTab;
import net.aetherteam.aether.creative_tabs.AetherMiscTab;
import net.aetherteam.aether.creative_tabs.AetherToolsTab;
import net.aetherteam.aether.creative_tabs.AetherWeaponsTab;
import net.aetherteam.aether.data.AetherPortalPosition;
import net.aetherteam.aether.dungeons.DungeonHandler;
import net.aetherteam.aether.dungeons.TeleporterDungeons;
import net.aetherteam.aether.dungeons.worldgen.WorldProviderDungeons;
import net.aetherteam.aether.dungeons.worldgen.rooms.DungeonRoom;
import net.aetherteam.aether.entities.AetherEntities;
import net.aetherteam.aether.items.AetherItems;
import net.aetherteam.aether.items.consumables.ItemContinuum;
import net.aetherteam.aether.packets.AetherPacketHandler;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.party.PartyController;
import net.aetherteam.aether.player.PlayerAether;
import net.aetherteam.aether.player.PlayerEventHandler;
import net.aetherteam.aether.player.PlayerTracker;
import net.aetherteam.aether.potions.AetherPotion;
import net.aetherteam.aether.recipes.AetherEnchantments;
import net.aetherteam.aether.recipes.AetherRecipes;
import net.aetherteam.aether.server.ServerTickHandler;
import net.aetherteam.aether.server.cloud_network.ServerCloudNetwork;
import net.aetherteam.aether.tile_entities.AetherTileEntities;
import net.aetherteam.aether.worldgen.BiomeGenAether;
import net.aetherteam.aether.worldgen.TeleporterAether;
import net.aetherteam.aether.worldgen.WorldProviderAether;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;

@Mod(modid="aether", name="Aether II", version="1.7.10-1.6")
public class Aether {
    public static final String MOD_ID = "aether";
    public static final String VERSION = "1.7.10-1.6";
    @Mod.Instance(value="aether")
    public static Aether instance;
    public static BiomeGenBase biome;
    public static AetherGuiHandler guiHandler;
    public static AetherCraftingHandler aetherCraftingHandler;
    public static AetherPickupHandler aetherPickupHandler;
    public static CreativeTabs blocks;
    public static CreativeTabs tools;
    public static CreativeTabs weapons;
    public static CreativeTabs armour;
    public static CreativeTabs companions;
    public static CreativeTabs accessories;
    public static CreativeTabs materials;
    public static CreativeTabs food;
    public static CreativeTabs misc;
    @SidedProxy(clientSide="net.aetherteam.aether.client.ClientProxy", serverSide="net.aetherteam.aether.CommonProxy")
    public static CommonProxy proxy;
    public static ArrayList<UUID> developers;
    public static ArrayList<UUID> helper;
    public static boolean debugMode;
    public static TeleporterAether TELEPORTER;
    public static Item.ToolMaterial LEGENDARY;
    public static ItemArmor.ArmorMaterial LEGENDARY_ARMOR;
    private static SidedObject<AetherServices> serviceLocator;
    @SideOnly(value=Side.CLIENT)
    public static boolean enableChristmasEvents;

    public static AetherServices locate() {
        return (AetherServices)serviceLocator.instance();
    }

    public static Side getAppState() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    public static boolean isClient() {
        return Aether.getAppState() == Side.CLIENT;
    }

    public static boolean isServer() {
        return Aether.getAppState() == Side.SERVER;
    }

    public static void registerBlock(Block block, String name, boolean addToContinuum) {
        Aether.registerBlock(block, name, Aether.modAddress() + name, addToContinuum);
    }

    public static void registerBlock(Block block, String name) {
        Aether.registerBlock(block, name, Aether.modAddress() + name, true);
    }

    public static void registerBlock(Block block, String name, String texture, boolean addToContinuum) {
        block.func_149663_c(name);
        block.func_149658_d(texture);
        GameRegistry.registerBlock((Block)block, (String)name);
    }

    public static void registerBlock(Block block, Class<? extends ItemBlock> itemBlock, String name, boolean addToContinuum) {
        block.func_149663_c(name);
        block.func_149658_d(Aether.modAddress() + name);
        GameRegistry.registerBlock((Block)block, itemBlock, (String)name);
        if (addToContinuum) {
            ItemContinuum.addPossibleItem(block);
        }
    }

    public static void registerBlock(Block block, Class<? extends ItemBlock> itemBlock, String name) {
        Aether.registerBlock(block, itemBlock, name, true);
    }

    public static void registerItem(Item item, String name) {
        item.func_77655_b(name);
        item.func_111206_d(Aether.modAddress() + name);
        GameRegistry.registerItem((Item)item, (String)name);
    }

    public static String modAddress() {
        return "aether:";
    }

    public static Aether getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PlayerCore.INSTANCE.registerPlayerPool(((AetherServices)serviceLocator.client()).getPool(), ((AetherServices)serviceLocator.server()).getPool());
        try {
            IOCore.io().registerManager(Aether.locate().getIOManager());
        }
        catch (IOManagerTakenException e) {
            e.printStackTrace();
        }
        AetherConfig.initProps(event.getModConfigurationDirectory());
        AetherRanks.addAllRanks();
        AetherBlocks.register();
        AetherItems.init();
        AetherAchievements.init();
        FMLCommonHandler.instance().bus().register((Object)new PlayerTracker());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTracker());
        FMLCommonHandler.instance().bus().register((Object)new ServerTickHandler());
        MapGenStructureIO.func_143031_a(DungeonRoom.class, (String)"Aether:DungeonRoom");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        AetherPacketHandler.init();
        AetherPotion.init();
        AetherEntities.init();
        AetherTileEntities.init();
        AetherEnchantments.init();
        AetherRecipes.init();
        AetherFluids.init();
        biome = new BiomeGenAether();
        DimensionManager.registerProviderType((int)Aether.getDimensionID(), WorldProviderAether.class, (boolean)true);
        DimensionManager.registerDimension((int)Aether.getDimensionID(), (int)Aether.getDimensionID());
        DimensionManager.registerProviderType((int)Aether.getDungeonDimensionID(), WorldProviderDungeons.class, (boolean)true);
        DimensionManager.registerDimension((int)Aether.getDungeonDimensionID(), (int)Aether.getDungeonDimensionID());
        proxy.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)guiHandler);
        MinecraftForge.EVENT_BUS.register((Object)aetherCraftingHandler);
        FMLCommonHandler.instance().bus().register((Object)aetherCraftingHandler);
        MinecraftForge.EVENT_BUS.register((Object)aetherPickupHandler);
        FMLCommonHandler.instance().bus().register((Object)aetherPickupHandler);
        MinecraftForge.EVENT_BUS.register((Object)new AetherEvents());
        FMLCommonHandler.instance().bus().register((Object)new AetherEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new PlayerEventHandler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandColorize());
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        TELEPORTER = new TeleporterAether(MinecraftServer.func_71276_C().func_71218_a(Aether.getDimensionID()));
        try {
            File worldDir = UtilCore.getWorldDirectory();
            NBTFactory factory = new NBTFactory();
            File partyDir = new File(worldDir, "aetherData/parties/parties_new.dat");
            File dungeonsDir = new File(worldDir, "aetherData/dungeons/dungeons.dat");
            File portalDir = new File(worldDir, "aetherData/general/portalLinks.dat");
            IOCore.io().readFile(partyDir, (IOFile)new NBTFile(partyDir, (NBT)PartyController.instance(), PartyController.instance().getClass()), (IOFactory)factory);
            IOCore.io().readFile(dungeonsDir, (IOFile)new NBTFile(dungeonsDir, (NBT)DungeonHandler.instance(), DungeonHandler.instance().getClass()), (IOFactory)factory);
            IOCore.io().readFile(portalDir, (IOFile)new NBTFile(portalDir, (NBT)TELEPORTER, ((Object)((Object)TELEPORTER)).getClass()), (IOFactory)factory);
            if (debugMode) {
                for (Party party : PartyController.instance().getPartyList()) {
                    Aether.print("Party: " + party.getName() + " Leader: " + party.getLeader().getProfile().getUsername());
                    for (PlayerAether p : party.getAllMembers()) {
                        Aether.print(p.getProfile().getUsername() + " logged in? " + p.loggedIn);
                    }
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (server != null && server.func_71262_S()) {
            ServerCloudNetwork.start();
        }
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        Aether.flushData();
        PartyController.clear();
        DungeonHandler.clear();
        if (server != null && server.func_71262_S()) {
            ServerCloudNetwork.stop();
        }
    }

    public static void flushData() {
        try {
            NBTFactory factory = new NBTFactory();
            File worldDir = UtilCore.getWorldDirectory();
            File partyDir = new File(worldDir, "aetherData/parties/parties_new.dat");
            File dungeonsDir = new File(worldDir, "aetherData/dungeons/dungeons.dat");
            File portalDir = new File(worldDir, "aetherData/general/portalLinks.dat");
            IOCore.io().writeFile(partyDir, (IOFile)new NBTFile(partyDir, (NBT)PartyController.instance(), PartyController.instance().getClass()), (IOFactory)factory);
            IOCore.io().writeFile(dungeonsDir, (IOFile)new NBTFile(dungeonsDir, (NBT)DungeonHandler.instance(), DungeonHandler.instance().getClass()), (IOFactory)factory);
            IOCore.io().writeFile(portalDir, (IOFile)new NBTFile(portalDir, (NBT)TELEPORTER, ((Object)((Object)TELEPORTER)).getClass()), (IOFactory)factory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (debugMode) {
            for (Party party : PartyController.instance().getPartyList()) {
                Aether.print("Party: " + party.getName() + " Leader: " + party.getLeader().getProfile().getUsername());
                for (PlayerAether p : party.getAllMembers()) {
                    Aether.print(p.getProfile().getUsername() + " logged in? " + p.loggedIn);
                }
            }
        }
    }

    public static void print(Object line) {
        if (debugMode && line != null) {
            System.out.println("[AETHER_II]: " + line.toString());
        }
    }

    private static void transferPlayer(EntityPlayer player, int dimID, TeleporterAether tele, boolean aboveWorld) {
        double posX = player.field_70165_t;
        double posZ = player.field_70161_v;
        Entity mount = null;
        Entity mountedBy = null;
        WorldServer server = MinecraftServer.func_71276_C().func_71218_a(dimID);
        Entity transferMount = null;
        Entity transferMountedBy = null;
        if (player.field_70154_o != null) {
            transferMount = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)player.field_70154_o), (World)server);
            transferMount.func_82141_a(player.field_70154_o, true);
            player.field_70170_p.func_72900_e(player.field_70154_o);
        }
        if (player.field_70153_n != null) {
            transferMountedBy = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)player.field_70153_n), (World)server);
            transferMountedBy.func_82141_a(player.field_70153_n, true);
            player.field_70170_p.func_72900_e(player.field_70153_n);
        }
        ServerConfigurationManager scm = MinecraftServer.func_71276_C().func_71203_ab();
        Teleporter teleporter = tele;
        if (aboveWorld) {
            teleporter = new TeleporterDungeons(MinecraftServer.func_71276_C().func_71218_a(dimID));
        }
        scm.transferPlayerToDimension((EntityPlayerMP)player, dimID, teleporter);
        if (aboveWorld) {
            player.func_70634_a(posX, 256.0, posZ);
        }
        if (transferMount != null) {
            mount = Aether.teleportMountToAether(transferMount, player, aboveWorld);
        }
        if (transferMountedBy != null) {
            transferMountedBy.func_70078_a(null);
            mountedBy = Aether.teleportMountToAether(transferMountedBy, player, aboveWorld);
        }
        if (mount != null) {
            player.func_70078_a(mount);
        }
        if (mountedBy != null) {
            mountedBy.func_70078_a((Entity)player);
        }
    }

    public static void teleportPlayerToAether(EntityPlayer player, boolean aboveWorld) {
        int posZ;
        int posY;
        int posX;
        AetherPortalPosition previousPortal;
        AetherPortalPosition linkedPortal;
        if (player.field_70170_p.field_72995_K) {
            AetherOverlays.displayFakeDownload(true);
            return;
        }
        if (aboveWorld) {
            Aether.TELEPORTER.createPortal = false;
        }
        if ((linkedPortal = TELEPORTER.getLinkedPortal(previousPortal = TELEPORTER.getPortalPosition(player.field_70170_p, posX = MathHelper.func_76128_c((double)player.field_70165_t), posY = MathHelper.func_76128_c((double)player.field_70163_u), posZ = MathHelper.func_76128_c((double)player.field_70161_v), true))) != null) {
            Aether.transferPlayer(player, linkedPortal.dimensionID, TELEPORTER, aboveWorld);
        } else if (player.field_71093_bK == Aether.getDimensionID()) {
            Aether.transferPlayer(player, 0, TELEPORTER, aboveWorld);
        } else {
            Aether.transferPlayer(player, Aether.getDimensionID(), TELEPORTER, aboveWorld);
        }
        if (!aboveWorld && !player.field_70170_p.field_72995_K) {
            Aether.TELEPORTER.createPortal = true;
        }
        player.field_71088_bW = player.func_82147_ab();
    }

    public static Entity teleportMountToAether(Entity entity, EntityPlayer player, boolean aboveWorld) {
        entity.field_71093_bK = player.field_71093_bK;
        entity.field_71088_bW = entity.func_82147_ab();
        if (aboveWorld) {
            entity.func_70107_b(player.field_70165_t, 256.0, player.field_70161_v);
        } else {
            entity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
        entity.field_98038_p = true;
        player.field_70170_p.func_72838_d(entity);
        return entity;
    }

    public static String readPage(URL url) throws Exception {
        try {
            String current;
            URLConnection urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(1000);
            HttpURLConnection connection = null;
            if (!(urlConnection instanceof HttpURLConnection)) {
                Aether.print("Please enter an HTTP URL.");
                return null;
            }
            connection = (HttpURLConnection)urlConnection;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String urlString = "";
            while ((current = in.readLine()) != null) {
                urlString = urlString + current;
            }
            return urlString;
        }
        catch (SocketTimeoutException e) {
            return "";
        }
    }

    public static boolean isGamePaused() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.func_71356_B() && mc.field_71462_r != null && mc.field_71462_r.func_73868_f() && !mc.func_71401_C().func_71344_c();
    }

    public static float minMax(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    public static int getDimensionID() {
        return AetherConfig.AetherDimensionID;
    }

    public static int getDungeonDimensionID() {
        return AetherConfig.DungeonDimensionID;
    }

    public static void setChristmasTime(boolean enable) {
        enableChristmasEvents = enable;
    }

    static {
        guiHandler = new AetherGuiHandler();
        aetherCraftingHandler = new AetherCraftingHandler();
        aetherPickupHandler = new AetherPickupHandler();
        blocks = new AetherBlockTab();
        tools = new AetherToolsTab();
        weapons = new AetherWeaponsTab();
        armour = new AetherArmorTab();
        companions = new AetherCompanionTab();
        accessories = new AetherAccessoryTab();
        materials = new AetherMaterialsTab();
        food = new AetherFoodTab();
        misc = new AetherMiscTab();
        developers = new ArrayList();
        helper = new ArrayList();
        debugMode = false;
        LEGENDARY = EnumHelper.addToolMaterial((String)"Aether_Legendary", (int)2, (int)1000, (float)8.0f, (float)2.0f, (int)14);
        LEGENDARY_ARMOR = EnumHelper.addArmorMaterial((String)"Aether_Legendary_Armor", (int)30, (int[])new int[]{2, 6, 5, 2}, (int)10);
        serviceLocator = new SidedObject((Object)new AetherServices(Side.CLIENT), (Object)new AetherServices(Side.SERVER));
    }
}

