/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether;

import com.gildedgames.util.io_manager.overhead.IOManager;
import com.gildedgames.util.io_manager.overhead.IORegistry;
import com.gildedgames.util.io_manager.util.IOManagerDefault;
import com.gildedgames.util.player.common.PlayerHookPool;
import cpw.mods.fml.relauncher.Side;
import java.util.UUID;
import net.aetherteam.aether.PlayerAetherHookFactory;
import net.aetherteam.aether.containers.inventory.InventoryAccessories;
import net.aetherteam.aether.data.AetherPortalPosition;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.dungeons.DungeonHandler;
import net.aetherteam.aether.dungeons.DungeonSliderLabyrinth;
import net.aetherteam.aether.entities.util.EntityGroup;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.party.PartyController;
import net.aetherteam.aether.player.PlayerAether;
import net.aetherteam.aether.player.abilities.Ability;
import net.aetherteam.aether.player.abilities.AbilityAccessories;
import net.aetherteam.aether.player.abilities.AbilityArmor;
import net.aetherteam.aether.player.abilities.AbilityParachute;
import net.aetherteam.aether.player.abilities.AbilityWings;
import net.aetherteam.aether.worldgen.TeleporterAether;

public class AetherServices {
    private PlayerHookPool<PlayerAether> players;
    private IOManager io;
    private static final String MANAGER_NAME = "Aether";

    public AetherServices(Side side) {
        this.players = new PlayerHookPool("aether", new PlayerAetherHookFactory(), side);
    }

    public PlayerAether get(UUID uuid) {
        return (PlayerAether)this.players.get(uuid);
    }

    public PlayerHookPool<PlayerAether> getPool() {
        return this.players;
    }

    private void startIOManager() {
        this.io = new IOManagerDefault(MANAGER_NAME);
        IORegistry registry = this.io.getRegistry();
        registry.registerClass(TeleporterAether.class, 0);
        registry.registerClass(DungeonHandler.class, 1);
        registry.registerClass(PartyController.class, 2);
        registry.registerClass(Party.class, 3);
        registry.registerClass(AetherPortalPosition.class, 4);
        registry.registerClass(Dungeon.class, 5);
        registry.registerClass(EntityGroup.class, 6);
        registry.registerClass(Ability.class, 7);
        registry.registerClass(AbilityAccessories.class, 8);
        registry.registerClass(AbilityArmor.class, 9);
        registry.registerClass(AbilityParachute.class, 10);
        registry.registerClass(AbilityWings.class, 11);
        registry.registerClass(InventoryAccessories.class, 12);
        registry.registerClass(DungeonSliderLabyrinth.class, 13);
    }

    public IOManager getIOManager() {
        if (this.io == null) {
            this.startIOManager();
        }
        return this.io;
    }
}

