/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.blocks.natural;

import java.util.List;
import java.util.Random;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.blocks.construction.BlockAetherFence;
import net.aetherteam.aether.blocks.construction.BlockAetherSlab;
import net.aetherteam.aether.entities.EntityAechorPlant;
import net.aetherteam.aether.items.AetherItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAetherGrass
extends Block
implements IGrowable {
    public static final int REQUIRED_LIGHT = 9;
    public static final int MINIMUM_LIGHT = 4;
    public static final int MAX_OPACITY = 2;
    protected IIcon top;
    protected IIcon side;

    public BlockAetherGrass() {
        super(Material.field_151577_b);
        this.func_149675_a(true);
        this.func_149711_c(0.6f);
        this.func_149672_a(Block.field_149779_h);
    }

    public IIcon getTopIcon() {
        return this.top;
    }

    public IIcon getSideIcon() {
        return this.side;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        String iconName = Aether.modAddress() + "aetherGrass";
        this.top = iconRegister.func_94245_a(iconName + "_top");
        this.side = iconRegister.func_94245_a(iconName + "_side");
    }

    public IIcon func_149691_a(int side, int blockMetadata) {
        boolean TOP = true;
        boolean BOTTOM = false;
        if (side == 1) {
            return this.getTopIcon();
        }
        if (side == 0) {
            return this.getBottomIcon(side, blockMetadata);
        }
        return this.getSideIcon();
    }

    public IIcon getBottomIcon(int side, int blockMetadata) {
        return AetherBlocks.AetherDirt.func_149691_a(side, blockMetadata);
    }

    public void func_149636_a(World world, EntityPlayer entityplayer, int x, int y, int z, int meta) {
        entityplayer.func_71064_a(StatList.field_75934_C[BlockAetherGrass.func_149682_b((Block)this)], 1);
        entityplayer.func_71020_j(0.025f);
        if (!world.field_72995_K) {
            if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() == AetherItems.SkyrootShovel) {
                if (this.canSilkHarvest(world, entityplayer, x, y, z, meta) && EnchantmentHelper.func_77502_d((EntityLivingBase)entityplayer)) {
                    entityplayer.func_71064_a(StatList.field_75934_C[BlockAetherGrass.func_149682_b((Block)this)], 1);
                    ItemStack stack = new ItemStack(AetherBlocks.AetherGrass, 1, 1);
                    this.func_149642_a(world, x, y, z, stack);
                } else {
                    entityplayer.func_71064_a(StatList.field_75934_C[BlockAetherGrass.func_149682_b((Block)this)], 1);
                    ItemStack stack = new ItemStack(AetherBlocks.AetherDirt, 2, 1);
                    this.func_149642_a(world, x, y, z, stack);
                }
            } else if (this.canSilkHarvest(world, entityplayer, x, y, z, meta) && EnchantmentHelper.func_77502_d((EntityLivingBase)entityplayer)) {
                ItemStack stack = new ItemStack(AetherBlocks.AetherGrass, 1, 1);
                this.func_149642_a(world, x, y, z, stack);
            } else {
                ItemStack stack = new ItemStack(AetherBlocks.AetherDirt, 1, 1);
                this.func_149642_a(world, x, y, z, stack);
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        Block blockAbove = world.func_147439_a(x, y + 1, z);
        int lightValueAbove = world.func_72957_l(x, y + 1, z);
        int lightOpacityAbove = world.getBlockLightOpacity(x, y + 1, z);
        if (lightValueAbove < 4 && lightOpacityAbove > 2) {
            boolean chanceToStay;
            boolean bl = chanceToStay = rand.nextInt(4) != 0;
            if (chanceToStay || blockAbove instanceof BlockWall || blockAbove instanceof BlockAetherSlab || blockAbove instanceof BlockAetherFence) {
                return;
            }
            world.func_147449_b(x, y, z, AetherBlocks.AetherDirt);
        } else if (lightValueAbove >= 9) {
            for (int growCount = 0; growCount < 4; ++growCount) {
                int x1 = x + rand.nextInt(3) - 1;
                int y1 = y + rand.nextInt(5) - 3;
                int z1 = z + rand.nextInt(3) - 1;
                Block blockNearby = world.func_147439_a(x1, y1, z1);
                lightValueAbove = world.func_72957_l(x1, y1 + 1, z1);
                lightOpacityAbove = world.getBlockLightOpacity(x1, y1 + 1, z1);
                if (blockNearby != AetherBlocks.AetherDirt || lightValueAbove < 4 || lightOpacityAbove > 2) continue;
                world.func_147449_b(x1, y1, z1, AetherBlocks.AetherGrass);
            }
        }
    }

    public Item func_149650_a(int par1, Random random, int par2) {
        return Item.func_150898_a((Block)AetherBlocks.AetherDirt);
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        return plantable.getPlantType(world, x, y - 1, z) == EnumPlantType.Plains;
    }

    public boolean func_149851_a(World p_149851_1_, int p_149851_2_, int p_149851_3_, int p_149851_4_, boolean p_149851_5_) {
        return true;
    }

    public boolean func_149852_a(World p_149852_1_, Random p_149852_2_, int p_149852_3_, int p_149852_4_, int p_149852_5_) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        block0: for (int l = 0; l < 128; ++l) {
            int i1 = x;
            int j1 = y + 1;
            int k1 = z;
            for (int l1 = 0; l1 < l / 16; ++l1) {
                if (world.func_147439_a(i1 += rand.nextInt(3) - 1, (j1 += (rand.nextInt(3) - 1) * rand.nextInt(3) / 2) - 1, k1 += rand.nextInt(3) - 1) != AetherBlocks.AetherGrass || world.func_147439_a(i1, j1, k1).func_149721_r()) continue block0;
            }
            if (world.func_147439_a(i1, j1, k1).func_149688_o() != Material.field_151579_a) continue;
            if (rand.nextInt(8) != 0) {
                if (!AetherBlocks.TallAetherGrass.func_149718_j(world, i1, j1, k1)) continue;
                world.func_147465_d(i1, j1, k1, AetherBlocks.TallAetherGrass, 1, 3);
                continue;
            }
            int choice = rand.nextInt(200);
            if (choice > 180) {
                if (choice % 2 == 0) {
                    world.func_147449_b(i1, j1, k1, AetherBlocks.BerryBush);
                } else {
                    world.func_147449_b(i1, j1, k1, AetherBlocks.BerryBushStem);
                }
            } else if (choice > 170) {
                world.func_147449_b(i1, j1, k1, AetherBlocks.BlockOrangeTree);
                world.func_72921_c(i1, j1, k1, rand.nextInt(2), 2);
            } else if (choice > 60) {
                if (choice % 2 == 0) {
                    world.func_147449_b(i1, j1, k1, AetherBlocks.WhiteRose);
                } else if (choice % 3 == 0) {
                    world.func_147449_b(i1, j1, k1, AetherBlocks.PurpleFlower);
                }
            } else {
                world.func_147449_b(i1, j1, k1, AetherBlocks.TallAetherGrass);
            }
            ++l;
        }
    }

    public float func_149712_f(World world, int x, int y, int z) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1));
        List list = world.func_72872_a(EntityAechorPlant.class, aabb);
        if (!list.isEmpty()) {
            return -1.0f;
        }
        return this.field_149782_v;
    }
}

