/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.blocks.natural;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.blocks.natural.BlockAetherFlower;
import net.aetherteam.aether.items.AetherItems;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockOrangeTree
extends BlockAetherFlower
implements IGrowable {
    private IIcon stageOne;
    private IIcon stageTwo;
    private IIcon stageThree;
    private IIcon bottomNaked;
    private IIcon topNaked;
    private IIcon bottomIcon;
    private IIcon topIcon;

    public BlockOrangeTree() {
        this.func_149711_c(1.0f);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbourBlockID) {
        super.func_149695_a(world, x, y, z, neighbourBlockID);
        this.checkTreeChange(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        super.func_149674_a(world, x, y, z, random);
        this.checkTreeChange(world, x, y, z);
        int randomGrowth = this.randomGrowthInt(world, x, y, z, random, 8);
        int meta = world.func_72805_g(x, y, z);
        if (randomGrowth == 0) {
            switch (meta) {
                case 0: {
                    world.func_147465_d(x, y, z, (Block)this, 1, 2);
                    break;
                }
                case 1: {
                    world.func_147465_d(x, y, z, (Block)this, 3, 2);
                    world.func_147465_d(x, y + 1, z, (Block)this, 2, 2);
                    break;
                }
                case 2: {
                    world.func_147465_d(x, y - 1, z, (Block)this, 3, 2);
                    world.func_147465_d(x, y, z, (Block)this, 4, 2);
                    break;
                }
                case 3: {
                    if (world.func_72805_g(x, y + 1, z) == 4) {
                        world.func_147465_d(x, y, z, (Block)this, 5, 2);
                        world.func_147465_d(x, y + 1, z, (Block)this, 6, 2);
                        break;
                    }
                    world.func_147465_d(x, y, z, (Block)this, 3, 2);
                    world.func_147465_d(x, y + 1, z, (Block)this, 4, 2);
                    break;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int i, int meta) {
        switch (meta) {
            case 0: {
                return this.stageOne;
            }
            case 1: {
                return this.stageTwo;
            }
            case 2: {
                return this.stageThree;
            }
            case 3: {
                return this.bottomNaked;
            }
            case 4: {
                return this.topNaked;
            }
            case 5: {
                return this.bottomIcon;
            }
            case 6: {
                return this.topIcon;
            }
        }
        return null;
    }

    public Item func_149650_a(int par1, Random random, int par3) {
        return null;
    }

    @Override
    public boolean func_149718_j(World world, int x, int y, int z) {
        int treeMeta = world.func_72805_g(x, y, z);
        Block soil = world.func_147439_a(x, y - 1, z);
        if (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z) && soil != null) {
            if (!(treeMeta > 1 && treeMeta != 3 && treeMeta != 5 || soil != AetherBlocks.AetherDirt && soil != AetherBlocks.AetherGrass && soil != AetherBlocks.EnchantedAetherGrass && soil != AetherBlocks.EnchantedGrass)) {
                return true;
            }
            if ((treeMeta == 2 || treeMeta == 4 || treeMeta == 6) && world.func_147439_a(x, y - 1, z) == this) {
                return true;
            }
        }
        return false;
    }

    public void func_149636_a(World world, EntityPlayer entityplayer, int x, int y, int z, int meta) {
        int max;
        int min;
        if (meta == 6 && world.func_147439_a(x, y - 1, z) == this) {
            world.func_147465_d(x, y, z, (Block)this, 4, 2);
            world.func_147465_d(x, y - 1, z, (Block)this, 3, 2);
        }
        if (meta == 5 && world.func_147439_a(x, y + 1, z) == this) {
            world.func_147465_d(x, y + 1, z, (Block)this, 4, 2);
            world.func_147465_d(x, y, z, (Block)this, 3, 2);
        }
        if ((meta == 4 || meta == 2) && world.func_147439_a(x, y - 1, z) == this) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            world.func_147449_b(x, y - 1, z, Blocks.field_150350_a);
        }
        if (world.func_147439_a(x, y - 1, z) == AetherBlocks.AetherGrass || world.func_147439_a(x, y - 2, z) == AetherBlocks.AetherGrass) {
            min = 1;
            max = 3;
        } else if (world.func_147439_a(x, y - 1, z) == AetherBlocks.EnchantedAetherGrass || world.func_147439_a(x, y - 2, z) == AetherBlocks.EnchantedAetherGrass || world.func_147439_a(x, y - 1, z) == AetherBlocks.EnchantedGrass || world.func_147439_a(x, y - 2, z) == AetherBlocks.EnchantedGrass) {
            min = 3;
            max = 6;
        } else {
            min = 1;
            max = 2;
        }
        int randomNum = Math.max(world.field_73012_v.nextInt(max), min) + 1;
        entityplayer.func_71064_a(StatList.field_75934_C[BlockOrangeTree.func_149682_b((Block)this)], 1);
        entityplayer.func_71020_j(0.025f);
        if (meta >= 5) {
            ItemStack stack = new ItemStack(AetherItems.Orange, randomNum, 0);
            this.func_149642_a(world, x, y, z, stack);
            if (meta == 5) {
                world.func_147465_d(x, y, z, (Block)this, 3, 2);
                world.func_147465_d(x, y + 1, z, (Block)this, 4, 2);
            }
        } else if (meta == 0 || meta == 1 || meta == 3) {
            ItemStack stack = new ItemStack((Block)this, 1, 0);
            this.func_149642_a(world, x, y, z, stack);
        }
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        ItemStack stack = new ItemStack((Block)this, 1, 0);
        if (meta == 6 && world.func_147439_a(x, y - 1, z) == this) {
            world.func_147465_d(x, y, z, (Block)this, 4, 2);
            world.func_147465_d(x, y - 1, z, (Block)this, 3, 2);
        }
        if (meta == 5 && world.func_147439_a(x, y + 1, z) == this) {
            world.func_147465_d(x, y + 1, z, (Block)this, 4, 2);
            world.func_147465_d(x, y, z, (Block)this, 3, 2);
        }
        if (meta == 4 && world.func_147439_a(x, y - 1, z) == this) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            world.func_147449_b(x, y - 1, z, Blocks.field_150350_a);
            this.func_149642_a(world, x, y, z, stack);
        }
        if (meta == 3 && world.func_147439_a(x, y + 1, z) == this) {
            world.func_147449_b(x, y + 1, z, Blocks.field_150350_a);
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
        if (meta == 2 && world.func_147439_a(x, y - 1, z) == this) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            world.func_147449_b(x, y - 1, z, Blocks.field_150350_a);
            this.func_149642_a(world, x, y, z, stack);
        }
        super.func_149664_b(world, x, y, z, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IIconRegister) {
        this.bottomIcon = par1IIconRegister.func_94245_a("aether:Orange Fruit Tree Bottom");
        this.topIcon = par1IIconRegister.func_94245_a("aether:Orange Fruit Tree Top");
        this.bottomNaked = par1IIconRegister.func_94245_a("aether:Orange Fruit Tree Bottom Naked");
        this.topNaked = par1IIconRegister.func_94245_a("aether:Orange Fruit Tree Top Naked");
        this.stageOne = par1IIconRegister.func_94245_a("aether:Orange Tree Stage One");
        this.stageTwo = par1IIconRegister.func_94245_a("aether:Orange Tree Stage Two");
        this.stageThree = par1IIconRegister.func_94245_a("aether:Orange Tree Top Stage Three");
    }

    public int randomGrowthInt(World world, int x, int y, int z, Random random, int randomint) {
        if (world.func_147439_a(x, y - 2, z) == AetherBlocks.AetherGrass && world.func_72805_g(x, y - 2, z) == 2 || world.func_147439_a(x, y - 1, z) == AetherBlocks.AetherGrass && world.func_72805_g(x, y - 1, z) == 2) {
            return random.nextInt(randomint / 2);
        }
        return random.nextInt(randomint);
    }

    protected final void checkTreeChange(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            int treeMeta = world.func_72805_g(x, y, z);
            world.func_147468_f(x, y, z);
            Block above = world.func_147439_a(x, y + 1, z);
            Block below = world.func_147439_a(x, y - 1, z);
            if (above == this) {
                world.func_147468_f(x, y + 1, z);
            }
            if (treeMeta == 5) {
                int max;
                int min;
                if (below == AetherBlocks.AetherGrass) {
                    min = 1;
                    max = 3;
                } else {
                    min = 3;
                    max = 6;
                }
                int randomNum = MathHelper.func_76125_a((int)world.field_73012_v.nextInt(), (int)max, (int)min) + 1;
                if (randomNum != 0) {
                    ItemStack stack = new ItemStack(AetherItems.Orange, randomNum, 0);
                    this.func_149642_a(world, x, y, z, stack);
                }
            } else if ((treeMeta <= 1 || treeMeta == 3) && above == this && below == Blocks.field_150350_a) {
                ItemStack stack = new ItemStack((Block)this, 1, 0);
                this.func_149642_a(world, x, y, z, stack);
            }
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149851_a(World p_149851_1_, int p_149851_2_, int p_149851_3_, int p_149851_4_, boolean p_149851_5_) {
        return true;
    }

    public boolean func_149852_a(World p_149852_1_, Random p_149852_2_, int p_149852_3_, int p_149852_4_, int p_149852_5_) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                world.func_147465_d(x, y, z, AetherBlocks.BlockOrangeTree, 1, 2);
                break;
            }
            case 1: {
                world.func_147465_d(x, y, z, AetherBlocks.BlockOrangeTree, 3, 2);
                world.func_147465_d(x, y + 1, z, AetherBlocks.BlockOrangeTree, 2, 2);
                break;
            }
            case 2: {
                world.func_147465_d(x, y - 1, z, AetherBlocks.BlockOrangeTree, 3, 2);
                world.func_147465_d(x, y, z, AetherBlocks.BlockOrangeTree, 4, 2);
                break;
            }
            case 3: {
                if (world.func_72805_g(x, y + 1, z) == 4) {
                    world.func_147465_d(x, y, z, AetherBlocks.BlockOrangeTree, 5, 2);
                    world.func_147465_d(x, y + 1, z, AetherBlocks.BlockOrangeTree, 6, 2);
                    break;
                }
                world.func_147465_d(x, y, z, AetherBlocks.BlockOrangeTree, 3, 2);
                world.func_147465_d(x, y + 1, z, AetherBlocks.BlockOrangeTree, 4, 2);
                break;
            }
        }
    }
}

