/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.client.audio;

import com.gildedgames.util.menu.MenuCore;
import com.gildedgames.util.menu.client.IMenu;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Random;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.client.audio.AetherSoundHandler;
import net.aetherteam.aether.client.audio.sounds.AetherUnpositionedSound;
import net.aetherteam.aether.enums.EnumBossType;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;

public class AetherMusicTicker {
    public static final AetherMusicTicker instance = new AetherMusicTicker();
    private final ResourceLocation AETHER_DAY_MUSIC = new ResourceLocation("aether:music.day");
    private final ResourceLocation AETHER_NIGHT_MUSIC = new ResourceLocation("aether:music.night");
    private final ResourceLocation MINIBOSS_MUSIC = new ResourceLocation("aether:music.miniboss");
    private final ResourceLocation BOSS_MUSIC = new ResourceLocation("aether:music.boss");
    private final ResourceLocation DUNGEON_AMBIENCE_MUSIC = new ResourceLocation("aether:music.ambience");
    private final ResourceLocation AETHER_MENU_MUSIC = new ResourceLocation("aether:menu.aetherii");
    private final SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
    private AetherUnpositionedSound aetherMusic;
    private AetherUnpositionedSound bossMusic;
    private AetherUnpositionedSound dungeonAmbienceMusic;
    private ISound playingRecord;
    private ISound prevMcMenuMusic;
    private ISound mcMenuMusic;
    private final Random random = new Random();
    private int tickCount;
    private int minTicks = 600;
    private String prevMenuID;

    @SubscribeEvent
    public void onClientStartsSound(PlaySoundEvent17 event) {
        if (event.category == SoundCategory.MUSIC) {
            if (!(event.sound instanceof AetherUnpositionedSound) && !event.sound.func_147650_b().func_110624_b().equals("aether")) {
                if (Minecraft.func_71410_x().func_147109_W() == MusicTicker.MusicType.MENU) {
                    event.result = null;
                } else if (this.isValidDimension((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    event.result = null;
                }
            }
        } else if (event.category == SoundCategory.RECORDS) {
            this.playingRecord = event.sound;
            this.soundHandler.func_147683_b((ISound)this.aetherMusic);
            this.aetherMusic = null;
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player;
        AetherSoundHandler.tick();
        if (this.playingRecord != null && !this.soundHandler.func_147692_c(this.playingRecord)) {
            this.playingRecord = null;
        }
        if (this.isValidDimension((EntityPlayer)(player = Minecraft.func_71410_x().field_71439_g)) && !this.isPlayingRecord() && !Minecraft.func_71410_x().func_147113_T()) {
            PlayerAether aetherPlayer = PlayerAether.get((EntityPlayer)player);
            long worldTime = player.field_70170_p.func_72820_D();
            if (player.field_71093_bK == Aether.getDimensionID()) {
                if (!this.soundHandler.func_147692_c((ISound)this.aetherMusic)) {
                    if (this.tickCount >= this.minTicks) {
                        this.tickCount = -3000 - this.random.nextInt(1200);
                        this.aetherMusic = new AetherUnpositionedSound(this.getAetherMusic(worldTime));
                        this.soundHandler.func_147682_a((ISound)this.aetherMusic);
                    } else {
                        ++this.tickCount;
                    }
                }
            } else if (player.field_71093_bK == Aether.getDungeonDimensionID()) {
                if (aetherPlayer.getCurrentBoss() != null) {
                    if (!this.soundHandler.func_147692_c((ISound)this.bossMusic)) {
                        this.bossMusic = aetherPlayer.getCurrentBoss().getBossType() == EnumBossType.BOSS ? new AetherUnpositionedSound(this.BOSS_MUSIC, true) : new AetherUnpositionedSound(this.MINIBOSS_MUSIC, true);
                        this.soundHandler.func_147682_a((ISound)this.bossMusic);
                    }
                    if (this.soundHandler.func_147692_c((ISound)this.dungeonAmbienceMusic)) {
                        this.dungeonAmbienceMusic.fadeToVolume(0.0f);
                    }
                } else {
                    if (!this.soundHandler.func_147692_c((ISound)this.dungeonAmbienceMusic)) {
                        this.dungeonAmbienceMusic = new AetherUnpositionedSound(this.DUNGEON_AMBIENCE_MUSIC, true);
                        this.soundHandler.func_147682_a((ISound)this.dungeonAmbienceMusic);
                    }
                    if (this.soundHandler.func_147692_c((ISound)this.bossMusic)) {
                        this.bossMusic.fadeToVolume(0.0f);
                    }
                }
            }
        } else if (Minecraft.func_71410_x().func_147109_W() == MusicTicker.MusicType.MENU) {
            IMenu menu = MenuCore.locate().getCurrentMenu();
            if (menu == null || !menu.getID().equals(this.prevMenuID) || !this.soundHandler.func_147692_c(this.mcMenuMusic)) {
                this.prevMcMenuMusic = this.mcMenuMusic;
                this.mcMenuMusic = null;
                String string = this.prevMenuID = menu == null ? null : menu.getID();
            }
            if (this.soundHandler.func_147692_c(this.prevMcMenuMusic)) {
                this.soundHandler.func_147683_b(this.prevMcMenuMusic);
            } else if (menu != null) {
                this.prevMcMenuMusic = null;
                if (this.mcMenuMusic == null) {
                    this.mcMenuMusic = menu.getID().equals("aether") ? new AetherUnpositionedSound(this.AETHER_MENU_MUSIC) : new AetherUnpositionedSound(new ResourceLocation("minecraft:music.menu"));
                    this.soundHandler.func_147682_a(this.mcMenuMusic);
                }
            }
        }
    }

    private boolean isPlayingRecord() {
        return this.soundHandler.func_147692_c(this.playingRecord);
    }

    private boolean isValidDimension(EntityPlayer player) {
        return player != null && (player.field_71093_bK == Aether.getDimensionID() || player.field_71093_bK == Aether.getDungeonDimensionID());
    }

    private ResourceLocation getAetherMusic(long worldTime) {
        if (worldTime < 12800L || worldTime > 22300L) {
            return this.AETHER_DAY_MUSIC;
        }
        return this.AETHER_NIGHT_MUSIC;
    }
}

