/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.client.gui;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.aetherteam.aether.Aether;
import net.aetherteam.aether.blocks.AetherBlocks;
import net.aetherteam.aether.client.SkinManager;
import net.aetherteam.aether.client.gui.util.GuiFakeDownloadTerrain;
import net.aetherteam.aether.data.AetherOptions;
import net.aetherteam.aether.dungeons.Dungeon;
import net.aetherteam.aether.entities.bosses.EntityBossMob;
import net.aetherteam.aether.entities.mounts.moa.EntityMoa;
import net.aetherteam.aether.enums.EnumBossType;
import net.aetherteam.aether.items.AetherItems;
import net.aetherteam.aether.notifications.NotificationHandler;
import net.aetherteam.aether.party.MemberType;
import net.aetherteam.aether.party.Party;
import net.aetherteam.aether.player.PlayerAether;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AetherOverlays {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static final ResourceLocation TEXTURE_JUMPS = new ResourceLocation("aether", "textures/gui/jumps.png");
    private static final ResourceLocation TEXTURE_BOSS_HP_BAR = new ResourceLocation("aether", "textures/gui/bossHPBar.png");
    private static final ResourceLocation TEXTURE_PARTYICONS = new ResourceLocation("aether", "textures/gui/partyicons.png");
    private static final ResourceLocation TEXTURE_COINBAR = new ResourceLocation("aether", "textures/gui/coinbar.png");
    private static final ResourceLocation TEXTURE_MOUNT_HEALTH_BAR = new ResourceLocation("aether", "textures/gui/mountHealthBar.png");
    private static final ResourceLocation TEXTURE_COOLDOWN_BAR = new ResourceLocation("aether", "textures/gui/cooldownBar.png");
    private static long slideTime;
    private static boolean hasSlided;
    private static int prevCoinCount;
    private static float scale;
    private static int partyAmount;
    private static boolean dirty;
    private static float bossStaticHP;
    private static float linearDecrement;
    private static int bossPrevHP;
    private static int diff;
    private static int init;

    @SideOnly(value=Side.CLIENT)
    public static void renderIronBubbles(Minecraft mc, Random rand) {
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        PlayerAether player = PlayerAether.get((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        mc.field_71446_o.func_110577_a(Gui.field_110324_m);
        int bubbleAmount = player.getAccessoryCount(AetherItems.IronBubble);
        if (mc.field_71442_b.func_78755_b() && player.entityPlayer.func_70090_H() && player.entityPlayer.func_70055_a(Material.field_151586_h)) {
            for (int i = 0; i < bubbleAmount; ++i) {
                AetherOverlays.drawTexturedModalRect(width / 2 - 8 * i + 81, height - 49, 16.0f, 18.0f, 9.0f, 9.0f);
            }
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderCooldown(Minecraft mc) {
        PlayerAether playerInfo = PlayerAether.get((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
        if (playerInfo.getCooldown() != 0) {
            ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int width = scaledresolution.func_78326_a();
            String name = playerInfo.getCooldownName().replace("item.aether:", "").replace(".name", "");
            mc.field_71466_p.func_78261_a(name + " Cooldown", width / 2 - mc.field_71466_p.func_78256_a(name + " Cooldown") / 2, 32 + (playerInfo.getCurrentBoss() != null ? 20 : 0), -1);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3008);
            mc.field_71446_o.func_110577_a(TEXTURE_COOLDOWN_BAR);
            AetherOverlays.drawTexturedModalRect(width / 2 - 64, 42 + (playerInfo.getCurrentBoss() != null ? 20 : 0), 0.0f, 8.0f, 128.0f, 8.0f);
            int w = (int)((float)playerInfo.getCooldown() / (float)playerInfo.getCooldownMax() * 128.0f);
            AetherOverlays.drawTexturedModalRect(width / 2 - 64, 42 + (playerInfo.getCurrentBoss() != null ? 20 : 0), 0.0f, 0.0f, w, 8.0f);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderCoinbar(Minecraft mc) {
        PlayerAether player = PlayerAether.get((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = scaledresolution.func_78326_a();
        if (prevCoinCount != player.getAetherCoins()) {
            prevCoinCount = player.getAetherCoins();
            slideTime = Minecraft.func_71386_F();
            hasSlided = false;
        }
        if (slideTime != 0L) {
            double d0 = (double)(Minecraft.func_71386_F() - slideTime) / 3000.0;
            if (!hasSlided && (d0 < 0.0 || d0 > 1.0)) {
                slideTime = 0L;
            } else {
                int dynamicY;
                hasSlided = true;
                double d1 = d0 * 2.0;
                if (d1 > 1.0) {
                    d1 = 2.0 - d1;
                }
                d1 *= 4.0;
                if ((d1 = 1.0 - d1) < 0.0) {
                    d1 = 0.0;
                }
                d1 *= d1;
                d1 *= d1;
                int n = dynamicY = AetherOptions.getSlideCoinbar() ? 0 - (int)(d1 * 36.0) : 0;
                if (mc.field_71462_r == null) {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glDisable((int)2929);
                    GL11.glDepthMask((boolean)false);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glDisable((int)3008);
                    int coinAmount = player.getAetherCoins();
                    mc.field_71446_o.func_110577_a(TEXTURE_COINBAR);
                    AetherOverlays.drawTexturedModalRect(width / 2 - 35, dynamicY, 0.0f, 0.0f, 71.0f, 15.0f);
                    AetherOverlays.drawTexturedModalRect(width / 2 - (mc.field_71466_p.func_78256_a("x" + String.valueOf(coinAmount)) / 2 + 3) - 5, dynamicY + 1, 0.0f, 15.0f, 10.0f, 10.0f);
                    mc.field_71466_p.func_78261_a("x", width / 2 - (mc.field_71466_p.func_78256_a("x" + String.valueOf(coinAmount)) / 2 + 2) + 6, dynamicY + 1, -1);
                    mc.field_71466_p.func_78261_a(String.valueOf(coinAmount), width / 2 - (mc.field_71466_p.func_78256_a("x" + String.valueOf(coinAmount)) / 2 + 2) + 13, dynamicY + 2, -1);
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    public static void renderPartyHUD(Minecraft mc) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        boolean minimalistic = AetherOptions.getMinimalPartyHUD();
        boolean renderHead = AetherOptions.getRenderHead();
        boolean showHUD = AetherOptions.getShowPartyHUD();
        boolean showName = AetherOptions.getShowPartyName();
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = scaledresolution.func_78326_a();
        int notificationSize = NotificationHandler.instance().getNotifications().size();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        if (notificationSize > 0) {
            mc.field_71446_o.func_110577_a(TEXTURE_COINBAR);
            AetherOverlays.drawTexturedModalRect(width / 2 + 37, 2.0f, 20.0f, 25.0f, 31.0f, 9.0f);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        if (showHUD) {
            int xNegOffset = renderHead ? 0 : -18;
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3008);
            PlayerAether playerInfo = PlayerAether.get((EntityPlayer)mc.field_71439_g);
            Party party = playerInfo.getParty();
            if (party != null) {
                GL11.glPushMatrix();
                GL11.glScalef((float)0.75f, (float)0.75f, (float)1.0f);
                int serverPlayerAmount = mc.field_71439_g.field_71174_a.field_147303_b.size();
                if (showName && serverPlayerAmount > 1) {
                    mc.field_71466_p.func_78261_a("\u00a7nParty:\u00a7r " + party.getName(), 2, 59, 0xE5E5E5);
                }
                GL11.glPopMatrix();
                int count = 0;
                for (PlayerAether member : party.getOnlineMembers()) {
                    if (!member.loggedIn || member.entityPlayer == null || count + 1 >= party.getMemberSizeLimit() || member == playerInfo) continue;
                    AetherOverlays.drawPlayerSlot(member, xNegOffset, 50 + 20 * count + 2 * partyAmount, mc, minimalistic, renderHead);
                    ++count;
                }
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
            GL11.glEnable((int)3008);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public static void renderDungeonHUD(Minecraft mc) {
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = scaledresolution.func_78326_a();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        Dungeon dungeon = PlayerAether.get((EntityPlayer)mc.field_71439_g).getDungeon();
        if (dungeon != null && mc.field_71439_g.field_71093_bK == Aether.getDungeonDimensionID()) {
            FontRenderer font = mc.field_71466_p;
            if (dungeon.conquered) {
                String conqueredText = "DUNGEON CONQUERED";
                int centerOffset = font.func_78256_a(conqueredText) / 2;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(width - 25 - centerOffset), (float)12.0f, (float)1.0f);
                GL11.glScalef((float)0.7f, (float)0.7f, (float)1.0f);
                mc.field_71466_p.func_78261_a(conqueredText, 0, 0, 14614785);
                GL11.glPopMatrix();
            } else if (dungeon.getKeyFragments() >= 0) {
                int keyWidth = 16;
                int keyLength = 16;
                String keyAmount = String.valueOf(dungeon.getKeyFragments()) + "/" + 3;
                int centerOffset = (keyWidth * 3 / 2 + font.func_78256_a(keyAmount) / 2) / 3;
                AetherOverlays.drawIcon(0.6f, width - 38 - centerOffset, 10.0f, 39.0f, 0.0f, keyWidth, keyLength);
                AetherOverlays.drawIcon(0.6f, width - 38 - centerOffset, 10.0f, 39 + dungeon.getKeyFragments() * keyWidth, 0.0f, keyWidth, keyLength);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(width - 35 + 8 - centerOffset), (float)12.0f, (float)1.0f);
                GL11.glScalef((float)0.7f, (float)0.7f, (float)1.0f);
                mc.field_71466_p.func_78261_a(keyAmount, 0, 0, 0xE5E5E5);
                GL11.glPopMatrix();
            }
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void drawPlayerSlot(PlayerAether playerInfo, int x, int y, Minecraft mc, boolean minimalistic, boolean renderHead) {
        if (playerInfo != null) {
            scale = 1.35f - 0.025f * (float)partyAmount;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            SkinManager.instance.bindSkin(playerInfo.getUsername());
            GL11.glEnable((int)3553);
            GL11.glPushMatrix();
            if (renderHead) {
                float u = 0.125f;
                float v = 0.25f;
                float u1 = 0.25f;
                float v1 = 0.5f;
                GL11.glScalef((float)(0.8f * scale), (float)(0.8f * scale), (float)1.0f);
                GL11.glBegin((int)7);
                GL11.glTexCoord2f((float)u, (float)v);
                GL11.glVertex2f((float)(x + 2), (float)(y + 2));
                GL11.glTexCoord2f((float)u, (float)v1);
                GL11.glVertex2f((float)(x + 2), (float)(y + 18));
                GL11.glTexCoord2f((float)u1, (float)v1);
                GL11.glVertex2f((float)(x + 18), (float)(y + 18));
                GL11.glTexCoord2f((float)u1, (float)v);
                GL11.glVertex2f((float)(x + 18), (float)(y + 2));
                GL11.glEnd();
            }
            if (!minimalistic) {
                AetherOverlays.drawHealthBar(x + 21, y + 8, (int)playerInfo.getHealth(), (int)playerInfo.getMaxHealth());
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x + 22), (float)(y + 2), (float)1.0f);
            GL11.glScalef((float)(0.5f * scale), (float)(0.5f * scale), (float)1.0f);
            String coins = String.valueOf(playerInfo.getAetherCoins());
            String hungerPercent = String.valueOf(playerInfo.entityPlayer.func_71024_bL().func_75116_a() / 20 * 100) + "%";
            String armour = playerInfo.getTotalArmorValue() + "/" + 20;
            mc.field_71466_p.func_78261_a(playerInfo.getProfile().getUsername(), 0, 0, playerInfo.getPartyMemberType() == MemberType.LEADER ? 0xFFCC00 : 0xE5E5E5);
            GL11.glPushMatrix();
            if (!minimalistic) {
                GL11.glTranslatef((float)4.5f, (float)4.0f, (float)1.0f);
                GL11.glScalef((float)0.8f, (float)0.8f, (float)1.0f);
            }
            String hearts = (int)playerInfo.getHealth() + "/" + (int)playerInfo.getMaxHealth();
            mc.field_71466_p.func_78261_a(hearts, minimalistic ? 12 : 44 - mc.field_71466_p.func_78256_a(hearts) / 2, minimalistic ? 10 : 7, 0xE5E5E5);
            mc.field_71466_p.func_78261_a(hungerPercent, minimalistic ? 11 : 52, minimalistic ? 20 : 17, 0xE5E5E5);
            if (!minimalistic) {
                mc.field_71466_p.func_78261_a(armour, 7, 17, 0xE5E5E5);
            }
            GL11.glPopMatrix();
            mc.field_71466_p.func_78261_a(coins, minimalistic ? 49 : mc.field_71466_p.func_78256_a(playerInfo.getProfile().getUsername()) + 17, minimalistic ? 20 : 0, 0xE5E5E5);
            if (minimalistic) {
                mc.field_71466_p.func_78261_a(armour, 56, 10, 0xE5E5E5);
            }
            if (minimalistic) {
                AetherOverlays.drawIcon(1.1f, 0.0f, 10.0f, 18.0f, 0.0f, 9.0f, 9.0f);
                AetherOverlays.drawIcon(1.1f, 44.0f, 10.0f, 9.0f, 0.0f, 9.0f, 9.0f);
                AetherOverlays.drawIcon(1.1f, 0.0f, 20.0f, 0.0f, 0.0f, 9.0f, 9.0f);
                AetherOverlays.drawIcon(0.75f, 38.0f, 20.0f, 27.0f, 0.0f, 12.0f, 12.0f);
            } else {
                AetherOverlays.drawIcon(0.85f, 36.0f, 17.0f, 0.0f, 0.0f, 9.0f, 9.0f);
                AetherOverlays.drawIcon(0.85f, 0.0f, 17.0f, 9.0f, 0.0f, 9.0f, 9.0f);
                AetherOverlays.drawIcon(0.75f, mc.field_71466_p.func_78256_a(playerInfo.getProfile().getUsername()) + 6, 0.0f, 27.0f, 0.0f, 12.0f, 12.0f);
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    public static void drawIcon(float scale, float x, float y, float u, float v, float width, float height) {
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        mc.field_71446_o.func_110577_a(TEXTURE_PARTYICONS);
        GL11.glTranslatef((float)x, (float)(y - 0.5f), (float)1.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        AetherOverlays.drawTexturedModalRect(0.0f, 0.0f, u, v, width, height);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void drawHealthBar(float x, float y, int health, int maxHealth) {
        Minecraft mc = Minecraft.func_71410_x();
        float textureWidth = 77.0f;
        float textureHeight = 6.0f;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        mc.field_71446_o.func_110577_a(TEXTURE_MOUNT_HEALTH_BAR);
        GL11.glTranslatef((float)x, (float)y, (float)1.0f);
        GL11.glScalef((float)(0.525f * scale), (float)(0.525f * scale), (float)1.0f);
        AetherOverlays.drawTexturedModalRect(0.0f, 0.0f, 0.0f, textureHeight, textureWidth, textureHeight);
        float mountMaxHealth = maxHealth;
        float mountHealth = health;
        int healthProgress = (int)(mountHealth / mountMaxHealth * textureWidth);
        AetherOverlays.drawTexturedModalRect(0.0f, 0.0f, 0.0f, 0.0f, healthProgress, textureHeight);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBossHP(Minecraft mc) {
        PlayerAether playerInfo = PlayerAether.get((EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g);
        EntityBossMob bossMob = playerInfo.getCurrentBoss();
        if (bossMob == null || bossMob.field_70128_L || bossMob.func_110143_aJ() <= 0.0f) {
            return;
        }
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = scaledresolution.func_78326_a();
        String bossTitle = "\u00a7o" + bossMob.getBossTitle();
        int nameOffset = mc.field_71466_p.func_78256_a(bossTitle) / 2;
        String bossTypeString = "";
        mc.field_71446_o.func_110577_a(TEXTURE_BOSS_HP_BAR);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float health = bossMob.func_110143_aJ() / bossMob.func_110138_aP() * 256.0f;
        int offset1 = 0;
        int offset2 = 0;
        int offset4 = 0;
        boolean x = false;
        int y = 0;
        if (bossMob.getBossType() != null) {
            boolean isFinal;
            boolean bl = isFinal = bossMob.getBossType() == EnumBossType.BOSS;
            if (isFinal) {
                AetherOverlays.drawTexturedModalRect(width / 2 - 49, 10.0f, 1.0f, 57.0f, 96.0f, 58.0f);
            }
            bossTypeString = "\u00a7o" + (isFinal ? "Final" : "Mini") + " Boss";
            offset1 = isFinal ? 45 : 24;
            offset2 = isFinal ? -10 : 11;
            offset4 = mc.field_71466_p.func_78256_a(bossTypeString) / 2;
            y = isFinal ? 0 : 14;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AetherOverlays.drawTexturedModalRect(width / 2 - 128, 32 - offset2, (float)x, 28.0f, 256.0f, 14.0f);
        if (bossMob.func_110143_aJ() != (float)bossPrevHP && !dirty) {
            dirty = true;
            bossStaticHP = bossPrevHP;
            diff = bossPrevHP - (int)bossMob.func_110143_aJ();
            linearDecrement = diff;
            bossPrevHP = (int)bossMob.func_110143_aJ();
        }
        if (dirty) {
            float staticHealth = bossStaticHP / bossMob.func_110138_aP() * 256.0f;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AetherOverlays.drawTexturedModalRect(width / 2 - 128, 32 - offset2, (float)x, 42.0f, staticHealth, 14.0f);
            if (init > 25) {
                if (bossStaticHP > (float)bossPrevHP) {
                    bossStaticHP -= linearDecrement / 50.0f;
                    linearDecrement -= (float)(diff / 5);
                    diff /= 5;
                } else {
                    dirty = false;
                    diff = 0;
                    init = 0;
                }
            } else {
                ++init;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AetherOverlays.drawTexturedModalRect(width / 2 - 128, 32 - offset2, (float)x, y, health, 14.0f);
        mc.field_71466_p.func_78261_a(bossTitle, width / 2 - nameOffset, offset1, 0x67FFFFFF);
        mc.field_71466_p.func_78261_a(bossTypeString, width / 2 - offset4, offset1 + 14, 0x67FFFFFF);
        bossPrevHP = (int)bossMob.func_110143_aJ();
        GL11.glDisable((int)3042);
    }

    public static void renderJumps(Minecraft mc) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (player == null || player.field_70154_o == null || !(player.field_70154_o instanceof EntityMoa)) {
            return;
        }
        ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        EntityMoa moa = (EntityMoa)player.field_70154_o;
        int width = scaledresolution.func_78326_a();
        GL11.glPushMatrix();
        mc.field_71446_o.func_110577_a(TEXTURE_JUMPS);
        GL11.glEnable((int)3042);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        for (int jump = 0; jump < moa.getMaxJumps(); ++jump) {
            int yPos = 18;
            int xPos = width / 2 + jump * 8 - moa.getMaxJumps() * 8 / 2;
            if (jump < moa.getRemainingJumps()) {
                AetherOverlays.drawTexturedModalRect(xPos, yPos, 0.0f, 0.0f, 9.0f, 11.0f);
                continue;
            }
            AetherOverlays.drawTexturedModalRect(xPos, yPos, 10.0f, 0.0f, 9.0f, 11.0f);
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawTexturedModalRect(float x, float y, float u, float v, float width, float height) {
        float zLevel = -90.0f;
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)(x + 0.0f), (double)(y + height), (double)zLevel, (double)((u + 0.0f) * var7), (double)((v + height) * var8));
        var9.func_78374_a((double)(x + width), (double)(y + height), (double)zLevel, (double)((u + width) * var7), (double)((v + height) * var8));
        var9.func_78374_a((double)(x + width), (double)(y + 0.0f), (double)zLevel, (double)((u + width) * var7), (double)((v + 0.0f) * var8));
        var9.func_78374_a((double)(x + 0.0f), (double)(y + 0.0f), (double)zLevel, (double)((u + 0.0f) * var7), (double)((v + 0.0f) * var8));
        var9.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderAetherPortalHUD(float par1, int par2, int par3, Minecraft mc) {
        if (par1 < 1.0f) {
            par1 *= par1;
            par1 *= par1;
            par1 = par1 * 0.8f + 0.2f;
        }
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)par1);
        IIcon icon = AetherBlocks.AetherPortal.func_149733_h(1);
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        float f1 = icon.func_94209_e();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94212_f();
        float f4 = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)par3, -90.0, (double)f1, (double)f4);
        tessellator.func_78374_a((double)par2, (double)par3, -90.0, (double)f3, (double)f4);
        tessellator.func_78374_a((double)par2, 0.0, -90.0, (double)f3, (double)f2);
        tessellator.func_78374_a(0.0, 0.0, -90.0, (double)f1, (double)f2);
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void displayFakeDownload(boolean display) {
        if (display) {
            mc.func_147108_a((GuiScreen)new GuiFakeDownloadTerrain());
        } else {
            mc.func_147108_a(null);
        }
    }

    static {
        scale = 1.0f;
        partyAmount = 0;
    }
}

