/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.client.gui.cloud;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import net.aetherteam.aether.client.gui.cloud.RemoteCloudServer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class FetchCloudsCallable
implements Callable<List<RemoteCloudServer>> {
    private static final String FETCH_URL = "http://gilded-games.com/cloudnetwork/getClouds?version=%s";
    private static final RequestConfig httpConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(5000).build();
    private final JsonParser parser = new JsonParser();
    private final HttpClient httpClient = HttpClients.createDefault();

    @Override
    public List<RemoteCloudServer> call() throws Exception {
        HttpResponse response;
        HttpGet get = new HttpGet(String.format(FETCH_URL, "1.7.10-1.6"));
        get.setConfig(httpConfig);
        try {
            response = this.httpClient.execute((HttpUriRequest)get);
        }
        catch (IOException e) {
            throw new CloudException("gui.cloudnetwork.error.unreachable");
        }
        HttpEntity entity = response.getEntity();
        if (response.getStatusLine() == null) {
            throw new CloudException("gui.cloudnetwork.error.unreachable");
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 500 && statusCode < 600) {
            throw new CloudException("gui.cloudnetwork.error.server_error");
        }
        String json = EntityUtils.toString((HttpEntity)entity);
        EntityUtils.consumeQuietly((HttpEntity)entity);
        ArrayList<RemoteCloudServer> clouds = new ArrayList<RemoteCloudServer>();
        try {
            JsonElement element = this.parser.parse(json);
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                if (obj.has("error")) {
                    throw new CloudException(obj.get("error").getAsString());
                }
            } else {
                for (JsonElement item : element.getAsJsonArray()) {
                    JsonObject obj = (JsonObject)item;
                    String name = obj.get("name").getAsString();
                    String description = obj.get("description").getAsString();
                    String ip = obj.get("ip").getAsString();
                    String mods = obj.get("mods").getAsString();
                    boolean isSponsored = obj.get("isSponsored").getAsBoolean();
                    clouds.add(new RemoteCloudServer(name, description, ip, mods, isSponsored));
                }
            }
        }
        catch (Exception e) {
            if (e instanceof CloudException) {
                throw e;
            }
            throw new CloudException("gui.cloudnetwork.error.parse_error", e);
        }
        Collections.sort(clouds);
        return clouds;
    }

    public class CloudException
    extends Exception {
        public CloudException(String message) {
            super(message);
        }

        public CloudException(String message, Exception e) {
            super(message, e);
        }
    }
}

