/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.client.gui.cloud;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import cpw.mods.fml.client.FMLClientHandler;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.aetherteam.aether.client.gui.GuiCustomScreen;
import net.aetherteam.aether.client.gui.GuiFlatButton;
import net.aetherteam.aether.client.gui.cloud.FetchCloudsCallable;
import net.aetherteam.aether.client.gui.cloud.GuiCloudButton;
import net.aetherteam.aether.client.gui.cloud.RemoteCloudServer;
import net.aetherteam.aether.client.gui.util.GuiPanoramaScreen;
import net.aetherteam.aether.client.gui.util.GuiTextBox;
import net.aetherteam.aether.client.gui.util.Text;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.network.OldServerPinger;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiCloudNetwork
extends GuiPanoramaScreen {
    protected static final ResourceLocation REFRESH_TEXTURE = new ResourceLocation("aether", "textures/gui/cloud/refresh.png");
    protected static final String TEXT_SEPERATOR = System.getProperty("line.separator") + System.getProperty("line.separator");
    protected static final ThreadPoolExecutor threadPool = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Cloud Server Pinger #%d").setDaemon(true).build());
    protected static final int REFRESH_DELAY = 1500;
    protected static ExecutorService executorService = Executors.newSingleThreadExecutor();
    protected static OldServerPinger serverPinger = new OldServerPinger();
    protected static int refreshTick;
    protected int screenYOffset;
    protected int descXOffset = 130;
    protected GuiButton backButton;
    protected GuiButton connectButton;
    protected GuiButton refreshButton;
    protected GuiButton backPage;
    protected GuiButton forwardPage;
    protected GuiCloudButton selectedCloud;
    protected GuiTextBox serverDescription;
    protected Text cloudIntro;
    private Future<List<RemoteCloudServer>> fetchCloudsFuture;
    private List<RemoteCloudServer> clouds = new ArrayList<RemoteCloudServer>();
    private String errorMessage;
    private boolean hasInitServers;
    private int serversPerPage;
    private int pageIndex;
    private int pageAmount = 1;
    private int serversCountWidth;
    private int serverCountHeight;
    private int serverAmount;
    private int prevServerAmount;
    private boolean firstInit = true;
    private long lastRefresh;

    public GuiCloudNetwork(GuiScreen parent) {
        this.parent = parent;
        FMLClientHandler.instance().setupServerList();
    }

    @Override
    public void func_73866_w_() {
        this.backButton = new GuiFlatButton(3, 25, this.field_146295_m - 35, 80, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]));
        this.connectButton = new GuiFlatButton(4, 25, this.field_146295_m - 65, 80, 20, I18n.func_135052_a((String)"multiplayer.connect", (Object[])new Object[0]));
        this.refreshButton = new GuiFlatButton(5, 25, this.field_146295_m - 65, 80, 20, I18n.func_135052_a((String)"selectServer.refresh", (Object[])new Object[0]));
        this.backPage = new GuiFlatButton(1, this.field_146294_l - 145, 10 + this.screenYOffset, 20, 20, "<");
        this.forwardPage = new GuiFlatButton(2, this.field_146294_l - 50, 10 + this.screenYOffset, 20, 20, ">");
        this.backPage.field_146125_m = false;
        this.forwardPage.field_146125_m = false;
        this.connectButton.field_146125_m = false;
        this.cloudIntro = new Text("\u00a7o\u00a7lWelcome to the Aether II Cloud Network!\u00a7r" + TEXT_SEPERATOR + "This page is made up of a bunch of multiplayer servers running the Aether II that have opted in to the Network. All you have to do is select a Cloud above and click 'Connect'!" + TEXT_SEPERATOR + "For more information, including how to list your server on the Cloud Network, visit " + EnumChatFormatting.AQUA + "go.aetherii.com/CloudNetwork" + EnumChatFormatting.WHITE + ".", 1.0f);
        this.serverDescription = new GuiTextBox(this.field_146294_l - 165, 60, true, this.cloudIntro);
        this.selectedCloud = null;
        if (this.firstInit) {
            this.fetchClouds();
            this.firstInit = false;
        }
        if (this.hasInitServers) {
            this.refreshServerButtons();
        }
        super.func_73866_w_();
    }

    @Override
    public void func_146286_b(int mouseX, int mouseY, int which) {
        this.serverDescription.mouseReleased(mouseX, mouseY, which);
        super.func_146286_b(mouseX, mouseY, which);
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int which) {
        this.serverDescription.mousePressed(this.field_146297_k, mouseX, mouseY);
        super.func_73864_a(mouseX, mouseY, which);
    }

    public void refreshServerButtons() {
        int buttonAreaWidth = 90;
        int buttonAreaHeight = 50;
        this.serversCountWidth = (this.field_146294_l - 30) / buttonAreaWidth;
        this.serverCountHeight = (this.field_146295_m - 150 - this.screenYOffset) / buttonAreaHeight;
        this.serversPerPage = this.serversCountWidth * this.serverCountHeight;
        this.serverAmount = this.clouds.size();
        this.pageAmount = Math.max(1, MathHelper.func_76143_f((double)((double)this.serverAmount / (double)this.serversPerPage)));
        if (this.pageIndex + 1 > this.pageAmount) {
            this.pageIndex = this.pageAmount - 1;
        }
        if (this.pageIndex < 0) {
            this.pageIndex = 0;
        }
        this.field_146292_n.clear();
        this.addButtons(this.field_146294_l, this.field_146295_m);
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.backPage.field_146127_k) {
                this.pageIndex = Math.max(this.pageIndex - 1, 0);
                this.refreshServerButtons();
            }
            if (button.field_146127_k == this.forwardPage.field_146127_k) {
                this.pageIndex = Math.min(this.pageIndex + 1, this.pageAmount - 1);
                this.refreshServerButtons();
            }
            if (button.field_146127_k == this.backButton.field_146127_k) {
                this.field_146297_k.func_147108_a(this.parent);
            }
            if (button.field_146127_k == this.connectButton.field_146127_k && this.selectedCloud != null) {
                if (this.field_146297_k.field_71441_e != null) {
                    this.field_146297_k.field_71441_e.func_72882_A();
                    this.field_146297_k.func_71403_a(null);
                }
                RemoteCloudServer server = this.selectedCloud.getCloudServer();
                FMLClientHandler.instance().connectToServer((GuiScreen)this, server.getServerData());
            }
            if (button.field_146127_k == this.refreshButton.field_146127_k) {
                this.fetchClouds();
                this.refreshServerButtons();
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (!this.hasInitServers && this.fetchCloudsFuture.isDone()) {
            try {
                this.clouds = this.fetchCloudsFuture.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                Throwable cause = e.getCause();
                this.errorMessage = cause != null ? cause.getMessage() : e.getMessage();
                this.hasInitServers = true;
                return;
            }
            this.refreshServerButtons();
            for (final RemoteCloudServer server : this.clouds) {
                threadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            serverPinger.func_147224_a(server.getServerData());
                        }
                        catch (UnknownHostException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            this.hasInitServers = true;
        }
        this.refreshButton.field_146124_l = this.lastRefresh + 1500L <= System.currentTimeMillis();
        serverPinger.func_147223_a();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.refreshButton.func_146115_a() && !this.refreshButton.field_146124_l) {
            this.tooltip = "Please wait before refreshing again.";
        }
        if (this.pageAmount <= 1) {
            this.backPage.field_146125_m = false;
            this.forwardPage.field_146125_m = false;
        } else {
            this.backPage.field_146125_m = true;
            this.forwardPage.field_146125_m = true;
            GuiCustomScreen.renderCenteredText("Page " + (this.pageIndex + 1) + " / " + this.pageAmount, this.field_146294_l - 88, 16 + this.screenYOffset, 1.0f);
        }
        if (this.errorMessage != null) {
            GuiCloudNetwork.renderCenteredText(I18n.func_135052_a((String)this.errorMessage, (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 5, 1.0f);
        } else if (!this.hasInitServers && !this.fetchCloudsFuture.isDone()) {
            GuiCloudNetwork.renderRefreshing(this.field_146294_l / 2, this.field_146295_m / 2, 1.0f);
            GuiCloudNetwork.renderCenteredText(I18n.func_135052_a((String)"gui.cloudnetwork.status.refreshing", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 5, 1.0f);
        } else if (this.hasInitServers && this.clouds.size() <= 0) {
            GuiCloudNetwork.renderCenteredText(I18n.func_135052_a((String)"gui.cloudnetwork.status.empty", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 5, 1.0f);
        } else if (this.hasInitServers) {
            GuiCustomScreen.renderText(I18n.func_135052_a((String)"gui.cloudnetwork.indicator.online_clouds", (Object[])new Object[]{this.serverAmount}), 33, 15, 1.0f);
            if (this.selectedCloud != null) {
                RemoteCloudServer server = this.getSelectedCloud().getCloudServer();
                GuiCustomScreen.renderText("\u00a7l" + server.getName(), this.descXOffset, this.field_146295_m - 10 - this.serverDescription.boxHeight - 15, 1.0f);
                this.serverDescription.setText(new Text(EnumChatFormatting.GRAY + "Description: " + EnumChatFormatting.RESET + server.getDescription() + TEXT_SEPERATOR + EnumChatFormatting.GRAY + "Mods Loaded: " + EnumChatFormatting.RESET + server.getMods()));
                this.connectButton.field_146125_m = true;
                this.refreshButton.field_146125_m = false;
            } else {
                this.serverDescription.setText(this.cloudIntro);
                this.connectButton.field_146125_m = false;
                this.refreshButton.field_146125_m = true;
            }
            this.serverDescription.render(this.descXOffset, this.field_146295_m - 10 - this.serverDescription.boxHeight, mouseX, mouseY);
            if (this.tooltip != null) {
                FontRenderer font = this.field_146297_k.field_71466_p;
                this.drawHoveringText(Collections.singletonList(this.tooltip), mouseX, mouseY, font == null ? this.field_146289_q : font);
                GL11.glDisable((int)2896);
            }
            this.tooltip = null;
        }
    }

    @Override
    protected void renderSkybox(int par1, int par2, float par3) {
        super.renderSkybox(par1, par2, par3);
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, 0x44000000, 0x44000000);
    }

    @Override
    public void addButtons(int x, int y) {
        int serversOnPage = this.serversPerPage;
        int serverAmountSoFar = this.serversPerPage * this.pageIndex;
        if (this.pageIndex + 1 >= this.pageAmount) {
            serversOnPage = this.serverAmount - serverAmountSoFar;
        }
        int serverCount = 0;
        for (int heightCount = 0; heightCount < this.serverCountHeight; ++heightCount) {
            for (int widthCount = 0; widthCount < this.serversCountWidth; ++widthCount) {
                if (serverCount < serversOnPage && serverCount < this.serversPerPage) {
                    RemoteCloudServer server = this.clouds.get(serverCount + serverAmountSoFar);
                    GuiCloudButton cloudButton = new GuiCloudButton(this, 0, 30 + widthCount * 90, 50 + heightCount * 50 + this.screenYOffset, server);
                    this.addButton(cloudButton);
                }
                ++serverCount;
            }
        }
        this.addButton(this.backPage);
        this.addButton(this.forwardPage);
        this.addButton(this.backButton);
        this.addButton(this.connectButton);
        this.addButton(this.refreshButton);
    }

    @Override
    public ResourceLocation[] getPanoramaPaths() {
        return new ResourceLocation[]{new ResourceLocation("aether", "textures/main_menu/aetherii/panorama/panorama0.png"), new ResourceLocation("aether", "textures/main_menu/aetherii/panorama/panorama1.png"), new ResourceLocation("aether", "textures/main_menu/aetherii/panorama/panorama2.png"), new ResourceLocation("aether", "textures/main_menu/aetherii/panorama/panorama3.png"), new ResourceLocation("aether", "textures/main_menu/aetherii/panorama/panorama4.png"), new ResourceLocation("aether", "textures/main_menu/aetherii/panorama/panorama5.png")};
    }

    public static void renderRefreshing(int x, int y, float scale) {
        GL11.glPushMatrix();
        int width = 50;
        int height = 42;
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslated((double)((float)x - scale * (float)halfWidth), (double)((float)y - scale * (float)halfHeight), (double)0.0);
        GL11.glTranslated((double)halfWidth, (double)halfHeight, (double)0.0);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)refreshTick++, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)(-halfWidth), (double)(-halfHeight), (double)0.0);
        GuiCloudNetwork.renderTexture(REFRESH_TEXTURE, 0, 0, width, height);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void fetchClouds() {
        serverPinger.func_147226_b();
        this.clouds = new ArrayList<RemoteCloudServer>();
        this.errorMessage = null;
        this.hasInitServers = false;
        this.lastRefresh = System.currentTimeMillis();
        if (this.fetchCloudsFuture != null) {
            this.fetchCloudsFuture.cancel(true);
        }
        FetchCloudsCallable callable = new FetchCloudsCallable();
        this.fetchCloudsFuture = executorService.submit(callable);
    }

    public GuiCloudButton getSelectedCloud() {
        return this.selectedCloud;
    }

    public void setSelectedCloud(GuiCloudButton cloud) {
        this.selectedCloud = cloud;
    }
}

