/*
 * Decompiled with CFR 0.152.
 */
package net.aetherteam.aether.client.gui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.aetherteam.aether.client.gui.util.GuiSlider;
import net.aetherteam.aether.client.gui.util.IHeightProvider;
import net.aetherteam.aether.client.gui.util.Text;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;

public class GuiTextBox
extends Gui
implements IHeightProvider {
    private Text[] texts;
    public int boxWidth;
    public int boxHeight;
    public int totalHeight;
    public static Minecraft mc = Minecraft.func_71410_x();
    public static FontRenderer fontRendererObj = GuiTextBox.mc.field_71466_p;
    public GuiSlider slider;
    public boolean centered = false;
    public boolean useSlider = false;
    public boolean enableScissor = true;
    private final ArrayList<Text> finalSplitStrings = new ArrayList();
    public float scale = 1.0f;

    public GuiTextBox(int boxWidth, int boxHeight, boolean useSlider, Text ... text) {
        this.texts = text;
        this.boxWidth = boxWidth;
        this.boxHeight = boxHeight;
        this.slider = new GuiSlider(this, -1, 0, 0, 10, this.boxHeight);
        this.useSlider = useSlider;
        this.init();
    }

    public GuiTextBox(int boxWidth, int boxHeight, Text ... text) {
        this(boxWidth, boxHeight, false, text);
    }

    public void setText(Text ... text) {
        this.texts = text;
        this.init();
    }

    public void init() {
        ArrayList stringList = new ArrayList();
        this.finalSplitStrings.clear();
        this.totalHeight = 0;
        for (Text text : this.texts) {
            if (text == null || text.string == null) continue;
            String[] strings = text.string.split(System.getProperty("line.separator"));
            stringList.clear();
            Collections.addAll(stringList, strings);
            for (String string : stringList) {
                List newStrings = fontRendererObj.func_78271_c(string, (int)((float)this.boxWidth / text.scale));
                for (Object o : newStrings) {
                    if (!(o instanceof String)) continue;
                    this.finalSplitStrings.add(new Text((String)o, text.scale));
                }
            }
            this.totalHeight += (int)((float)(this.finalSplitStrings.size() * 10) * text.scale);
        }
        this.useSlider = this.totalHeight >= this.boxHeight;
    }

    public void renderText(String text, int x, int y, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x - (float)x * scale), (float)((float)y - (float)y * scale), (float)1.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        this.func_73731_b(fontRendererObj, text, x, y, 0xFFFFFF);
        GL11.glPopMatrix();
    }

    public void renderCenteredText(String text, int x, int y, float scale) {
        this.renderText(text, x - (int)(this.scale * (float)fontRendererObj.func_78256_a(text) / 2.0f), y, scale);
    }

    public void mouseReleased(int mouseX, int mouseY, int which) {
        if (this.totalHeight > this.boxHeight && this.useSlider) {
            this.slider.mouseReleased(mouseX, mouseY, which);
        }
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        return this.totalHeight > this.boxHeight && this.useSlider && this.slider.func_146116_c(mc, mouseX, mouseY);
    }

    public void render(int x, int y, int mouseX, int mouseY) {
        ScaledResolution scaledRes = new ScaledResolution(mc, GuiTextBox.mc.field_71443_c, GuiTextBox.mc.field_71440_d);
        int scaleFactor = scaledRes.func_78325_e();
        int scHeight = scaledRes.func_78328_b();
        int sliderOffset = this.boxWidth + 1;
        this.slider.field_146128_h = x + sliderOffset;
        this.slider.field_146129_i = y;
        int yFactor = Math.abs(y - scHeight) - this.boxHeight;
        int cornerX = x * scaleFactor;
        int cornerY = yFactor * scaleFactor;
        int cutWidth = this.boxWidth * scaleFactor;
        int cutHeight = this.boxHeight * scaleFactor;
        if (this.enableScissor) {
            GL11.glEnable((int)3089);
            if (this.centered) {
                GL11.glScissor((int)(cornerX - cutWidth / 2), (int)cornerY, (int)cutWidth, (int)cutHeight);
            } else {
                GL11.glScissor((int)cornerX, (int)cornerY, (int)cutWidth, (int)cutHeight);
            }
        }
        GL11.glPushMatrix();
        int textHeight = 0;
        float sliderValue = 0.0f;
        if (this.totalHeight > this.boxHeight && this.useSlider) {
            sliderValue = -this.slider.sliderValue * (float)(this.totalHeight - this.boxHeight);
        }
        GL11.glTranslatef((float)0.0f, (float)sliderValue, (float)0.0f);
        for (Text text : this.finalSplitStrings) {
            if (this.centered) {
                this.renderCenteredText(text.string, x, y + textHeight, text.scale);
            } else {
                this.renderText(text.string, x, y + textHeight, text.scale);
            }
            textHeight = (int)((float)textHeight + 10.0f * text.scale);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)3089);
        if (this.totalHeight > this.boxHeight && this.useSlider) {
            this.slider.onUpdate();
            this.slider.func_146112_a(mc, mouseX, mouseY);
        }
    }

    public int getSentencesSize() {
        return this.finalSplitStrings.size();
    }

    @Override
    public int getAllHeight() {
        return this.boxHeight;
    }
}

